package com.xiaomai.cases.polar.clue;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.Random;

/**
 * @Author zxy
 * @Description
 * @Date 2024/7/1 10:09
 */
public class TestContinueFeedback extends XMBaseTest {
    MemberTools memberTools = new MemberTools();
    String memberId;
    String feedbackId;
    String feedbackId1;
    int num;
    int len;

    @BeforeMethod
    public void beforeTest(){

        xmAppApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_continueFeedback")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("zyx")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "继续跟进")
    public void testModifyFeedback(){
        String name = "自动化潜在会员"+ RandomStringUtil.randomString(3);
        String phone = RandomStringUtil.randomMobile("666");

        //若全部线索有数据，则取第一条数据；若无数据则新建一个线索
        JSONArray array = memberTools.searchMember("全部线索","POTENTIAL").getJSONObject("result").getJSONArray("records");
        int size = array.size();
        if(size == 0){
            memberId = memberTools.create(name,phone).getString("result");
        }
        else {
            memberId = array.getJSONObject(0).getString("id");
        }

        //查询该线索的跟进,若存在待跟进/已逾期的跟进任务，则取列表第一条数据；不存在待跟进/已逾期的跟进任务，则新建一条待跟进的跟进任务
        JSONArray jsonArray = memberTools.listTodoTask(memberId).getJSONArray("result");
        num  = jsonArray.size();
        if (num == 0) {
            feedbackId1 = memberTools.createFeedback(memberId).getString("result");
            feedbackId = memberTools.listTodoTask(memberId).getJSONArray("result").getJSONObject(0).getString("id");
        }
        else {
            feedbackId = jsonArray.getJSONObject(0).getString("id");
        }

        //该线索的状态为已完成的跟进任务数
        len  = memberTools.searchFeedback(memberId).getJSONObject("result").getJSONArray("records").size();

        Random random = new Random();
        String[] feedbackMethod = {"PHONE","WECHAT","SMS","VISIT","OTHERS"};
        String[] feedbackResult = {"CONTACTED","INTENTION_CONFIRMED","APPOINTED","EXPERIENCED","REGISTERED","REGISTERED","RENEW_FOLLOW"};

        //继续跟进
        JSONObject object = new JSONObject();
        object.put("feedbackId",feedbackId);
        object.put("feedbackContent","自动化测试继续跟进，只生成一条已完成的跟进");
        object.put("memberId",memberId);
        object.put("feedbackMethod",feedbackMethod[random.nextInt(5)]);
        object.put("feedbackResult",feedbackResult[random.nextInt(7)]);
        object.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        object.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        object.put("operatorId", xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON,params,object.toString(),headers).assetsSuccess(true);
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {

        }
        JSONArray json = memberTools.searchFeedback(memberId).getJSONObject("result").getJSONArray("records");
        int len1 = json.size();
        Assert.assertEquals(len1,len+1);
    }


    @Test(description = "删除跟进",priority = 1)
    public void del()
    {
        memberTools.deleteFeedback(feedbackId);
        if(feedbackId1 != null) {
            memberTools.deleteFeedback(feedbackId1);
        }
    }
}
