package com.xiaomai.cases.polar.memberCard;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestModifySharers extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_modifySharers")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yj")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "添加移除共享人")
    public void testmodifySharers() {
        CardTools Cardtools = new CardTools();
        Cardtools.membercardsearch("NORMAL");

        String memberCardId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].id");//拿售卖记录第一张会员卡的ID;

        JSONArray sharerIds=new JSONArray();
        sharerIds.add("1807334217474027521");




        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sharerIds",sharerIds);
        jsonObject.put("memberCardId",memberCardId);
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());



        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);
        Cardtools.membercardfindDetailById(memberCardId);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.sharers.id"),"[\"1807334217474027521\"]","添加共享人后，核对会员卡有对应共享人");

    }
    @Test(description = "移除移除共享人")
    public void testmodifySharers1() {
        CardTools Cardtools = new CardTools();
        Cardtools.membercardsearch("NORMAL");

        String memberCardId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].id");//拿售卖记录第一张会员卡的ID;

        //JSONArray sharerIds=new JSONArray();
        //sharerIds.add();

        JSONObject jsonObject = new JSONObject();
        //jsonObject.put("sharerIds",sharerIds);//空共享人
        jsonObject.put("memberCardId",memberCardId);
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());



        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);
        Cardtools.membercardfindDetailById(memberCardId);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.sharers.id"),"[]","移除共享人后，核对会员卡下无共享人");

    }
}
