package com.xiaomai.cases.polar.memberCard;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestModifyXcxSaleState extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_modifyXcxSaleState")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yj")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "关闭会员卡售卖")
    public void testmodifyXcxSaleState() {
        CardTools Cardtools = new CardTools();
        Cardtools.fetchPageOfMemberCard("MEMBER_CARD");
        String memberCardId = "";
        String xcxSaleStatus;
        //先检查次下列表有没有数据，有数据才会执行下面的点代码（如果是个空机构，肯定不会被执行，想从存量数据中获取，需要自己先造个数据）
        int listDatas = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.records").size();
        if (listDatas > 0) {
            memberCardId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].id");
            //取出第一个数据后，要check下会员卡的售卖状态，想停用，要保证卡的状态目前就是停售状态
            xcxSaleStatus=XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].xcxSaleStatus");
            //如果不是启用状态，则开启
            if(xcxSaleStatus.equals("NO")){


                Cardtools.modifyXcxSaleState(memberCardId,"YES");
            }

            JSONObject jsonObject = new JSONObject();
            jsonObject.put("xcxSaleState","NO");
            jsonObject.put("memberCardId", memberCardId);
            jsonObject.put("brandId", xmAppApi.getLoginInfo().getBrandId());
            jsonObject.put("studioId", xmAppApi.getLoginInfo().getStudioId());
            jsonObject.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
            xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);

            //check 会员卡详情，查看状态是否是下架状态

            Cardtools.fetchDetailById(memberCardId);
            Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.xcxSaleStatus"),"NO","操作停用会员卡后，查看卡详情，卡启用状态没变更为NO");

        }
    }
    @Test(description = "启用会员卡")
    public void testmodifyShelfState1() {
        CardTools Cardtools = new CardTools();
        Cardtools.fetchPageOfMemberCard("MEMBER_CARD");
        String memberCardId = "";
        String xcxSaleStatus;
        int listDatas = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.records").size();
        if (listDatas > 0) {
            memberCardId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].id");
            xcxSaleStatus = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].xcxSaleStatus");
            if (xcxSaleStatus.equals("YES")) {

                Cardtools.modifyXcxSaleState(memberCardId,"NO");
            }
            JSONObject jsonObject = new JSONObject();

            jsonObject.put("xcxSaleState", "YES");
            jsonObject.put("memberCardId", memberCardId);
            jsonObject.put("brandId", xmAppApi.getLoginInfo().getBrandId());
            jsonObject.put("studioId", xmAppApi.getLoginInfo().getStudioId());
            jsonObject.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
            xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);

            //check 会员卡详情，查看状态是否是上架状态
            Cardtools.fetchDetailById(memberCardId);
            Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.xcxSaleStatus"), "YES", "操作启用会员卡后，查看卡详情，卡启用状态没变更为YES");


        }
    }
}
