package com.xiaomai.cases.polar.memberCard;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.memberCard.CardTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;

public class TestCardDel extends XMBaseTest {

    @Resource(name = "cardTools")
    CardTools cardTools;

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_tenantMemberCard_delete")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yj")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "删除卡")
    public void testCardDel() throws InterruptedException {
        cardTools.memberCardCreate("会员卡-需要删除");//创建会员卡
        String memberCardId= XMJSONPath.readPath(dataApi.getApi_response(),"$.result");//获取会员卡ID
        cardTools.tenantMemberCard_delete(memberCardId);//删除会员卡

        cardTools.fetchDetailById(memberCardId);//查看已删除会员卡详情
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.deleted"), "YES", "目标会员卡，未删除成功");//断言已删除的会员卡详情，返回已删除字段

        String memberCardId1="1894024199604604929";//已有出售记录的会员卡。随机找了一张
        cardTools.tenantMemberCard_delete(memberCardId1);//删除已出售的会员卡会员卡
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.message"), "该卡项已售出，不可删除！", "已出售的会员卡居然删除了");//断言已出售的会员卡，无法删除



        String prizeName = "体验卡-需要删除";
        JSONObject benefit = new JSONObject();
        benefit.put("identifier", RandomStringUtil.randomString(20));
        benefit.put("benefitType", "BALANCE");
        benefit.put("targetScope","GROUP_CLASS_AND_PERSONAL_COURSE");
        benefit.put("balance","3");//使用次数
        benefit.put("reserveLimitType","UN_LIMIT");//预约次数限制：不限制
        benefit.put("reserveLimitNumber",0);
        benefit.put("defaultConsumeBalance",1);//扣除次数
        benefit.put("itemList",new JSONArray());
        benefit.put("targetType","COURSE");
        benefit.put("price","10");

        Thread.sleep(3000);//前面创建过会员卡，加上防止调用频繁
        String prizeId = cardTools.experienceCardCreate(prizeName,"10",benefit);

        cardTools.tenantMemberCard_delete(prizeId);//删除体验卡

        cardTools.fetchDetailById(prizeId);//查看已删除会员卡详情
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.deleted"), "YES", "目标会员卡，未删除成功");//断言已删除的体验卡详情，返回已删除字段

        String prizeId1="1897439567449800706";//已有出售记录的会员卡。随机找了一张
        cardTools.tenantMemberCard_delete(prizeId1);//删除已出售的会员卡会员卡
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.message"), "该卡项已售出，不可删除！", "已出售的体验看居然删除了");//断言已出售的体验卡，无法删除

        Thread.sleep(3000);
        cardTools.depositCardCreate("储值卡-需要删除" ,"0.00","100.00");//创建储值卡
        String cardId= XMJSONPath.readPath(dataApi.getApi_response(),"$.result");
        cardTools.tenantMemberCard_delete(cardId);//删除储值卡

        cardTools.fetchDetailById(cardId);//查看已删除会员卡详情
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.deleted"), "YES", "目标会员卡，未删除成功");//断言已删除的储值卡详情，返回已删除字段

        String cardId1="1875017334458486785";//已有出售记录的会员卡。随机找了一张
        cardTools.tenantMemberCard_delete(cardId1);//删除已出售的会员卡会员卡
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.message"), "该卡项已售出，不可删除！", "已出售的体验看居然删除了");//断言已出售的体验卡，无法删除




    }


}
