package com.xiaomai.cases.polar.memberCard;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.finance.order.OrderTools;
import com.xiaomai.cases.polar.member.Tools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class TestCreateTerm extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_tenantMemberCard_create")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yj")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "创建期限卡")
    public void testCreateTerm() throws InterruptedException {
        CardTools Cardtools = new CardTools();
        JSONArray activatePatternList = new JSONArray();
        activatePatternList.add("PURCHASE");
        activatePatternList.add("SPECIFIC_DATE");
        activatePatternList.add("FIRST_USED");

        List benefitList = new ArrayList();
        //List itemList = new ArrayList();
        //itemList.add("");
        JSONObject Object = new JSONObject();
        Object.put("identifier", RandomStringUtil.randomString(20));
        Object.put("benefitType", "PERIOD");//期限卡
        Object.put("targetScope", "GROUP_CLASS_AND_PERSONAL_COURSE");
        Object.put("balance", "30");
        Object.put("reserveLimitType", "UN_LIMIT");
        Object.put("reserveLimitNumber", 0);
        Object.put("defaultConsumeBalance", 1);
        //Object.put("itemList", itemList);
        Object.put("targetType", "COURSE");
        Object.put("price","1");
        benefitList.add(Object);

        String title="期限-自动化会员卡"+RandomStringUtil.randomString(4);


        JSONObject jsonObject = new JSONObject();
        jsonObject.put("surfaceUrl", "https://image.xiaomaiketang.com/xm/internal/HpRiJpFnTC.png");//会员卡封面图片
        jsonObject.put("surfaceCornerMark", "自动化标签");
        jsonObject.put("title", title);//会员卡名称 不能重复要加东西 "次卡-自动化会员卡"+RandomStringUtil.randomString(3)
        jsonObject.put("validPeriod", "3");//有效期-3天
        jsonObject.put("activatePatternList", activatePatternList);//三种生效方式
        jsonObject.put("sharePeopleLimit", "2");//共享人数
        jsonObject.put("benefitList", benefitList);//使用权益
        jsonObject.put("price", "1");//价格
        jsonObject.put("underlinePrice", "10");//划线价
        jsonObject.put("purchaseNumberLimit", "-1");//购买数量限制
        jsonObject.put("xcxSaleStatus", "YES");//小程序是否售卖
        jsonObject.put("creatorId", xmAppApi.getLoginInfo().getAdminId());
        jsonObject.put("shelfState", "YES");//卡启用状态
        jsonObject.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("description", "{\"items\":[{\"content\":\"自动化创建的期限卡\",\"aspect\":\"\",\"type\":\"TEXT\"}]}");
        jsonObject.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
        jsonObject.put("commodityCardType","MEMBER_CARD");

        Thread.sleep(3000);//防止调用频繁
        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);
        //String cardId= XMJSONPath.readPath(dataApi.getApi_response(),"$.result");//期限卡ID
        Cardtools.fetchPageOfMemberCard("MEMBER_CARD");//会员卡第一张
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].benefitList[0].benefitType"), "PERIOD", "创建的非期限卡");//类型为期限卡




        OrderTools orderTools = new OrderTools();
        Tools tools=new Tools();
        String name = "创建数据中心潜在会员"+ RandomStringUtil.randomString(3);
        String phone = RandomStringUtil.randomMobile("111");
        String memberId = tools.create(name,phone).getString("result");

        JSONObject memberCard=orderTools.fetchPageOfMemberCard(title,"MEMBER_CARD");
        String cardId=memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");
        //BigDecimal quantity= XMJSONPath.readPath(dataApi.getApi_response(), "$.result[0].validPeriod");//
        float price= Float.parseFloat(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("price"));
        int validPeriod= Integer.parseInt(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("validPeriod"));

        String latestSnapshotId=orderTools.fetchDetailById(cardId,xmAppApi.getLoginInfo().getBrandId(),xmAppApi.getLoginInfo().getStudioId(),xmAppApi.getLoginInfo().getAdminId()).getJSONObject("result").getString("latestSnapshotId");

        orderTools.signOrder(cardId, latestSnapshotId, new BigDecimal(3), price, validPeriod, latestSnapshotId, 0, "PURCHASE",
                "MEMBER_CARD", memberId, price , price , "1",true);//创建期限卡订单
        String id = XMJSONPath.readPath(dataApi.getApi_response(), "$.result");//获取订单id




        orderTools.fetchUserCardList("MEMBER",memberId,"NORMAL");//查看会员名下卡
        String cardid=XMJSONPath.readPath(dataApi.getApi_response(), "$.result[0].id");//获取售出卡id

        Cardtools.memberCardFindDetailById(cardid);//查看期限卡售卖记录详情
        int before = Integer.parseInt(XMJSONPath.readPath(Cardtools.memberCardFindDetailById(cardid), "$.result.leftEffectiveDays"));//初始期限卡剩余天数
        System.out.println("--------"+before);

        Cardtools.extendEffectiveDate("1",cardid);//延长期限卡有效期1天

        Cardtools.memberCardFindDetailById(cardid);//再次查看期限卡售卖记录详情
        int after = Integer.parseInt(XMJSONPath.readPath(Cardtools.memberCardFindDetailById(cardid), "$.result.leftEffectiveDays"));//延长后期限卡剩余天数
        System.out.println("--------"+after);

        Assert.assertEquals(after,before+1);//断言有效期加了一天

        Cardtools.batchExtEffectiveDate("MEMBER","1");//批量延长卡有效期 1天??
        Thread.sleep(3000);

        Cardtools.memberCardFindDetailById(cardid);//再次查看期限卡售卖记录详情
        int after1 = Integer.parseInt(XMJSONPath.readPath(Cardtools.memberCardFindDetailById(cardid), "$.result.leftEffectiveDays"));//延长后期限卡剩余天数
        Assert.assertEquals(after1,after+1);//断言有效期加了一天



        orderTools.discard(id,"订单录错","");//作废期限卡订单，新逻辑：未消耗的期限卡能直接作废订单
        orderTools.getDetail(id);//查看已作废订单详情
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.state"), "DISCARD", "作废期限卡订单成功未成功");//断言订单已作废





        Cardtools.fetchPageOfMemberCard("MEMBER_CARD");
        String memberCardId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].id");
        Cardtools.modifyMemberCardShelfState(memberCardId,"NO");//停卡

        Cardtools.fetchPageOfMemberCard("MEMBER_CARD");//会员卡第一张
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].shelfState"), "NO", "停卡未成功");//类型为期限卡

    }

}
