package com.xiaomai.cases.polar.invitationGifts;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.coupon.CouponTools;
import com.xiaomai.cases.polar.luckyDraw.LuckyDrawTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;

public class TestInvitationActivityDelete extends XMBaseTest {

    @Resource(name = "InvitationGiftsTools")
    InvitationGiftsTools InvitationGiftsTools;

    @Resource(name = "couponTools")
    CouponTools couponTools;


    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Invitation)
                .setApiName("API_invitationActivityDelete")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yangjian")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }


    @Test(description = "删除分享有礼活动")
    public void testInvitationActivityDelete(){
        JSONObject result1 =InvitationGiftsTools.invitationActivity_getStudioPage();//获取邀请有礼列表
        int before=Integer.parseInt(result1.getJSONObject("result").getString("total"));//列表当前有的邀请有礼数量

        String couponName = "邀请优惠券" + RandomStringUtil.randomString(5);//优惠券名称
        String activityName = "邀请有礼活动" + RandomStringUtil.randomString(5);//活动名称

        String couponId = couponTools.createStudioCoupon("WITHOUT",couponName,true);//创建优惠券，拿优惠券ID
        String activeId =InvitationGiftsTools.createInvitationActivity(activityName,"UNREGISTERED", TimeUtils.getTodayEndTime(),TimeUtils.getTodayTime(),false,couponId,couponId,couponId,couponId,"COUPON","COUPON","COUPON","COUPON").getString("result");//创建一个未发布的邀请有礼活动;
        InvitationGiftsTools.invitationActivity_getStudioPage1(activityName);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.total"), "1", "未搜索到目标邀请有礼活动");


        InvitationGiftsTools.getInvitationActivityDetail(activeId);//查看活动详情
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.state"), "UNPUBLISHED", "活动非未发布状态");//断言列表第一条为未发布的活动
        InvitationGiftsTools.invitationActivityPublish(activeId);//发布邀请有礼活动
        InvitationGiftsTools.getInvitationActivityDetail(activeId);//查看活动详情
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.state"), "PROCESSING", "活动发布失败");//断言列表第一条为进行中的活动

        InvitationGiftsTools.invitationActivity_getStudioPage();//获取邀请有礼列表
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].activityName"), activityName, "邀请有礼活动第一条非新建");//断言列表第一条为新建的活动的名字

        JSONObject result2 =InvitationGiftsTools.invitationActivity_getStudioPage();//获取邀请有礼列表
        int after=Integer.parseInt(result2.getJSONObject("result").getString("total"));//新建后列表中邀请有礼活动数量
        Assert.assertEquals(after,before+1);//新建邀请有礼后，列表活动数+1

        InvitationGiftsTools.invitationActivityEdit("UNREGISTERED",activeId, TimeUtils.getTodayEndTime(),TimeUtils.getTodayTime(),true,couponId,couponId,couponId,couponId,"COUPON","COUPON","COUPON","COUPON").getString("result");//编辑邀请有礼活动
        InvitationGiftsTools.invitationActivity_getStudioPage();
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].activityName"), "自动化-编辑邀请有礼", "邀请有礼活动第一条非新建");//断言列表第一条为编辑的活动的名字

        InvitationGiftsTools.invitationActivityInvalid(activeId);//失效邀请有礼活动
        InvitationGiftsTools.getInvitationActivityDetail(activeId);//查看是失效的邀请有礼活动
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.state"), "ABNORMAL", "活动失效失败");//断言列表第一条为失效的活动



        InvitationGiftsTools.invitationActivityDelete(activeId);//删除活动
        JSONObject result3 =InvitationGiftsTools.invitationActivity_getStudioPage();
        int after2=Integer.parseInt(result3.getJSONObject("result").getString("total"));//列表当前有的邀请有礼数量
        Assert.assertEquals(after2,before);//删除后回到最初条数
    }
}
