package com.xiaomai.cases.polar.setting.venue;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.setting.venue
 * @Author: xuyamei
 * @CreateTime: 2024-05-08  14:37
 * @Description: 删除场地
 * @Version: 1.0
 */
public class TestDeleteVenueArea extends BaseTestImpl {

    @Resource(name = "venueAreaTools")
    VenueAreaTools venueAreaTools;
    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Setting,"API_createVenueArea", LoginAccount.GYM_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @Test
    public void testCreateVenueArea() {
        // 新建之前查询列表数据
        JSONObject response = venueAreaTools.getVenueAreaPage();
        int beforeTotal = Integer.parseInt(response.getString("total"));

        String name = "瑜伽场地" + System.currentTimeMillis();
        String groupId = venueAreaTools.createVenueArea(name);

        // 删除场地
        venueAreaTools.deleteVenueArea(groupId);

        // check：删除之后查询列表数据
        response = venueAreaTools.getVenueAreaPage();
        int afterTotal = Integer.parseInt(response.getString("total"));
        Assert.assertEquals(afterTotal-beforeTotal, 0,"删除之后列表数据没有减少");
    }

}
