package com.xiaomai.cases.polar.studio;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.List;

public class TestEditBrand extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Studio)
                .setApiName("API_editBrand")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yj")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "编辑品牌信息")
    public void testeditBrand() {

        JSONObject Object1 = new JSONObject();
        Object1.put("content", "自动化文本");
        Object1.put("type", "TEXT");


        List intro = new ArrayList();
        intro.add(Object1);


        JSONObject jsonObject = new JSONObject();
        jsonObject.put("cover","1800412674735546369");
        jsonObject.put("intro",intro);
        jsonObject.put("logo","1800420544722051074");
        jsonObject.put("name","小麦乐动自动化场馆");
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);
        Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$code"),"200");

    }
}
