package com.xiaomai.cases.polar.training;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.finance.order.OrderTools;
import com.xiaomai.cases.polar.member.Tools;
import com.xiaomai.cases.polar.schedule.camp.SelectTargetTrainingCampAndGetInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;

/**
 * 构造报名训练营活动-待支付，然后操作删除训练营活动（fail）-取消订单-再次报名训练营活动（success）
 * @author adu
 * data 2024/7/22 16:38
 */

public class TestSignWaitingCampOrder extends SelectTargetTrainingCampAndGetInfo {
    @Resource(name = "trainingTools")
    TrainingTools trainingTools;
    @Resource(name = "tools")
    Tools tools;
    @Resource(name = "orderTools")
    OrderTools orderTools;
    String memberId = "";
    String orderId = "";


    @BeforeClass
    @Override
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Training, "API_signOrderCamp", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();
    }

    @Test(description = "给学员报名训练营活动构造待支付订单")
    public void testUnpaidOrder() throws InterruptedException {
        //搜索目标会员
        String phone = "15658063769";
        memberId = trainingTools.searchTargerMember(phone);
        if (memberId.isEmpty()) {
            memberId = tools.create("晨晨爸爸", phone).getString("result");
        }

        JSONObject body = new JSONObject();
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());

        body.put("salesmanId", xmAppApi.getLoginInfo().getAdminId());
        body.put("operationTime", TimeUtils.getCurrentTime());
        body.put("objectId", RandomStringUtil.randomString(20));
        body.put("memberId", memberId);
        body.put("receivableAmount", this.price);

        JSONObject campInfo = new JSONObject();
        campInfo.put("campId", campId);
        body.put("camp", campInfo);
        body.put("paymentWays", new JSONArray());//支付方式传空
        xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers).assetsSuccess(true);
        orderId = XMJSONPath.readPath(xmAppApi.getApi_response(), "$.result");
        //报名成功后根据会员手机号，在报名会员列表搜索报名数据
        trainingTools.getTrainingApplyRecordsList(this.campId, phone);
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").size() == 1, "给学员报名后，在报名列表没查询到数据");
        //check订单 待支付状态
        Assert.assertEquals(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").getJSONObject(0).getString("state"), "WAITING");

        //删除训练营活动:该训练营已有人报名，无法删除！
        trainingTools.delTrainingFail(this.campId);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.code"), "TRAINING_CAMP_DELETE_FAILED");
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.message"), "该训练营已有人报名，无法删除！");

        //操作取消订单
        orderTools.cancel(orderId);

        Thread.sleep(3000);

        //再次报名该训练营活动-报名成功
        trainingTools.doSignCampOrder(memberId, this.price, this.campId,"");
        String orderId1 = XMJSONPath.readPath(dataApi.getApi_response(), "$.result");

        //报名成功后根据会员手机号，在报名会员列表搜索报名数据
        trainingTools.getTrainingApplyRecordsList(this.campId, phone);
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").size() == 1, "给学员报名后，在报名列表没查询到数据");
        Assert.assertEquals(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").getJSONObject(0).getString("state"), "PAID");

        //作废订单，然后再报名，还可以报名check
        orderTools.discard(orderId1,"重复录入","自动化测试作废训练营订单");

        //订单作废后，学员还能继续报名check
        Thread.sleep(3000);
        trainingTools.doSignCampOrder(memberId, this.price, this.campId,"");
        String orderId2 = XMJSONPath.readPath(dataApi.getApi_response(), "$.result");

        //继续作废订单，然后删除训练营活动
        orderTools.discard(orderId2,"重复录入","自动化测试作废训练营订单");
        trainingTools.deleteTraining(campId);




    }
}

    