package com.xiaomai.cases.lunar.training;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.lunar.reserve.ReserveCTools;
import com.xiaomai.cases.lunar.user.UserTools;
import com.xiaomai.cases.polar.reserve.ReserveTools;
import com.xiaomai.cases.polar.setting.rules.RuleTools;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.Random;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.lunar.training
 * @Author: xuyamei
 * @CreateTime: 2024-08-01  10:18
 * @Description: 训练营签到（因训练营点名只能取存量数据，所以准备3个存量活动执行点名，超出3次抛出异常）
 * @Version: 1.0
 */
public class TestTrainingSign extends BaseTestImpl {
    @Resource(name = "trainingCTools")
    TrainingCTools trainTools;
    @Resource(name = "userTools")
    UserTools userTools;

    @Resource(name = "ruleTools")
    RuleTools ruleTools;
    @Resource(name = "reserveCTools")
    ReserveCTools reserveCTools;
    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Lunar_Reserve,"API_signInByScanCode", LoginAccount.GYM_MINIAPPC, Terminal.minApp,"xym");
        super.beforeTest();
    }

    @Test(description = "训练营签到")
    public void testTrainingSign(){
        DataUserInfo dataUserInfo = new DataUserInfo();
        dataUserInfo.setTerminal(Terminal.B);
        dataUserInfo.setLoginUser(LoginAccount.GYM_PROD);

        // 获取的微信用户
        String memberId = userTools.getMemberInfo().getString("memberId");
        // 获取训练营签到规则
        JSONObject getRules = ruleTools.getCampBookingRules(dataUserInfo); // 获取场馆团课预约规则
        String id = getRules.getString("id"); // 获取规则id
        // 因训练营课表列表无法查看到约课id，所以签到方式只取扫码签到
        ruleTools.saveCampBookingRules(id,true,true,999,dataUserInfo);
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        String scheduleId = "";
        JSONArray getMemberCampScheduleItemList = trainTools.getMemberCampScheduleItemList(TimeUtils.getTodayTime(),TimeUtils.getTodayEndTime(),memberId);
        boolean hasData = false;
        for (int j = 0; j < getMemberCampScheduleItemList.size(); j++){
            if (getMemberCampScheduleItemList.getJSONObject(j).getString("recordStatus").equals("TODO")){
                hasData = true;
                scheduleId = getMemberCampScheduleItemList.getJSONObject(j).getString("scheduleId");
            }
        }
        Assert.assertTrue(hasData,"存量已经没有可签到的训练营，请手动回归训练营手动签到和扫码签到");
        // 扫码签到
        reserveCTools.signInByScanCode(true,scheduleId,memberId);
        try {
            Thread.sleep(2000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        // check 1: 课次列表是已点名状态
        getMemberCampScheduleItemList = trainTools.getMemberCampScheduleItemList(TimeUtils.getTodayTime(),TimeUtils.getTodayEndTime(),memberId);
        for (int j = 0; j < getMemberCampScheduleItemList.size(); j++){
            if (getMemberCampScheduleItemList.getJSONObject(j).getString("scheduleId").equals(scheduleId)){
                Assert.assertEquals(getMemberCampScheduleItemList.getJSONObject(j).getString("recordStatus"),"DONE","签到失败");
            }
        }

        // check 2：查询小程序预约记录
        JSONArray getPageByMember = reserveCTools.getPageByMember("SIGNED","",TimeUtils.getTodayTime(),TimeUtils.getTodayEndTime(),memberId,"TRAINING_CAMP");
        boolean success = false;
        String reserveId = "";
        for(int i =0;i<getPageByMember.size();i++){
            if (getPageByMember.getJSONObject(i).getString("scheduleId").equals(scheduleId)){
                success = true;
                Assert.assertEquals(getPageByMember.getJSONObject(i).getString("signInState"),"SIGNED");
                reserveId = getPageByMember.getJSONObject(i).getString("id");
            }
        }
        Assert.assertTrue(success,"签到之后预约记录没有查询到相关信息");

        // check 3：查询小程序预约详情
        JSONObject getDetailById = reserveCTools.getReserveDetailById(reserveId);
        Assert.assertEquals(getDetailById.getString("signInState"),"SIGNED");

    }
}
