package com.xiaomai.cases.polar.reserve.personal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.reserve.ReserveTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.course
 * @Author: xuyamei
 * @CreateTime: 2024-04-25  11:43
 * @Description: 创建特定日期可约
 * @Version: 1.0
 */
public class TestCreateSpecialDate extends BaseTestImpl {
    @Resource(name = "reserveTools")
    ReserveTools reserveTools;
    @BeforeClass
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Reserve, "API_createSpecialDate", LoginAccount.GYM_PROD, Terminal.B, "xym");
        super.beforeTest();
    }

    @Test(description = "设置全天休息")
    public void testCreateSpecialDate_OFF() {
        JSONObject body = new JSONObject();
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        body.put("coachId",  xmAppApi.getLoginInfo().getAdminId());
        // 可约时间类型
        JSONObject specialTimeInfoRequest = new JSONObject();
        specialTimeInfoRequest.put("dutyType", "OFF_DUTY"); // 全天休息

        // 设置特定日期
        JSONArray specialTimeInfoRequestArray = new JSONArray();
        specialTimeInfoRequestArray.add(TimeUtils.getTodayTime());
        specialTimeInfoRequest.put("selectedDates", specialTimeInfoRequestArray);

        body.put("specialTimeInfoRequest", specialTimeInfoRequest);
        xmAppApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);

        try {
            Thread.sleep(2500);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        // 设置全天休息完成后检查个人时间是否有这条数据
        JSONArray specialTimeVOS = reserveTools.getPersonalCoachTime(xmAppApi.getLoginInfo().getAdminId(),"specialTimeVOS");
        boolean flag = false;
        for (int i = 0; i < specialTimeVOS.size(); i++){
            JSONObject specialTimeVO = specialTimeVOS.getJSONObject(i);
            if (specialTimeInfoRequestArray.getString(0).equals(specialTimeVO.getString("dutyDate"))){
                flag = true;
                Assert.assertEquals(specialTimeVO.getString("dutyType"),"-1","特殊日期类型错误");
            }
        }
        Assert.assertTrue(flag,"设置特殊日期全天休息后没有找到相关数据");
    }


    @Test(description = "设置特定日期可约",priority = 1)
    public void testCreateSpecialDate_ON() {
        try {
            Thread.sleep(3000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        JSONObject specialTimeInfoRequest = new JSONObject();
        // 可约时间类型
        specialTimeInfoRequest.put("dutyType", "ON_DUTY");

        // 设置特定日期
        JSONArray selectedDates = new JSONArray();
        selectedDates.add(TimeUtils.getTodayTime());
        specialTimeInfoRequest.put("selectedDates", selectedDates);

        // 如果是可约时间非全天休息，则传可约时间段
        // 时间段 00:00 ~ 23:59
        JSONArray timePeriodInfos = new JSONArray();
        JSONObject timeInfo = new JSONObject();
        timeInfo.put("minuteOffset", 0);
        timeInfo.put("spanMinutes", 1380);
        timePeriodInfos.add(timeInfo);
        specialTimeInfoRequest.put("timePeriodInfos", timePeriodInfos);

        reserveTools.createSpecialDate(xmAppApi.getLoginInfo().getAdminId(),"ON_DUTY",specialTimeInfoRequest);

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        // 设置特殊可约时间后检查个人私教时间是否有这条数据
        JSONArray specialTimeVOS = reserveTools.getPersonalCoachTime(xmAppApi.getLoginInfo().getAdminId(),"specialTimeVOS");
        boolean flag = false;
        for (int i = 0; i < specialTimeVOS.size(); i++){
            JSONObject specialTimeVO = specialTimeVOS.getJSONObject(i);
            if (selectedDates.getString(0).equals(specialTimeVO.getString("dutyDate"))){
                flag = true;
                Assert.assertEquals(specialTimeVO.getString("dutyType"),"1","特殊日期类型错误");
                Assert.assertTrue(specialTimeVO.getString("timePeriodInfos").equals(timePeriodInfos.toString()),"特殊日期可约时间段");

            }
        }
        Assert.assertTrue(flag,"设置特殊日期全天休息后没有找到相关数据");
    }

    @Test(description = "删除特殊日期",priority = 2)
    public void testDeleteSpecialDate() {
        // 查询特殊可约时间列表
        JSONArray specialTimeVOS = reserveTools.getPersonalCoachTime(xmAppApi.getLoginInfo().getAdminId(),"specialTimeVOS");

        for (int i = 0; i < specialTimeVOS.size(); i++){
            String id = specialTimeVOS.getJSONObject(i).getJSONArray("recordIds").getString(0);
            // 删除查询到的特殊可约时间
            reserveTools.deleteSpecialDate(id);
        }

        specialTimeVOS = reserveTools.getPersonalCoachTime(xmAppApi.getLoginInfo().getAdminId(),"specialTimeVOS");
        Assert.assertEquals(specialTimeVOS.size(),0,"删除特殊日期后，特殊日期列表不为空");

    }



}
