package com.xiaomai.cases.polar.admin;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.studioConfig.ConfigTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import javax.swing.*;
import java.util.Random;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.admin
 * @Author: xuyamei
 * @CreateTime: 2024-02-29  11:48
 * @Description: 新建员工
 * @Version: 1.0
 */
public class TestAddStudioAdmin extends BaseTestImpl {
    @Resource(name = "adminTools")
    AdminTools adminTools;

    @Resource(name = "configTools")
    ConfigTools configTools;

    @BeforeClass
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Admin,"API_addStudioAdmin", LoginAccount.GYM_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @Test(description = "添加员工，由于没有删除员工的操作，则每次随机取一个角色")
    public void testAddStudioAdmin(){
        String[] role = {"店长","教练","销售主管","财务","前台"};
        Random rand = new Random();
        JSONObject addRequest = adminTools.addStudioAdmin(role[rand.nextInt(5)]);
        // 添加角色成功后
        String result = dataApi.getBodyInJSON().getString("result");
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        // 查询员工详情内容
        JSONObject adminInfo = adminTools.getStudioAdmin(result);
        String[] resultString = {"name","phone","roles","teaching"};  // 新建之后验证相应的值
        for (int i = 0; i < resultString.length; i++){
            // check 1:创建员工时的值与查询员工详情时的值是否一致
            String checkResult = resultString[i].equals("roles") ? addRequest.getJSONArray("roles").getString(0) : addRequest.getString(resultString[i]);
            String expected = resultString[i].equals("roles") ? adminInfo.getJSONObject("result").getJSONArray(resultString[i]).getJSONObject(0).getString("code") : adminInfo.getJSONObject("result").getString(resultString[i]);
            Assert.assertEquals(checkResult,expected,"添加员工失败,员工详情与创建员工时的信息不一致");

        }
        try {
            Thread.sleep(2000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        // check 2: 生成对应的操作日志
        String body = "{\"current\":0,\"size\":10,\"domainId\":\""+xmAppApi.getLoginInfo().getStudioId()+"\",\"brandId\": \""+xmAppApi.getLoginInfo().getBrandId()+"\",\"studioId\": \""+xmAppApi.getLoginInfo().getStudioId()+"\",\"content\": \""+adminInfo.getJSONObject("result").getString("name")+"\",\"opEventKey\":\"ADD_ADMIN\"}";
        JSONObject response = configTools.getOpauditPage(body);
        Assert.assertEquals(response.getJSONObject("result").getJSONArray("records").getJSONObject(0).getJSONObject("target").getString("targetId"),result,"添加员工未生成操作日志");

    }

    @Test(description = "添加员工，由于没有删除员工的操作，则每次随机取一个角色")
    public void testAddStudioAdmin1(){
        for (int i = 0; i < 2; i++){
            JSONObject addRequest = adminTools.addStudioAdmin("教练");
        }
    }
}
