package com.xiaomai.cases.lunar.training;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.lunar.order.OrderCTools;
import com.xiaomai.cases.lunar.user.UserTools;
import com.xiaomai.cases.polar.finance.order.OrderTools;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.lunar.training
 * @Author: xuyamei
 * @CreateTime: 2024-07-31  14:55
 * @Description: 购买存量的训练营
 * @Version: 1.0
 */
public class TestPurchaseCamp extends BaseTestImpl {
    @Resource(name = "trainingCTools")
    TrainingCTools trainTools;

    @Resource(name = "userTools")
    UserTools userTools;

    OrderCTools orderCTools = new OrderCTools();

    @Resource(name = "orderTools")
    OrderTools orderTools;

    private String orderId = "";
    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Lunar_Training,"API_purchaseCamp", LoginAccount.GYM_MINIAPPC, Terminal.minApp,"xym");
        super.beforeTest();
    }

    @Test
    public void testPurchaseCamp(){
        // 获取存量训练营活动
        String id = trainTools.getAppliableCampList("存量训练营Ｃ端报名活动").getJSONObject(0).getString("id");
        // 获取的微信用户
        String memberId = userTools.getMemberInfo().getString("memberId");

        JSONObject body =  new JSONObject();
        body.put("campId", id);
        body.put("memberId", memberId);
        body.put("memo", "");
        body.put("receivableAmount", "0.00");
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        body.put("objectId", RandomStringUtil.randomString(16));
        xmAppApi.doRequest(RequestType.JSON,params, body.toString(), headers).assetsSuccess(true);

        orderId = xmAppApi.getBodyInJSON().getString("result");

        // check 1:订单详情
        JSONArray voucherItems = orderCTools.getDetail(orderId).getJSONObject("result").getJSONArray("voucherItems");
        String[] keys = new String[]{"skuId","skuType"};
        String[] expect = new String[]{id,"TRAINING_CAMP"};
        for (int i = 0; i < keys.length; i++) {
            Assert.assertTrue(voucherItems.getJSONObject(0).getString(keys[i]).equals(expect[i]) );
        }

        // check 2：查询我的训练营列表
        JSONArray listMyTrainingCamp = trainTools.listMyTrainingCamp(memberId);
        keys = new String[]{"tradeOrderId","accountType"};
        expect = new String[]{orderId,"TRAINING"};
        // 生成训练营账户的id
        String accountId = "";
        for (int i = 0; i < listMyTrainingCamp.size(); i++){
            if (listMyTrainingCamp.getJSONObject(i).getString("tenantMemberCardId").equals(id)){
                for (int j = 0; j < keys.length; j++){
                    Assert.assertTrue(listMyTrainingCamp.getJSONObject(i).getString(keys[j]).equals(expect[j]));
                    accountId = listMyTrainingCamp.getJSONObject(i).getString("id");
                }
            }
        }


        // check 3：获取我的训练营详情 以及和购买的训练营内容是否一致
        JSONObject findMyTrainingCampDetailById =trainTools.findMyTrainingCampDetailById(accountId);
        JSONObject findDetailById = trainTools.findDetailById(id,memberId);
        keys = new String[]{"id","studioId","title","courseId","openStartDate","openEndDate","totalClassHour","price","trainerIds"};
        for (int i = 0; i < keys.length; i++){
            Assert.assertTrue(findMyTrainingCampDetailById.getJSONObject("trainingCampInfo").getString(keys[i]).equals(findDetailById.getString(keys[i])));
        }

        // check 3.2 验证我的训练营订单id
        Assert.assertTrue(findMyTrainingCampDetailById.getString("tradeOrderId").equals(orderId));
    }

    @Test(description = "作废订单数据，为了下次再购买",priority = 2)
    public void delOrderData(){
        DataUserInfo dataUserInfo = new DataUserInfo();
        dataUserInfo.setTerminal(Terminal.B);
        dataUserInfo.setLoginUser(LoginAccount.GYM_PROD);
        orderTools.discard(orderId,"重复录入","作废训练营订单",dataUserInfo);
    }
}
