package com.xiaomai.cases.lunar.user;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.springframework.stereotype.Component;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.lunar.reserve.user
 * @Author: xuyamei
 * @CreateTime: 2024-06-25  13:42
 * @Description: TODO
 * @Version: 1.0
 */
@Component("userTools")
public class UserTools extends XMBaseTest {

    public void setUP(String apiName, DataUserInfo... userInfo) {
        dataApi.setApiModule(ApiModule.Lunar_User)
                .setApiName(apiName)
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(userInfo);
    }

    /**
     * @description: 获取会员信息
     * @author: xuyamei
     * @date:  2024/6/25 13:50
     * @param userInfo
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject getMemberInfo(DataUserInfo... userInfo) {
        setUP("API_getMemberInfo", userInfo);

        JSONObject body = new JSONObject();
        body.put("userId",dataApi.getLoginInfo().getUser());
        body.put("brandId",dataApi.getLoginInfo().getBrandId());
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result");
    }
}
