package com.xiaomai.cases.polar.data.financeData;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class GetOrderDetail extends XMBaseTest {

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Data)
                .setApiName("API_getOrderDetail")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }


    @DataProvider
    public Object[][] dataProvider(){
        return new Object[][]{
                {"DAY","ORDER_RECEIVABLE_AMOUNT_ASC", TimeUtils.getTodayEndTime(),TimeUtils.getTodayTime()},//今天,排序：订单应收金额正序
                {"MONTH","ORDER_RECEIVABLE_AMOUNT_DESC",TimeUtils.getMonthLastDay(),TimeUtils.getMonthFristDay()},//本月,排序：订单应收金额倒序
                {"DAY","ORDER_ACTUAL_AMOUNT_ASC", TimeUtils.getTodayEndTime(),TimeUtils.getTodayTime()},//今天,排序：订单实收金额正序
                {"MONTH","ORDER_ACTUAL_AMOUNT_DESC",TimeUtils.getMonthLastDay(),TimeUtils.getMonthFristDay()}//本月,排序：订单实收金额倒序
        };
    }

    @Test(description = "获取数据中心-财务数据-订单明细：按天、按月以及各种排序类型的筛选的订单明细",dataProvider = "dataProvider")
    public void getOrderDetail(String dateType, String sort, long endTime,long startTime){

        JSONObject getOrderDetail=new JSONObject();
        getOrderDetail.put("dateType",dateType);
        getOrderDetail.put("sort",sort);
        getOrderDetail.put("endTime",endTime);
        getOrderDetail.put("startTime",startTime);
        getOrderDetail.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        getOrderDetail.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        getOrderDetail.put("operatorId",xmAppApi.getLoginInfo().getAdminId());


        xmAppApi.doRequest(RequestType.JSON,params,getOrderDetail.toJSONString(),headers).assetsSuccess(true);
        String getOrderDetailResult=xmAppApi.getBodyInJSON().getString("success");
        Assert.assertEquals(getOrderDetailResult,"true","获取数据中心-财务数据-订单明细失败");
    }


    @DataProvider
    public Object[][] dataProvider1(){
        return new Object[][]{
                {"WEEK","ORDER_UNPAID_AMOUNT_ASC",TimeUtils.getWeekLastTime(),TimeUtils.getWeekFirstTime()},//本周,排序：欠费金额正序
                {"WEEK","ORDER_UNPAID_AMOUNT_DESC",TimeUtils.getWeekLastTime(),TimeUtils.getWeekFirstTime()},//本周,排序：欠费金额倒序
                {"WEEK","ORDER_REFUND_AMOUNT_ASC",TimeUtils.getWeekLastTime(),TimeUtils.getWeekFirstTime()},//本周,排序：退款金额正序
                {"WEEK","ORDER_REFUND_AMOUNT_DESC",TimeUtils.getWeekLastTime(),TimeUtils.getWeekFirstTime()},//本周,排序：退款金额倒序
        };
    }


    @Test(description = "数据中心-财务数据-订单明细：按周以及各种排序类型的筛选的订单明细",dataProvider = "dataProvider1")
    public void testGetOrderTrend1(String dateType,String sort,String endTime,String startTime){

        JSONObject getOrderDetail=new JSONObject();
        getOrderDetail.put("dateType",dateType);
        getOrderDetail.put("sort",sort);
        getOrderDetail.put("endTime",endTime);
        getOrderDetail.put("startTime",startTime);
        getOrderDetail.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        getOrderDetail.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        getOrderDetail.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON,params,getOrderDetail.toJSONString(),headers).assetsSuccess(true);
        String getOrderDetailResult=xmAppApi.getBodyInJSON().getString("success");
        Assert.assertEquals(getOrderDetailResult,"true","获取数据中心-财务数据-订单明细失败");

    }


}
