package com.xiaomai.cases.polar.eleContract;

import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.eleContract
 * @Author: xuyamei
 * @CreateTime: 2024-08-05  11:36
 * @Description: 查询企业授权结果
 * @Version: 1.0
 */
public class TestGetCompanyAuthSignResult extends BaseTestImpl {


    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_EleContract,"API_getCompanyAuthSignResult", LoginAccount.DZHT_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @Test
    public void testGetCompanyAuthSignResult(){
        String body = "{\"tenantId\":\""+xmAppApi.getLoginInfo().getStudioId()+"\"}";
        xmAppApi.doRequest(RequestType.JSON,params,body,headers).assetsSuccess(true);
        Assert.assertTrue(xmAppApi.getBodyInJSON().getJSONObject("result").getBoolean("isSuccess"),"场馆已经授权，但查到的结果不是true");
    }


}
