package com.xiaomai.cases.polar.member;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;


public class TestSearch extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_searchMember")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @DataProvider
    public Object[][] dataProvider(){
        return new Object[][]{
                {"NORMAL","NORMAL"},
                {"HISTORY","HISTORY"}
        };
    }
    @Test(description = "获取会员管理（正式会员/流失会员）列表",dataProvider = "dataProvider")
    public void testSearch(String searchType,String status){

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        jsonObject.put("searchType",searchType);

        JSONArray statusList=new JSONArray();
        statusList.add(status);
        jsonObject.put("statusList",statusList);

        jsonObject.put("resourceId",null);
        jsonObject.put("creatorId",null);
        jsonObject.put("wechatBindStatus",null);
        jsonObject.put("saleId",null);
        jsonObject.put("birthdayEnd",null);
        jsonObject.put("createdEnd",null);
        jsonObject.put("createdStart",null);
        jsonObject.put("tags",null);
        jsonObject.put("coachId",null);

        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(true);
        JSONObject response=xmAppApi.getBodyInJSON();
        String success=response.getString("success");
        Assert.assertEquals("true",success,"获取会员管理（正式会员/流失会员）列表失败");

    }

    @DataProvider
    public Object[][] dataProvider1(){
        return new Object[][]{
                {"NORMAL","NORMAL"},
                {"HISTORY","HISTORY"}
        };
    }
    @Test(description = "筛选会员管理（正式会员/流失学员）列表来源、当前创建人、跟进销售、跟进教练、绑定微信公众号、性别",dataProvider = "dataProvider1")
    public void testSearchResource(String searchType,String status){

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        jsonObject.put("searchType",searchType);

        JSONArray statusList=new JSONArray();
        statusList.add(status);
        jsonObject.put("statusList",statusList);
        jsonObject.put("resourceId","1");
        jsonObject.put("creatorId",xmAppApi.getLoginInfo().getAdminId());
        jsonObject.put("gender","WOMEN");

        jsonObject.put("wechatBindStatus","NO");
        jsonObject.put("saleId",xmAppApi.getLoginInfo().getAdminId());
        jsonObject.put("birthdayEnd",null);
        jsonObject.put("createdEnd",null);
        jsonObject.put("createdStart",null);
        jsonObject.put("tags",null);
        jsonObject.put("coachId",xmAppApi.getLoginInfo().getAdminId());


        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(true);
        JSONObject response=xmAppApi.getBodyInJSON();
        String success=response.getString("success");
        Assert.assertEquals("true",success,"筛选会员管理（正式会员/流失学员）列表来源、当前创建人、性别失败");

    }
}
