package com.xiaomai.cases.polar.memberCard;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@Component("cardTools")
public class CardTools extends XMBaseTest {

    /**
     * @param
     * @description:创建会员卡
     * @author: yangjian
     **/
    public JSONObject memberCardCreate(String title, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_tenantMemberCard_create")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONArray activatePatternList = new JSONArray();
        activatePatternList.add("PURCHASE");
        activatePatternList.add("SPECIFIC_DATE");
        activatePatternList.add("FIRST_USED");

        List benefitList = new ArrayList();
        //List itemList = new ArrayList();
        //itemList.add("");
        JSONObject Object = new JSONObject();
        Object.put("identifier", RandomStringUtil.randomString(20));
        Object.put("benefitType", "BALANCE");
        Object.put("targetScope", "GROUP_CLASS_AND_PERSONAL_COURSE");
        Object.put("balance", "30");
        Object.put("reserveLimitType", "UN_LIMIT");
        Object.put("reserveLimitNumber", 0);
        Object.put("defaultConsumeBalance", 1);
        //Object.put("itemList", itemList);
        Object.put("targetType", "COURSE");
        Object.put("price", "1");
        benefitList.add(Object);


        JSONObject jsonObject = new JSONObject();
        jsonObject.put("surfaceUrl", "https://image.xiaomaiketang.com/xm/internal/HpRiJpFnTC.png");//会员卡封面图片
        jsonObject.put("surfaceCornerMark", "自动化标签");
        jsonObject.put("title", title);//会员卡名称 不能重复要加东西 "次卡-自动化会员卡"+RandomStringUtil.randomString(3)
        jsonObject.put("validPeriod", "3");//有效期-3天
        jsonObject.put("activatePatternList", activatePatternList);//三种生效方式
        jsonObject.put("sharePeopleLimit", "2");//共享人数
        jsonObject.put("benefitList", benefitList);//使用权益
        jsonObject.put("price", "1");//价格
        jsonObject.put("underlinePrice", "10");//划线价
        jsonObject.put("purchaseNumberLimit", "-1");//购买数量限制
        jsonObject.put("xcxSaleStatus", "YES");//小程序是否售卖
        jsonObject.put("creatorId", dataApi.getLoginInfo().getAdminId());
        jsonObject.put("shelfState", "YES");//卡启用状态
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("description", "{\"items\":[{\"content\":\"自动化创建的卡\",\"aspect\":\"\",\"type\":\"TEXT\"}]}");
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());
        jsonObject.put("commodityCardType", "MEMBER_CARD");

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @param
     * @description:创建储值卡
     * @author: xyy
     **/
    public JSONObject depositCardCreate(String title, String price, String balance, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_tenantMemberCard_create")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONArray activatePatternList = new JSONArray();
        activatePatternList.add("PURCHASE");

        JSONArray paymentScenarioList = new JSONArray();
        paymentScenarioList.add("ALL");


        JSONArray benefitList = new JSONArray();
        JSONObject benefitObject = new JSONObject();
        benefitObject.put("identifier", RandomStringUtil.randomString(20));
        benefitObject.put("balance", balance);//赠送金额
        benefitObject.put("benefitType", "STORED_VALUE");
        benefitObject.put("price", price);//实充金额
        benefitObject.put("targetType", "PAYMENT");
        benefitObject.put("targetScope", "PAYMENT_SPECIFIC_SCENARIO");
        benefitObject.put("paymentScenarioList", paymentScenarioList);
        benefitObject.put("accountType", "DEPOSIT");
        benefitList.add(benefitObject);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("surfaceUrl", "https://image.xiaomaiketang.com/xm/internal/BHabA5WaNF.png");//会员卡封面图片
        jsonObject.put("surfaceCornerMark", "自动化标签");
        jsonObject.put("title", title);//卡名称 不能重复要加东西 "次卡-自动化会员卡"+RandomStringUtil.randomString(3)
        jsonObject.put("validPeriod", "10");//有效期-10天
        jsonObject.put("sharePeopleLimit", "10");//共享人数
        jsonObject.put("price", price);//价格
        jsonObject.put("purchaseNumberLimit", "-1");//购买数量限制
        jsonObject.put("xcxSaleStatus", "YES");//小程序是否售卖
        jsonObject.put("creatorId", dataApi.getLoginInfo().getAdminId());
        jsonObject.put("shelfState", "YES");//卡启用状态
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("description", "{\"items\":[{\"content\":\"自动化创建的卡\",\"aspect\":\"\",\"type\":\"TEXT\"}]}");
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());
        jsonObject.put("benefitList", benefitList);//使用权益
        jsonObject.put("commodityCardType", "DEPOSIT_CARD");
        jsonObject.put("activatePatternList", activatePatternList);//三种生效方式

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * b端购买储值卡
     * @param dataUserInfos
     * @return 订单id
     */
    public String signOrderDeposit(String cardId,String cardSnapshotId,String memberId,String rechargeAmount,String giftAmount,DataUserInfo... dataUserInfos) {
        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_signOrderDeposit")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject cardChange = new JSONObject();
        cardChange.put("validPeriod","10");//有效期10天
        cardChange.put("giftAmount",giftAmount);//赠送金额
        cardChange.put("rechargeAmount",rechargeAmount);//实充金额

        JSONObject card = new JSONObject();
        card.put("cardId",cardId);
        card.put("cardSnapshotId",cardSnapshotId);
        card.put("cardChange",cardChange);
        card.put("commodityCardType","DEPOSIT_CARD");

        JSONArray paymentWays = new JSONArray();
        JSONObject pay = new JSONObject();
        pay.put("amount",rechargeAmount);//实收金额
        pay.put("paymentWay","1");
        pay.put("voucherResourceIds",new JSONArray());
        paymentWays.add(pay);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("salesmanId",dataApi.getLoginInfo().getAdminId() );
        jsonObject.put("operationTime",TimeUtils.getCurrentTime());
        jsonObject.put("supplierInnerMemo", "对内备注-自动化生成");
        jsonObject.put("supplierMemo", "对外备注-自动化生成");
        jsonObject.put("card", card);
        jsonObject.put("objectId", UUID.randomUUID().toString());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("memberId", memberId);
        jsonObject.put("receivableAmount",rechargeAmount);//应收金额
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        if (rechargeAmount=="0.00"){
            jsonObject.put("paymentWays",new JSONArray());//支付方式
        }else {
            jsonObject.put("paymentWays",paymentWays);//支付方式
        }

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getString("result");
    }

    /**
     * 快速创建会员卡次卡-存量数据： 嘟嘟创建的会员卡-次卡
     *
     * @param title
     * @param dataUserInfos
     * @return
     */
    public String oneKeyCreateMembershipCardNumberCard(String title, DataUserInfo... dataUserInfos) {
        String requestString = "{\n" +
                "\"surfaceUrl\": \"https://image.xiaomaiketang.com/xm/internal/HpRiJpFnTC.png\",\n" +
                "\"maxIdlePeriod\": 30,\n" +
                "\"surfaceCornerMark\": \"\",\n" +
                "\"title\": \"" + title + "\",\n" +
                "\"validPeriod\": \"9999\",\n" +
                "\"activatePatternList\": [\n" +
                "\"PURCHASE\",\n" +
                "\"FIRST_USED\",\n" +
                "\"SPECIFIC_DATE\"\n" +
                "],\n" +
                "\"benefitList\": [\n" +
                "{\n" +
                "\"identifier\": \"" + RandomStringUtil.randomString(20) + "\",\n" +
                "\"benefitType\": \"BALANCE\",\n" +
                "\"targetScope\": \"GROUP_CLASS_AND_PERSONAL_COURSE\",\n" +
                "\"balance\": \"60\",\n" +
                "\"reserveLimitType\": \"UN_LIMIT\",\n" +
                "\"reserveLimitNumber\": 0,\n" +
                "\"defaultConsumeBalance\": 1,\n" +
                "\"itemList\": [],\n" +
                "\"targetType\": \"COURSE\"\n" +
                "\"price\": \"398\"\n" +
                "}\n" +
                "],\n" +
                "\"price\": \"398\",\n" +
                "\"underlinePrice\": \"1000\",\n" +
                "\"purchaseNumberLimit\": \"-1\",\n" +
                "\"xcxSaleStatus\": \"YES\",\n" +
                "\"creatorId\": \"1798957492546801666\",\n" +
                "\"shelfState\": \"YES\",\n" +
                "\"brandId\": \"1796482011391729666\",\n" +
                "\"studioId\": \"1800375402938871809\",\n" +
                "\"description\": \"{\\\"items\\\":[]}\",\n" +
                "\"operatorId\": \"1798957492546801666\",\n" +
                "\"commodityCardType\": \"MEMBER_CARD\"\n" +
                "}";
        dataApi.doRequest(RequestType.JSON, dataparams, requestString, dataheadrs).assetsSuccess(true);
        return XMJSONPath.readPath(dataApi.getApi_response(), "$.result");


    }

    /**
     * @param
     * @description:会员卡列表
     * @author: yangjian
     **/
    public JSONObject fetchPageOfMemberCard(String commodityCardType,DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_fetchPageOfMemberCard")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        //jsonObject.put("shelfState",shelfState);//启用状态
        //jsonObject.put("xcxSaleStatus",xcxSaleStatus);//售卖状态
        jsonObject.put("current", 0);
        jsonObject.put("size", 20);
        jsonObject.put("commodityCardType",commodityCardType);
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @description:获取会员卡列表
     * @author: xuyamei
     * @date:  2024/8/7 09:18
     * @param courseId 课程id
     * @param commodityCardType 会员卡类型
     * @param dataUserInfos
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject fetchPageOfMemberCard(String courseId,String commodityCardType,DataUserInfo... dataUserInfos) {
        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_fetchPageOfMemberCard")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("shelfState","YES");//启用状态
        jsonObject.put("xcxSaleStatus","YES");//售卖状态
        jsonObject.put("courseId", courseId);
        jsonObject.put("commodityCardType", commodityCardType);
        jsonObject.put("current", 0);
        jsonObject.put("size", 20);
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());
        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response.getJSONObject("result");
    }

    /**
     * @param
     * @description:会员卡搜索
     * @author: yangjian
     **/
    public JSONObject doMemberCardcommonSearch(String title, String commodityCardType,DataUserInfo... dataUserInfos) {
        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_commonSearch")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("title", title);//搜索的卡名
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());
        jsonObject.put("commodityCardType",commodityCardType);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * 通过搜索栏查询会员卡名称获取卡
     * @param commodityCardType
     * @param title
     * @param dataUserInfos
     * @return
     */
    public JSONObject tenantMemberCardCommonSearch(String commodityCardType,String title,DataUserInfo... dataUserInfos) {
        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_tenantMemberCard_commonSearch")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("commodityCardType",commodityCardType);
        jsonObject.put("title", title);//搜索的卡名
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
    /**
     * @param
     * @description:会员卡售卖记录
     * @author: yangjian
     **/
    public JSONObject memberCardSearch(String memberCardState,DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_membercard_search")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        List memberCardStateList = new ArrayList();
        memberCardStateList.add(memberCardState);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("current", 0);
        jsonObject.put("size", 20);
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());
        jsonObject.put("memberCardStateList",memberCardStateList);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
    /**
     * @param
     * @description:会员卡/体验卡/储值卡售卖记录
     * @author: xyy
     **/
    public void memberCardSearch(String accountType,String memberCardState,DataUserInfo... dataUserInfos) {
        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_membercard_search")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        List memberCardStateList = new ArrayList();
        memberCardStateList.add(memberCardState);//卡状态

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current", 0);
        jsonObject.put("size", 20);
        jsonObject.put("accountType", accountType);//卡类型
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("memberCardStateList",memberCardStateList);
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
    }

    /**
     * @param
     * @description:搜索会员卡售卖记录
     * @author: yangjian
     **/

    public JSONObject commonSearch(String content, DataUserInfo... dataUserInfos) {
        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_commonSearch")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("content", content);
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @param
     * @description:会员卡详情
     * @author: yangjian
     **/
    public JSONObject fetchDetailById(String id, DataUserInfo... dataUserInfos) {
        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_fetchDetailById")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", id);
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @param
     * @description:会员卡售卖记录详情
     * @author: yangjian
     **/
    public JSONObject memberCardFindDetailById(String id, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_membercard_findDetailById")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("id", id);
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param courseId:课程id
     * @param courseType：课程类型  GROUP_CLASS
     * @param accountType：账户类型 MEMBER：EXPERIENCE
     * @param memberId         会员id
     * @param reserveDate：约课时间
     * @param dataUserInfos
     * @description:查询会员可用于约课的会员卡
     * @author: xuyamei
     * @date: 2024/6/23 12:38
     * @return: com.alibaba.fastjson.JSONArray
     **/
    public JSONArray listUserReservableBenefit(String courseId, String courseType, String accountType, String memberId, long reserveDate, DataUserInfo... dataUserInfos) {
        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_listUserReservableBenefit")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("courseId", courseId);
        jsonObject.put("courseType", courseType);
        jsonObject.put("accountType", accountType);
        jsonObject.put("memberId", memberId);
        jsonObject.put("reserveDate", reserveDate);
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONArray("result");

    }

    /**
     * @param
     * @description:手动扣次
     * @author: yangjian
     **/
    public JSONObject manualDeduct(String benefitId, String memberCardId,String balance, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_manualDeduct")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);


        JSONObject object = new JSONObject();
        object.put("balance",balance);//手动扣次数，若是储值卡可以是小数
        object.put("benefitId",benefitId);

        List deductList = new ArrayList();
        deductList.add(object);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("deductList", deductList);
        jsonObject.put("memberCardId", memberCardId);
        jsonObject.put("memo", "自动化手动扣次");
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @param
     * @description:会员卡消耗记录
     * @author: yangjian
     **/
    public JSONObject fetchPageOfConsumeRecord(String benefitId, String memberCardId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_fetchPageOfConsumeRecord")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("current", 0);
        jsonObject.put("size", 20);
        jsonObject.put("benefitId", benefitId);
        jsonObject.put("memberCardId", memberCardId);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @param
     * @description:修改会员卡有效期
     * @author: yangjian
     **/
    public JSONObject modifyExpireDate(int num, String memberCardId, DataUserInfo... dataUserInfos) {
        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_modifyExpireDate")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("confirm", false);
        jsonObject.put("expireDate", TimeUtils.getAfterDayDate(num));
        jsonObject.put("memo", "自动化修改卡有效期");
        jsonObject.put("memberCardId", memberCardId);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @param
     * @description:会员卡停卡
     * @author: yangjian
     **/
    public JSONObject memberCardSuspend(String memberCardId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_membercard_suspend")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("planRestoreDate", TimeUtils.getAfterDayDate(1));//停卡到第二天
        jsonObject.put("memo", "自动化停卡");
        jsonObject.put("memberCardId", memberCardId);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @param
     * @description:会员卡取消停卡
     * @author: yangjian
     **/
    public void memberCardCancelSuspend(String memberCardId, DataUserInfo... dataUserInfos) {
        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_cancelSuspend")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("memberCardId", memberCardId);
        jsonObject.put("memo", "自动化取消停卡");
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
    }

    /**
     * @param
     * @description:会员卡查看编辑记录
     * @author: yangjian
     **/
    public JSONObject fetchPageOfHistory(String memberCardId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_fetchPageOfHistory")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("memberCardId", memberCardId);
        jsonObject.put("current", 0);
        jsonObject.put("size", 20);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * 修改会员卡的停启用状态
     *
     * @param memberCardId  会员卡ID
     * @param shelfState    启用：YES，停用：NO
     * @param dataUserInfos
     */
    public void modifyMemberCardShelfState(String memberCardId, String shelfState, DataUserInfo... dataUserInfos) {
        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_modifyShelfState")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("memberCardId", memberCardId);
        jsonObject.put("shelfState", shelfState);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
    }
    /**
     * 修改会员卡的小程序售卖状态
     *
     * @param memberCardId  会员卡ID
     * @param xcxSaleState    启用：YES，停用：NO
     * @param dataUserInfos
     */
    public void modifyXcxSaleState(String memberCardId, String xcxSaleState, DataUserInfo... dataUserInfos) {
        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_modifyXcxSaleState")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("memberCardId", memberCardId);
        jsonObject.put("xcxSaleState", xcxSaleState);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
    }

    /**
     * 售卖记录全局搜索：根据会员名称/手机号搜索，获取会员名下购卡相关记录
     *
     * @param memberId
     */
    public void getUserMemberCardList(String memberId,String accountType, DataUserInfo... dataUserInfos) {
        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_fetchUserCardList")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("accountType",accountType);
        jsonObject.put("memberId", memberId);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
    }

    /**
     * 查看会员卡售卖记录-变动记录
     * @param memberCardAccountId
     */
    public void getMemberCardAccountOperateRecord(String memberCardAccountId){
        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_fetchPageOfOperateRecord")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("memberCardId", memberCardAccountId);
        jsonObject.put("current", 0);
        jsonObject.put("size", 100);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);

    }

    /**
     * 查看会员卡售卖记录-变动记录
     */
    public JSONObject fetchPageOfOperateRecord(String memberCardId){
        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_fetchPageOfOperateRecord")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("memberCardId", memberCardId);
        jsonObject.put("current", 0);
        jsonObject.put("size", 100);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
    //查看卡的编辑记录
    public JSONObject findHistoryDetailById(String id,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_findHistoryDetailById")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("id",id);
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * 移除共享人
     * @param memberCardId
     * @param userInfos
     */
    public void modifySharers(String memberCardId,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_modifySharers")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("memberCardId",memberCardId);
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());
        jsonObject.put("sharerIds",new JSONArray());
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
    }

}
