package com.xiaomai.cases.polar.schedule.camp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.training.BaseCreateTrainingData;
import com.xiaomai.utils.CommUtil;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author adu
 * data 2024/7/9 16:35
 */

public class SelectTargetTrainingCampAndGetInfo extends BaseCreateTrainingData {
    //训练营活动ID
    public String id = "";
    public String title = "三墩小学足球2期训练营" + RandomStringUtil.randomString(6);
    public String openEndDate=  CommUtil.getNDayEndTimeTamp(42);// 23：59：59,从开始到结束一共40天

    public List<JSONObject> campInfo = new ArrayList<>();

    public String campId="";
    public String courseId="";
    public String openStartDate="";
    public int traineeLowerLimit;
    public int traineeUpperLimit;
    public int totalClassHour;
    public String chiefCoachId="";
    public Double price;
    List<String> assistCoachIds;

    @BeforeClass
    public void beforeTest() {
        super.beforeTest();
        //创建训练营活动
        id =this.getTrainingTools().createThenPublishTraining(this.getApplyStartTime(),this.getApplyEndTime(),this.getCourseId(),this.getOpenStartDate(),
                openEndDate,3200.00,title,40,1,this.getTrainerListIdS(),"YES");
        //根据训练营名称查询训练营信息
        List<String> status = new ArrayList<>(); //训练营排课时选择以下4种状态的活动
        status.add("APPLY_NOT_START");//报名未开始
        status.add("APPLYING");//报名中
        status.add("TO_BE_OPEN");//待开营
        status.add("OPENING");//进行中
        this.getTrainingTools().searchTrainingList("", title, status);
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.records").size() == 1, "精确查询训练营名称，没查到数据");

        campInfo = JSON.parseObject(dataApi.getApi_response()).getJSONObject("result").getJSONArray("records").stream()
                .map(obj -> {
                    JSONObject group = (JSONObject) obj;
                    return new JSONObject()
                            .fluentPut("id", group.getString("id"))
                            .fluentPut("courseId", group.getString("courseId"))
                            .fluentPut("openStartDate", group.getString("openStartDate"))
                            .fluentPut("openEndDate", group.getString("openEndDate"))
                            .fluentPut("traineeLowerLimit", group.getIntValue("traineeLowerLimit"))
                            .fluentPut("traineeUpperLimit", group.getIntValue("traineeUpperLimit"))
                            .fluentPut("totalClassHour", group.getIntValue("totalClassHour"))
                            .fluentPut("price",group.getDouble("price"))
                            .fluentPut("trainerList", group.getJSONArray("trainerList").toJavaList(JSONObject.class).stream()
                                    .map(trainers -> {
                                        return new JSONObject()
                                                .fluentPut("id", trainers.getString("id"))
                                                .fluentPut("nickName", trainers.getString("nickName"));
                                    }).collect(Collectors.toList())
                            );
                })
                .collect(Collectors.toList());


        campId= campInfo.get(0).getString("id");
        courseId= campInfo.get(0).getString("courseId");
        openStartDate=campInfo.get(0).getString("openStartDate");
        openEndDate=campInfo.get(0).getString("openEndDate");
        traineeLowerLimit=campInfo.get(0).getIntValue("traineeLowerLimit");
        traineeUpperLimit=campInfo.get(0).getIntValue("traineeUpperLimit");
        totalClassHour=campInfo.get(0).getIntValue("totalClassHour");
        price=campInfo.get(0).getDouble("price");
        chiefCoachId = campInfo.get(0).getJSONArray("trainerList").toJavaList(JSONObject.class).stream().filter(e -> {
            return "杜君丽".equals(e.getString("nickName"));
        }).map(e -> e.getString("id")).findFirst().orElse(null);
       assistCoachIds = campInfo.get(0).getJSONArray("trainerList").toJavaList(JSONObject.class).stream().filter(e -> {
            return !"杜君丽".equals(e.getString("nickName"));
        }).map(e -> e.getString("id")).collect(Collectors.toList());

    }


}

    