package com.xiaomai.cases.polar.schedule.camp;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.schedule.group.GroupScheduleTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.CommUtil;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * @author adu
 * data 2024/8/1 11:19
 */

public class TestEditCurrentCampSchedule extends SelectTargetTrainingCampAndGetInfo {

    public static Date now = new Date();
    String scheduleIdsN;
    @Resource(name = "groupScheduleTools")
    GroupScheduleTools groupScheduleTools;
    @Resource(name = "campScheduleTools")
    CampScheduleTools campScheduleTools;
    String campId = "";
    String chiefCoachId = "";
    String ruldId = "";
    //获取下周日某个时间点的开始时间戳
    String startStamp = CommUtil.getWholeHourTimeStamp(13, "13:30");

    public int scheduleClassHourEditBefore = 0;


    @BeforeClass
    @Override
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Schedule, "API_editCampSchedule", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();
        // 获取选择的训练营ID
        campId = super.campId;
        //1.2获取训练营活动的指定教练ID
        chiefCoachId = super.chiefCoachId;
        //获取目标时间段内 最大有效课时数
        String[] weekDaysArray = {"TUESDAY", "THURSDAY", "SATURDAY", "SUNDAY"};
        List<String> weekdaysList = Arrays.asList(weekDaysArray);
        int loopNum = campScheduleTools.queryExpectedLoopNum(CommUtil.oneKeyGetAddDay(3), super.openEndDate, weekdaysList);

        //创建训练营排课：按次数 星期：2，4，6，7
        campScheduleTools.oneKeyCreateCampRuleSchedule(campId, chiefCoachId, super.courseId,
                super.traineeLowerLimit, super.traineeUpperLimit,
                "1140", super.openEndDate, true,
                String.valueOf(loopNum));
        //查询排课日程:根据训练营和关联课程查询
        campScheduleTools.getCampRuleScheduleList(super.campId, super.courseId, "");
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").size() == 1, "排课创建成功后，日程中没查询到对应数据");
        ruldId = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").getJSONObject(0).getString("ruleId");
        //获取训练营活动已排课课次数
        scheduleClassHourEditBefore = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").getJSONObject(0).getJSONObject("campVO").getIntValue("scheduleClassHour");

    }

    @Test(description = "编辑当前课次")
    public void testEditCurrentCampSchedule() {
        //获取本次创建规则中下周日课次ID
        scheduleIdsN = campScheduleTools.getCampTableDate(13, ruldId);
        if (!StringUtils.isEmpty(scheduleIdsN)) {
            JSONObject body = new JSONObject();
            body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
            body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
            body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
            body.put("applyRestRule", false);
            body.put("scheduleId", scheduleIdsN);
            body.put("startTime", startStamp);//修改上课时间
            body.put("chiefCoachId", chiefCoachId);
            body.put("minMemberNum", super.traineeLowerLimit);
            body.put("maxMemberNum", super.traineeUpperLimit);
            body.put("venueAreaIds", new ArrayList<>());
            body.put("assistCoachIds", super.assistCoachIds);//有空改为有数据2个教练
            body.put("spanMinutes", 50);
            body.put("force", true);//有冲突时忽略冲突
            body.put("retainBooking", true);//保留学员预约

            xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers);
            Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(xmAppApi.getApi_response(), "$.success")) == true, "调用接口返回结果：" + XMJSONPath.readPath(xmAppApi.getApi_response(), "$.message"));

            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            //编辑成功后check对应课次详情修改内容是否同步成功
            campScheduleTools.getCampScheduleItemDetail(scheduleIdsN);
            String detailResult = dataApi.getApi_response();
            Assert.assertEquals(XMJSONPath.readPath(detailResult, "$.result.chiefCoachId"), chiefCoachId);
            Assert.assertEquals(XMJSONPath.readPath(detailResult, "$.result.startTime"), startStamp);
            Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(detailResult, "$.result.assistCoachIds").size() == 2, "助教修改后添加2个教练没生效");
            Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(detailResult, "$.result.venueAreaIds").size() == 0, "课次创建时场地为空，查看课次详情不为空");

        }

    }
    @AfterTest(description = "删除此case创建的训练营排课日程")
    public void delData() {
        if (null != campId || !campId.isEmpty()) {
            this.getTrainingTools().deleteTraining(campId);
            //训练营被删除后，对应的排课日程会被自动删除check
            campScheduleTools.getCampRuleScheduleList(campId, "", "");
            Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").size() == 0, "训练营被删除后，对应的排课日程会被自动删除，目前还有相关数据请检查");


        }


    }
}

    