package com.xiaomai.cases.polar.schedule.camp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.memberCard.CardTools;
import com.xiaomai.cases.polar.reserve.ReserveTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.training
 * @Author: xuyamei
 * @CreateTime: 2024-07-31  10:39
 * @Description: 训练营签到、请假、补签到、无需补课、请假已补
 * @Version: 1.0
 */
public class TestTrainingSign extends BaseTestImpl {
    @Resource(name = "campScheduleTools")
    CampScheduleTools campScheduleTools;

    @Resource(name = "reserveTools")
    ReserveTools reserveTools;

    CardTools cardTools = new CardTools();
    private String scheduleId;
    @BeforeMethod
    @Override
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Reserve,"API_remedial", LoginAccount.GYM_PROD, Terminal.B,"xuyamei");
        super.beforeTest();
    }

    @Test(description = "训练营签到")
    public void testTrainingSign() {
        // 训练营课表查询存量的训练营课次
        JSONArray getCampScheduleTable = campScheduleTools.getCampScheduleTable(TimeUtils.getTodayTime(), TimeUtils.getTodayEndTime(), "1818220193259798530");
        scheduleId = getCampScheduleTable.getJSONObject(0).getString("scheduleId");

        // 训练营课次详情
        campScheduleTools.getCampScheduleItemDetail(scheduleId);
        JSONArray memberRserveList = dataApi.getBodyInJSON().getJSONObject("result").getJSONArray("memberReserveList");
        String reserveId = ""; // 约课id
        String memberId = "";
        String benefitId = ""; // 权益id
        String memberCardId = ""; // 卡id
        // 查到需要操作签到的学员id
        boolean hasData = false; // 是否找到需要操作的学员
        for (int i = 0; i < memberRserveList.size(); i++) {
            System.out.println("-------------i"+i);
            System.out.println("-------------i"+i);
            if (memberRserveList.getJSONObject(i).getJSONObject("member").getString("name").contains("微信用户") && memberRserveList.getJSONObject(i).getString("signInState").equals("UN_SIGNED")) {
                reserveId = memberRserveList.getJSONObject(i).getString("id");
                memberId = memberRserveList.getJSONObject(i).getString("memberId");
                benefitId = memberRserveList.getJSONObject(i).getString("benefitId");
                memberCardId = memberRserveList.getJSONObject(i).getString("memberCardId");
                hasData = true;
                break;
            }
        }
        Assert.assertTrue(hasData, "没有找到需要操作的学员,课次今日可能没有可操作的学员，请手动在页面回归签到");

        // 操作签到
        reserveTools.signIn(true, reserveId, false);

        try {
            Thread.sleep(2500);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        // check 1: 课次详情到课状态为签到
        campScheduleTools.getCampScheduleItemDetail(scheduleId);
        memberRserveList = dataApi.getBodyInJSON().getJSONObject("result").getJSONArray("memberReserveList");
        for (int i = 0; i < memberRserveList.size(); i++) {
            if (memberRserveList.getJSONObject(i).getString("id").equals(reserveId)) {
                Assert.assertEquals(memberRserveList.getJSONObject(i).getString("signInState"), "SIGNED");
            }
        }

        // check 2: 预约记录是否包含该预约
        String[] result = new String[]{"id", "benefitId", "reserveMemberNum", "courseType", "reserveState", "scheduleId", "signInState"};
        String[] resultData = new String[]{reserveId, benefitId, "1", "TRAINING_CAMP", "SUCCESS", scheduleId, "SIGNED"};
        // check 2.1 预约记录列表
        JSONArray getPageByStudio = reserveTools.getPageByStudio("", "SUCCESS", "SIGNED", "", TimeUtils.getTodayTime(), TimeUtils.getTodayEndTime(), memberId, "TRAINING_CAMP", "1818220193259798530");
        boolean success = false;
        for (int i = 0; i < getPageByStudio.size(); i++) {
            if (getPageByStudio.getJSONObject(i).getString("id").equals(reserveId)) {
                success = true;
                for (int j = 0; j < result.length; j++) {
                    Assert.assertEquals(getPageByStudio.getJSONObject(i).getString(result[j]), resultData[j], "训练营签到产生的数据与实际数据不符合" + result[j] + "：" + resultData[j]);
                }
                Assert.assertEquals(getPageByStudio.getJSONObject(i).getString("memberId"), memberId, "查询的训练营签到产生数据不是同一个会员");
            }
        }
        Assert.assertTrue(success, "训练营签到产生约课记录没有查询到相关信息");
        // check 2.3 预约记录详情
        JSONObject getDetailById = reserveTools.getDetailById(reserveId);
        for (int j = 0; j < result.length; j++) {
            Assert.assertEquals(getDetailById.getString(result[j]), resultData[j], "训练营签到产生的数据与实际数据不符合" + result[j] + "：" + resultData[j]);
        }
        Assert.assertEquals(getDetailById.getString("memberId"), memberId, "查询的约课数据不是同一个会员");

        // check 3： 会员卡消耗记录中包含该记录签到消耗
        JSONArray consumeRecord = cardTools.fetchPageOfConsumeRecord(benefitId, memberCardId).getJSONObject("result").getJSONArray("records");
        String[] result2 = new String[]{"resourceId", "consumeType", "changeOfPurchaseBalance"};
        String[] respect = new String[]{reserveId, "SIGN_IN", "-1.00"};
        String[] message = new String[]{"训练营消耗记录中记录的资源id与实际约课记录id不符合", "训练营消耗记录中记录的资源id与实际约课记录类型不符合", "训练营消耗记录中记录的资源id与实际约课记录余额不符合"};
        for (int i = 0; i < result2.length; i++) {
            Assert.assertEquals(consumeRecord.getJSONObject(0).getString(result2[i]), respect[i], message[i]);
        }

    }
    @Test(description = "训练营请假", priority = 1)
    public void testTrainingSign_Leave() {
        // 训练营课表查询存量的训练营课次
        JSONArray getCampScheduleTable = campScheduleTools.getCampScheduleTable(TimeUtils.getTodayTime(), TimeUtils.getTodayEndTime(),"1818220193259798530");
        scheduleId = getCampScheduleTable.getJSONObject(0).getString("scheduleId");

        // 训练营课次详情
        campScheduleTools.getCampScheduleItemDetail(scheduleId);
        JSONArray memberRserveList = dataApi.getBodyInJSON().getJSONObject("result").getJSONArray("memberReserveList");
        String reserveId = ""; // 约课id
        String memberId = "";
        String benefitId = ""; // 权益id
        String memberCardId = ""; // 卡id
        // 查到需要操作签到的学员id
        boolean hasData = false; // 是否找到需要操作的学员
        for (int i = 0; i < memberRserveList.size(); i++){
            if (memberRserveList.getJSONObject(i).getJSONObject("member").getString("name").contains("训练营请假学员")  && memberRserveList.getJSONObject(i).getString("signInState").equals("UN_SIGNED")){
                reserveId = memberRserveList.getJSONObject(i).getString("id");
                memberId = memberRserveList.getJSONObject(i).getString("memberId");
                benefitId = memberRserveList.getJSONObject(i).getString("benefitId");
                memberCardId = memberRserveList.getJSONObject(i).getString("memberCardId");
                hasData = true;
                break;
            }
        }
        Assert.assertTrue(hasData, "没有找到需要操作的学员,课次今日可能没有可操作的学员，请手动在页面回归请假");


        // 操作请假
        reserveTools.signIn(true,reserveId,true);

        try {
            Thread.sleep(2500);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        // check 1: 课次详情到课状态为签到
        campScheduleTools.getCampScheduleItemDetail(scheduleId);
        memberRserveList = dataApi.getBodyInJSON().getJSONObject("result").getJSONArray("memberReserveList");
        for (int i = 0; i < memberRserveList.size(); i++){
            if (memberRserveList.getJSONObject(i).getString("id").equals(reserveId)){
                Assert.assertEquals(memberRserveList.getJSONObject(i).getString("signInState"),"LEAVE");
            }
        }

        // check 2: 预约记录是否包含该预约
        String[] result = new String[] {"id","benefitId","reserveMemberNum","courseType","reserveState","scheduleId","signInState"};
        String[] resultData = new String[] {reserveId,benefitId,"1","TRAINING_CAMP","SUCCESS",scheduleId,"LEAVE"};
        // check 2.1 预约记录列表
        JSONArray getPageByStudio = reserveTools.getPageByStudio("","SUCCESS","LEAVE","",TimeUtils.getTodayTime(),TimeUtils.getTodayEndTime(), memberId,"TRAINING_CAMP","1818220193259798530");
        boolean success = false;
        for(int i =0;i<getPageByStudio.size();i++){
            if (getPageByStudio.getJSONObject(i).getString("id").equals(reserveId)){
                success = true;
                for(int j = 0;j<result.length;j++){
                    Assert.assertEquals(getPageByStudio.getJSONObject(i).getString(result[j]),resultData[j],"训练营请假产生的数据与实际数据不符合"+result[j]+"："+resultData[j]);
                }
                Assert.assertEquals(getPageByStudio.getJSONObject(i).getString("memberId"), memberId,"查询的约课数据不是同一个会员");
            }
        }
        Assert.assertTrue(success,"训练营请假产生约课记录没有查询到相关信息");
        // check 2.3 预约记录详情
        JSONObject getDetailById = reserveTools.getDetailById(reserveId);
        for(int j = 0;j<result.length;j++){
            Assert.assertEquals(getDetailById.getString(result[j]),resultData[j],"训练营请假产生的数据与实际数据不符合"+result[j]+"："+resultData[j]);
        }
        Assert.assertEquals(getDetailById.getString("memberId"), memberId,"查询的约课数据不是同一个会员");

        // check 3： 会员卡消耗记录中包含该记录签到消耗
        JSONArray consumeRecord = cardTools.fetchPageOfConsumeRecord(benefitId,memberCardId).getJSONObject("result").getJSONArray("records");
        String[] result2 = new String[] {"resourceId","consumeType","changeOfPurchaseBalance"};
        String[] respect = new String[] {reserveId,"LEAVE","-1.00"};
        String[] message = new String[] {"训练营消耗记录中记录的资源id与实际约课记录id不符合","训练营消耗记录中记录的资源id与实际约课记录类型不符合","训练营消耗记录中记录的资源id与实际约课记录余额不符合"};
        for (int i = 0; i < result2.length; i++){
            Assert.assertEquals(consumeRecord.getJSONObject(0).getString(result2[i]),respect[i],message[i]);
        }

    }


    @Test(description = "训练营请假补签到", priority = 2)
    public void testTrainingSign_SIGNED() {
        // 训练营课表查询存量的训练营课次
        JSONArray getCampScheduleTable = campScheduleTools.getCampScheduleTable(TimeUtils.getTodayTime(), TimeUtils.getTodayEndTime(),"1818220193259798530");
        scheduleId = getCampScheduleTable.getJSONObject(0).getString("scheduleId");

        // 训练营课次详情
        campScheduleTools.getCampScheduleItemDetail(scheduleId);
        JSONArray memberRserveList = dataApi.getBodyInJSON().getJSONObject("result").getJSONArray("memberReserveList");
        String reserveId = ""; // 约课id
        String memberId = "";
        String benefitId = ""; // 权益id
        String memberCardId = ""; // 卡id
        // 查到需要操作签到的学员id
        boolean hasData = false; // 是否找到需要操作的学员
        for (int i = 0; i < memberRserveList.size(); i++){
            if (memberRserveList.getJSONObject(i).getJSONObject("member").getString("name").contains("训练营请假补签到")  && memberRserveList.getJSONObject(i).getString("signInState").equals("UN_SIGNED")){
                reserveId = memberRserveList.getJSONObject(i).getString("id");
                memberId = memberRserveList.getJSONObject(i).getString("memberId");
                benefitId = memberRserveList.getJSONObject(i).getString("benefitId");
                memberCardId = memberRserveList.getJSONObject(i).getString("memberCardId");
                hasData = true;
                break;
            }
        }
        Assert.assertTrue(hasData, "没有找到需要操作的学员,课次今日可能没有可操作的学员，请手动在页面回归请假补签到");


        // 操作请假
        reserveTools.signIn(true,reserveId,true);

        try {
            Thread.sleep(2500);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        // 操作补签到
        reserveTools.signIn(true,reserveId,false);

        try {
            Thread.sleep(2500);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        // check 1: 课次详情到课状态为签到
        campScheduleTools.getCampScheduleItemDetail(scheduleId);
        memberRserveList = dataApi.getBodyInJSON().getJSONObject("result").getJSONArray("memberReserveList");
        for (int i = 0; i < memberRserveList.size(); i++){
            if (memberRserveList.getJSONObject(i).getString("id").equals(reserveId)){
                Assert.assertEquals(memberRserveList.getJSONObject(i).getString("signInState"),"SIGNED");
            }
        }

        // check 2: 预约记录是否包含该预约
        String[] result = new String[] {"id","benefitId","reserveMemberNum","courseType","reserveState","scheduleId","signInState"};
        String[] resultData = new String[] {reserveId,benefitId,"1","TRAINING_CAMP","SUCCESS",scheduleId,"SIGNED"};
        // check 2.1 预约记录列表
        JSONArray getPageByStudio = reserveTools.getPageByStudio("","SUCCESS","SIGNED","",TimeUtils.getTodayTime(),TimeUtils.getTodayEndTime(), memberId,"TRAINING_CAMP","1818220193259798530");
        boolean success = false;
        for(int i =0;i<getPageByStudio.size();i++){
            if (getPageByStudio.getJSONObject(i).getString("id").equals(reserveId)){
                success = true;
                for(int j = 0;j<result.length;j++){
                    Assert.assertEquals(getPageByStudio.getJSONObject(i).getString(result[j]),resultData[j],"训练营补签到产生的数据与实际数据不符合"+result[j]+"："+resultData[j]);
                }
                Assert.assertEquals(getPageByStudio.getJSONObject(i).getString("memberId"), memberId,"查询的约课数据不是同一个会员");
            }
        }
        Assert.assertTrue(success,"约课后在约课记录没有查询到相关信息");
        // check 2.3 预约记录详情
        JSONObject getDetailById = reserveTools.getDetailById(reserveId);
        for(int j = 0;j<result.length;j++){
            Assert.assertEquals(getDetailById.getString(result[j]),resultData[j],"训练营补签到产生产生的数据与实际数据不符合"+result[j]+"："+resultData[j]);
        }
        Assert.assertEquals(getDetailById.getString("memberId"), memberId,"查询的约课数据不是同一个会员");

        // check 3： 会员卡消耗记录中包含该记录签到消耗还是请假，请假已经扣除补签到不会再扣
        JSONArray consumeRecord = cardTools.fetchPageOfConsumeRecord(benefitId,memberCardId).getJSONObject("result").getJSONArray("records");
        String[] result2 = new String[] {"resourceId","consumeType","changeOfPurchaseBalance"};
        String[] respect = new String[] {reserveId,"LEAVE","-1.00"};
        String[] message = new String[] {"训练营消耗记录中记录的资源id与实际约课记录id不符合","训练营消耗记录中记录的资源id与实际约课记录类型不符合","训练营消耗记录中记录的资源id与实际约课记录余额不符合"};
        for (int i = 0; i < result2.length; i++){
            Assert.assertEquals(consumeRecord.getJSONObject(0).getString(result2[i]),respect[i],message[i]);
        }

    }



    @Test(description = "训练营请假标记已补", priority = 3)
    public void testTrainingSign_MARK_REMEDIAL() {
        // 训练营课表查询存量的训练营课次
        JSONArray getCampScheduleTable = campScheduleTools.getCampScheduleTable(TimeUtils.getTodayTime(), TimeUtils.getTodayEndTime(),"1818220193259798530");
        scheduleId = getCampScheduleTable.getJSONObject(0).getString("scheduleId");

        // 训练营课次详情
        campScheduleTools.getCampScheduleItemDetail(scheduleId);
        JSONArray memberRserveList = dataApi.getBodyInJSON().getJSONObject("result").getJSONArray("memberReserveList");
        String reserveId = ""; // 约课id
        String memberId = "";
        String benefitId = ""; // 权益id
        String memberCardId = ""; // 卡id
        // 查到需要操作签到的学员id
        boolean hasData = false; // 是否找到需要操作的学员
        for (int i = 0; i < memberRserveList.size(); i++){
            if (memberRserveList.getJSONObject(i).getJSONObject("member").getString("name").contains("训练营请假标记已补")  && memberRserveList.getJSONObject(i).getString("signInState").equals("UN_SIGNED")){
                reserveId = memberRserveList.getJSONObject(i).getString("id");
                memberId = memberRserveList.getJSONObject(i).getString("memberId");
                benefitId = memberRserveList.getJSONObject(i).getString("benefitId");
                memberCardId = memberRserveList.getJSONObject(i).getString("memberCardId");
                hasData = true;
                break;
            }
        }
        Assert.assertTrue(hasData, "没有找到需要操作的学员,课次今日可能没有可操作的学员，请手动在页面回归请假标记已补");

        // 操作请假
        reserveTools.signIn(true,reserveId,true);

        try {
            Thread.sleep(2500);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        // 操作标记已补
        JSONObject body = new JSONObject();
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
        body.put("remedialSignState", "MARK_REMEDIAL");
        body.put("reserveId", reserveId);
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        xmAppApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);
        try {
            Thread.sleep(2500);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        // check 1: 课次详情到课状态为请假 标记已补
        campScheduleTools.getCampScheduleItemDetail(scheduleId);
        memberRserveList = dataApi.getBodyInJSON().getJSONObject("result").getJSONArray("memberReserveList");
        for (int i = 0; i < memberRserveList.size(); i++){
            if (memberRserveList.getJSONObject(i).getString("id").equals(reserveId)){
                Assert.assertEquals(memberRserveList.getJSONObject(i).getString("signInState"),"LEAVE");
                Assert.assertEquals(memberRserveList.getJSONObject(i).getString("remedialSignState"),"MARK_REMEDIAL");
            }
        }

        // check 2: 预约记录是否包含该预约
        String[] result = new String[] {"id","benefitId","reserveMemberNum","courseType","reserveState","scheduleId","signInState","remedialSignState"};
        String[] resultData = new String[] {reserveId,benefitId,"1","TRAINING_CAMP","SUCCESS",scheduleId,"LEAVE","MARK_REMEDIAL"};
        // check 2.1 预约记录列表
        JSONArray getPageByStudio = reserveTools.getPageByStudio("","SUCCESS","LEAVE","",TimeUtils.getTodayTime(),TimeUtils.getTodayEndTime(), memberId,"TRAINING_CAMP","1818220193259798530");
        boolean success = false;
        for(int i =0;i<getPageByStudio.size();i++){
            if (getPageByStudio.getJSONObject(i).getString("id").equals(reserveId)){
                success = true;
                for(int j = 0;j<result.length;j++){
                    Assert.assertEquals(getPageByStudio.getJSONObject(i).getString(result[j]),resultData[j],"训练营请假标记已补产生的数据与实际数据不符合"+result[j]+"："+resultData[j]);
                }
                Assert.assertEquals(getPageByStudio.getJSONObject(i).getString("memberId"), memberId,"查询的约课数据不是同一个会员");
            }
        }
        Assert.assertTrue(success,"约课后在约课记录没有查询到相关信息");
        // check 2.3 预约记录详情
        JSONObject getDetailById = reserveTools.getDetailById(reserveId);
        for(int j = 0;j<result.length;j++){
            Assert.assertEquals(getDetailById.getString(result[j]),resultData[j],"训练营请假标记已补产生的数据与实际数据不符合"+result[j]+"："+resultData[j]);
        }
        Assert.assertEquals(getDetailById.getString("memberId"), memberId,"查询的约课数据不是同一个会员");

        // check 3： 会员卡消耗记录中包含该记录签到消耗还是请假，请假已经扣除不会再扣
        JSONArray consumeRecord = cardTools.fetchPageOfConsumeRecord(benefitId,memberCardId).getJSONObject("result").getJSONArray("records");
        String[] result2 = new String[] {"resourceId","consumeType","changeOfPurchaseBalance"};
        String[] respect = new String[] {reserveId,"LEAVE","-1.00"};
        String[] message = new String[] {"训练营消耗记录中记录的资源id与实际约课记录id不符合","训练营消耗记录中记录的资源id与实际约课记录类型不符合","训练营消耗记录中记录的资源id与实际约课记录余额不符合"};
        for (int i = 0; i < result2.length; i++){
            Assert.assertEquals(consumeRecord.getJSONObject(0).getString(result2[i]),respect[i],message[i]);
        }

    }


    @Test(description = "训练营请假无需补课", priority = 3)
    public void testTrainingSign_NEED_NOT_REMEDIAL() {
        // 训练营课表查询存量的训练营课次
        JSONArray getCampScheduleTable = campScheduleTools.getCampScheduleTable(TimeUtils.getTodayTime(), TimeUtils.getTodayEndTime(),"1818220193259798530");
        scheduleId = getCampScheduleTable.getJSONObject(0).getString("scheduleId");

        // 训练营课次详情
        campScheduleTools.getCampScheduleItemDetail(scheduleId);
        JSONArray memberRserveList = dataApi.getBodyInJSON().getJSONObject("result").getJSONArray("memberReserveList");
        String reserveId = ""; // 约课id
        String memberId = "";
        String benefitId = ""; // 权益id
        String memberCardId = ""; // 卡id
        // 查到需要操作签到的学员id
        boolean hasData = false; // 是否找到需要操作的学员
        for (int i = 0; i < memberRserveList.size(); i++){
            if (memberRserveList.getJSONObject(i).getJSONObject("member").getString("name").contains("训练营请假无需")  && memberRserveList.getJSONObject(i).getString("signInState").equals("UN_SIGNED")){
                reserveId = memberRserveList.getJSONObject(i).getString("id");
                memberId = memberRserveList.getJSONObject(i).getString("memberId");
                benefitId = memberRserveList.getJSONObject(i).getString("benefitId");
                memberCardId = memberRserveList.getJSONObject(i).getString("memberCardId");
                hasData = true;
                break;
            }
        }
        Assert.assertTrue(hasData, "没有找到需要操作的学员,课次今日可能没有可操作的学员，请手动在页面回归请假无需补课");

        // 操作请假
        reserveTools.signIn(true,reserveId,true);

        try {
            Thread.sleep(2500);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        // 操作标记已补
        JSONObject body = new JSONObject();
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
        body.put("remedialSignState", "NEED_NOT_REMEDIAL");
        body.put("reserveId", reserveId);
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        xmAppApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);
        try {
            Thread.sleep(2500);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        // check 1: 课次详情到课状态为请假-无需补课
        campScheduleTools.getCampScheduleItemDetail(scheduleId);
        memberRserveList = dataApi.getBodyInJSON().getJSONObject("result").getJSONArray("memberReserveList");
        for (int i = 0; i < memberRserveList.size(); i++){
            if (memberRserveList.getJSONObject(i).getString("id").equals(reserveId)){
                Assert.assertEquals(memberRserveList.getJSONObject(i).getString("signInState"),"LEAVE");
                Assert.assertEquals(memberRserveList.getJSONObject(i).getString("remedialSignState"),"NEED_NOT_REMEDIAL");
            }
        }

        // check 2: 预约记录是否包含该预约
        String[] result = new String[] {"id","benefitId","reserveMemberNum","courseType","reserveState","scheduleId","signInState","remedialSignState"};
        String[] resultData = new String[] {reserveId,benefitId,"1","TRAINING_CAMP","SUCCESS",scheduleId,"LEAVE","NEED_NOT_REMEDIAL"};
        // check 2.1 预约记录列表
        JSONArray getPageByStudio = reserveTools.getPageByStudio("","SUCCESS","LEAVE","",TimeUtils.getTodayTime(),TimeUtils.getTodayEndTime(), memberId,"TRAINING_CAMP","1818220193259798530");
        boolean success = false;
        for(int i =0;i<getPageByStudio.size();i++){
            if (getPageByStudio.getJSONObject(i).getString("id").equals(reserveId)){
                success = true;
                for(int j = 0;j<result.length;j++){
                    Assert.assertEquals(getPageByStudio.getJSONObject(i).getString(result[j]),resultData[j],"训练营请假无需补课产生的数据与实际数据不符合"+result[j]+"："+resultData[j]);
                }
                Assert.assertEquals(getPageByStudio.getJSONObject(i).getString("memberId"), memberId,"查询的约课数据不是同一个会员");
            }
        }
        Assert.assertTrue(success,"约课后在约课记录没有查询到相关信息");
        // check 2.3 预约记录详情
        JSONObject getDetailById = reserveTools.getDetailById(reserveId);
        for(int j = 0;j<result.length;j++){
            Assert.assertEquals(getDetailById.getString(result[j]),resultData[j],"训练营请假无需补课产生的数据与实际数据不符合"+result[j]+"："+resultData[j]);
        }
        Assert.assertEquals(getDetailById.getString("memberId"), memberId,"查询的约课数据不是同一个会员");

        // check 3： 会员卡消耗记录中包含该记录签到消耗还是请假，请假已经扣除不会再扣
        JSONArray consumeRecord = cardTools.fetchPageOfConsumeRecord(benefitId,memberCardId).getJSONObject("result").getJSONArray("records");
        String[] result2 = new String[] {"resourceId","consumeType","changeOfPurchaseBalance"};
        String[] respect = new String[] {reserveId,"LEAVE","-1.00"};
        String[] message = new String[] {"训练营消耗记录中记录的资源id与实际约课记录id不符合","训练营消耗记录中记录的资源id与实际约课记录类型不符合","训练营消耗记录中记录的资源id与实际约课记录余额不符合"};
        for (int i = 0; i < result2.length; i++){
            Assert.assertEquals(consumeRecord.getJSONObject(0).getString(result2[i]),respect[i],message[i]);
        }

    }

}
