package com.xiaomai.cases.polar.setting.courseCategory;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.course.CourseTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import javax.annotation.Resource;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.setting.courseCategory
 * @Author: xuyamei
 * @CreateTime: 2024-05-07  11:07
 * @Description: 删除课程分类
 * @Version: 1.0
 */
public class TestDeleteCourseCategory extends BaseTestImpl {

    @Resource(name = "courseTools")
    CourseTools courseTools;
    @Resource(name = "courseCategoryTools")
    CourseCategoryTools courseCategoryTools;
    private String categoryId;
    private String courseId;

    @BeforeClass
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Setting,"API_deleteCourseCategory", LoginAccount.GYM_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @DataProvider()
    public Object[][] data(){
        return new Object[][]{
                {false,"课程分类关联其他课程，不能删除"},
                {true,"课程分类没有关联任何课程，无法删除"}
        };
    }
    @Test(dataProvider = "data")
    public void testDeleteCourseCategory(boolean flag,String msg) throws InterruptedException {
        JSONObject body = new JSONObject();
        body.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        body.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        if (flag){
            // 删除课程
            courseTools.modifyCourseStatus(courseId,"DELETE",false);
        }else{
            // 创建课程分类
            categoryId = courseCategoryTools.createCourseCategory("课程分类"+ TimeUtils.getCurrentTime());
            Thread.sleep(1000);
            // 创建团课程
            courseId = courseTools.createGroupCourse("自动化测试课程",categoryId,"STUDIO");
            Thread.sleep(2500);
        }
        body.put("categoryId",categoryId);

        xmAppApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(flag,msg);

    }
}
