package com.xiaomai.cases.polar.coupon;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 测试创建优惠券
 * @author adu
 * data 2024/7/26 13:44
 */

public class TestCreateCoupon extends BaseTestImpl {
    @Resource(name = "couponTools")
    CouponTools couponTools;
    String titleA="";
    String couponIdA="";
    String titleB="";
    String couponIdB="";

    String titleC="";
    String couponIdC="";
    @BeforeClass
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Coupon, "API_createCoupon", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();
    }
   // @Test(description = "自动化测试创建优惠券")
    public void testCreateCoupon(){
        List<String> memberStatusLimitsA=new ArrayList<>();
        memberStatusLimitsA.add("POTENTIAL");
        memberStatusLimitsA.add("NORMAL");
        memberStatusLimitsA.add("HISTORY");

        List<String> memberStatusLimitsB=new ArrayList<>();
        memberStatusLimitsB.add("POTENTIAL");

        titleC="用于营销活动优惠券"+ RandomStringUtil.randomString(3);
        couponIdC=couponTools.createCoupon("WITHOUT","WITHOUT",memberStatusLimitsB,titleC,false,
                "DISCOUNT", -1,"RELATIVE",titleC+"领取7天内有效",true);


        titleA="有门槛限领适用全部"+ RandomStringUtil.randomString(3);
        couponIdA=couponTools.createCoupon("THRESHOLD","FIXED",memberStatusLimitsA,titleA,true,
                "CERTAIN", 2,"RELATIVE",titleA+"优惠方式选择金额，满10元可以减10元，领取后1天内有效",false);

        couponTools.getStudioCouponList(titleA,"");
        Long goalData=XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(),"$.result.records").toJavaList(JSONObject.class).stream().filter(e ->
                e.getString("id").equals(couponIdA)).count();
        Assert.assertTrue(goalData==1,"刚创建的优惠券在全局搜索中根据优惠券名称搜索，后端没返回数据");


        titleB="无门槛不限领适用部分"+ RandomStringUtil.randomString(2);
        couponIdB=couponTools.createCoupon("WITHOUT","WITHOUT",memberStatusLimitsB,titleB,false,
                "DISCOUNT", 2,"ABSOLUTE",titleB+"优惠方式选择折扣，8.8折，适用有效期明天～（当前时间+5天）",false);



    }



}

    