package com.xiaomai.cases.polar.reserve;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.springframework.stereotype.Component;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.reserve
 * @Author: xuyamei
 * @CreateTime: 2024-06-12  08:36
 * @Description: 预约工具类
 * @Version: 1.0
 */

@Component("reserveTools")
public class ReserveTools extends XMBaseTest {
    public void setUp(String name,DataUserInfo...dataUserInfo) {
        dataApi.setApiModule(ApiModule.Polar_Reserve)
                .setApiName(name)
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfo);
    }

    /**
     * @description: 添加预约
     * @author: xuyamei
     * @date:  2024/6/12 09:36
     * @param areaId 场地
     * @param assistantCoachId 助教id
     * @param benefitId 会员卡权益id
     * @param chiefCoachId 主教id
     * @param memberId 会员id
     * @param reserveMemberNum 预约人数
     * @param scheduleId    课次id
     * @param scheduleStartTime 上课时间
     * @param dataUserInfos 登录用户信息
     * @return: java.lang.String 预约id
     **/
    public String addReserve(String areaId,String assistantCoachId,String benefitId,String chiefCoachId,String memberId,int reserveMemberNum,String scheduleId,long scheduleStartTime,boolean success,DataUserInfo...dataUserInfos) {
        dataApi.setApiModule(ApiModule.Polar_Reserve)
                .setApiName("API_addReserve")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject body = new JSONObject();
        JSONArray areaIds = new JSONArray(); // 场地,私教约课会用到
        if (!areaId.equals("")){
            areaIds.add(areaId);
        }
        body.put("areaIds",areaIds);
        JSONArray coachIds = new JSONArray(); // 助教Ids
        if (!assistantCoachId.equals("")){
            coachIds.add(assistantCoachId);
        }
        body.put("assistantCoachIds",coachIds);
        body.put("benefitId",benefitId); //会员卡权益Id
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("chiefCoachId", chiefCoachId); // 主教id
        body.put("memberId", memberId); // 会员id
        body.put("operatorId", dataApi.getLoginInfo().getAdminId()); // 操作人id
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("planCheckBalance", 1); // 计划扣除额度
        body.put("reserveMemberNum", reserveMemberNum); // 预约人数
        body.put("scheduleId", scheduleId); // 课次id
        body.put("scheduleStartTime", scheduleStartTime); // 课次id
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(success);
        if (success){
            return dataApi.getBodyInJSON().getJSONObject("result").getString("reserveId");
        }
        return dataApi.getBodyInJSON().toString();

    }

    /**
     * @description: 预约私教课
     * @author: xuyamei
     * @date:  2024/7/26 17:34
     * @param areaId 场地id
     * @param courseId 课程id
     * @param chiefCoachId 教练id
     * @param memberId 会员id
     * @param benefitId 权益id
     * @param spanMinutes 上课时长
     * @param reserveMemberNum 预约人数
     * @param scheduleId 课次id
     * @param scheduleStartTime 上课开始时间
     * @param success
     * @param dataUserInfos
     * @return: java.lang.String
     **/
    public String addPersonalReserve(String areaId,String courseId,String chiefCoachId,String memberId,String benefitId,int spanMinutes,int reserveMemberNum,String scheduleId,long scheduleStartTime,boolean success,DataUserInfo...dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Reserve)
                .setApiName("API_addPersonalReserve")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject body = new JSONObject();
        JSONArray areaIds = new JSONArray(); // 场地,私教约课会用到
        if (!areaId.equals("")){
            areaIds.add(areaId);
        }
        body.put("courseId",courseId);
        body.put("benefitId",benefitId); //会员卡权益Id
        body.put("chiefCoachId", chiefCoachId); // 主教id
        body.put("memberId", memberId); // 会员id
        body.put("planCheckBalance", 1); // 计划扣除额度
        body.put("reserveMemberNum", reserveMemberNum); // 预约人数
        body.put("spanMinutes",spanMinutes);  // 上课时长
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId()); // 操作人id
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        if (!scheduleId.equals("")){
            body.put("scheduleId", scheduleId); // 课次id
        }
        body.put("scheduleStartTime", scheduleStartTime); // 课次id
        body.put("memo","自动化添加预约备注"+TimeUtils.getCurrentTime());
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(success);
        if (success){
            return dataApi.getBodyInJSON().getJSONObject("result").getString("reserveId");
        }
        return dataApi.getBodyInJSON().toString();
        
    }

    /**
     * @description:获取会员预约记录列表
     * @author: xuyamei
     * @date:  2024/6/12 15:26
     * @param courseId 课程id
     * @param reserveStateSet 预约状态
     * @param signState 签到状态
     * @param coachId 教练id
     * @param scheduleStartTime 上课开始时间
     * @param scheduleEndDate 上课结束时间
     * @param memberId  会员id
     * @param courseType 课程类型 GROUP_CLASS：团课
     * @param dataUserInfos
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONArray getPageByMember(String courseId,String reserveStateSet,String signState,String coachId,Long scheduleStartTime,long scheduleEndDate,String memberId,String courseType,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Reserve)
                .setApiName("API_memberReserve_getPageByMember")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject body = new JSONObject();
        body.put("current",0);
        body.put("size",20);
        if (!courseId.equals("")){
            body.put("courseId",courseId);
        }
        if (!reserveStateSet.equals("")){
            JSONArray reserveState = new JSONArray();
            reserveState.add(reserveStateSet);
            body.put("reserveStateSet",reserveState);
        }
        if (!signState.equals("")){
            body.put("signInState",signState);
        }
        if (!coachId.equals("")){
            body.put("coachId",coachId);
        }
        if (scheduleStartTime != null){
            body.put("scheduleStartTime",scheduleStartTime);
            body.put("scheduleEndDate",scheduleEndDate);
        }
        if(!memberId.equals("")){
            body.put("memberId",memberId);
        }
        body.put("courseType",courseType);
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId()); // 操作人id
        body.put("studioId", dataApi.getLoginInfo().getStudioId());

        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result").getJSONArray("records");
    }

    /**
     * @description:预约记录列表
     * @author: xuyamei
     * @date:  2024/6/13 11:42
     * @param courseId 课程id
     * @param reserveState 预约状态
     * @param signState 签到状态
     * @param coachId 教练id
     * @param scheduleStartTime 上课开始时间
     * @param scheduleEndDate 上课结束时间
     * @param memberId  会员id
     * @param courseType 课程类型 GROUP_CLASS：团课
     * @param dataUserInfos
     * @return: com.alibaba.fastjson.JSONArray
     **/
    public JSONArray getPageByStudio(String courseId,String reserveState,String signState,String coachId,Long scheduleStartTime,Long scheduleEndDate,String memberId,String courseType,String campId,DataUserInfo...dataUserInfos){
        dataApi.setApiModule(ApiModule.Polar_Reserve)
                .setApiName("API_memberReserve_getPageByStudio")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);


        JSONObject body = new JSONObject();
        body.put("current",0);
        body.put("size",500);
        if (!courseId.equals("")){
            body.put("courseId",courseId);
        }
        if (!reserveState.equals("")){
            body.put("reserveState",reserveState);
        }
        if (!signState.equals("")){
            body.put("signInState",signState);
        }
        if (!coachId.equals("")){
            body.put("coachId",coachId);
        }
        if (scheduleStartTime != null){
            body.put("scheduleStartTime",scheduleStartTime);
            body.put("scheduleEndDate",scheduleEndDate);
        }
        if(!memberId.equals("")){
            body.put("memberId",memberId);
        }
        if(courseType.equals("TRAINING_CAMP")&& !campId.isEmpty()){
            body.put("tenantMemberCardId",campId);

        }
        body.put("courseType",courseType);
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId()); // 操作人id
        body.put("studioId", dataApi.getLoginInfo().getStudioId());

        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result").getJSONArray("records");
    }


     /**
     * @description:根据id获取预约记录信息
     * @author: xuyamei
     * @date:  2024/6/13 11:51
     * @param reserveId: 预约id
     * @return:
     **/
    public JSONObject getDetailById(String reserveId,DataUserInfo...dataUserInfos) {
        dataApi.setApiModule(ApiModule.Polar_Reserve)
                .setApiName("API_memberReserve_getDetailById")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject body = new JSONObject();
        body.put("reserveId",reserveId);
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId()); // 操作人id
        body.put("studioId", dataApi.getLoginInfo().getStudioId());

        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result");
    }

    /**
     * @description:取消预约、取消排队
     * @author: xuyamei
     * @date:  2024/6/24 09:05
     * @param reserveId 预约id
     * @param success   取消是否成功
     * @return: void
     **/
    public void cancelMemberReserve(String reserveId,boolean success){
        dataApi.setApiModule(ApiModule.Polar_Reserve)
                .setApiName("API_memberReserve_cancel")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONArray reserveIds = new JSONArray();
        reserveIds.add(reserveId);
        JSONObject body = new JSONObject();
        body.put("reserveIds",reserveIds);
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId()); // 操作人id
        body.put("studioId", dataApi.getLoginInfo().getStudioId());

        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(success);
    }


    /**
     * @description:排队
     * @author: xuyamei
     * @date:  2024/6/24 09:12
     * @param areaId ：场地
     * @param chiefCoachId 教练id
     * @param memberId 会员id
     * @param benefitId 权益id
     * @param assistantCoachId 助教id
     * @param reserveMemberNum 预约人数
     * @param scheduleId 课次id
     * @param scheduleStartTime 上课开始时间
     * @param success
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public String addToQueue(String areaId,String chiefCoachId,String memberId,String benefitId,String assistantCoachId,int reserveMemberNum,String scheduleId,long scheduleStartTime,boolean success){
        dataApi.setApiModule(ApiModule.Polar_Reserve)
                .setApiName("API_addToQueue")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONObject body = new JSONObject();
        JSONArray areaIds = new JSONArray(); // 场地,私教约课会用到
        if (!areaId.equals("")){
            areaIds.add(areaId);
        }
        body.put("areaIds",areaIds);
        JSONArray coachIds = new JSONArray(); // 助教Ids
        if (!assistantCoachId.equals("")){
            coachIds.add(assistantCoachId);
        }
        body.put("assistantCoachIds",coachIds);
        body.put("benefitId",benefitId); //会员卡权益Id
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("chiefCoachId", chiefCoachId); // 主教id
        body.put("memberId", memberId); // 会员id
        body.put("operatorId", dataApi.getLoginInfo().getAdminId()); // 操作人id
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("planCheckBalance", 1); // 计划扣除额度
        body.put("reserveMemberNum", reserveMemberNum); // 预约人数
        body.put("scheduleId", scheduleId); // 课次id
        body.put("scheduleStartTime", scheduleStartTime); // 课次id
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(success);
        if (success){
            return dataApi.getBodyInJSON().getJSONObject("result").getString("reserveId");
        }
        return dataApi.getBodyInJSON().toString();
    }

    /**
     * @description:签到
     * @author: xuyamei
     * @date:  2024/6/25 09:34
     * @param success 是否预约成功 正常传true
     * @param reserveId 约课id
     * @param leave 是否请假 （团课、私教课都是false）
     * @return: void
     **/
    public void signIn(boolean success,String reserveId,boolean leave){
        dataApi.setApiModule(ApiModule.Polar_Reserve)
                .setApiName("API_signIn")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONObject body = new JSONObject();
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId()); // 操作人id
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("leave",leave);
        body.put("reserveId",reserveId);
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(success);
    }


    /**
     * @description: 私教列表
     * @author: xuyamei
     * @date:  2024/7/8 11:20
     * @param searchContext ：搜索姓名或手机号
     * @param dataUserInfo
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject pageStudioPersonalCoach(String searchContext,DataUserInfo...dataUserInfo){
        setUp("API_pageStudioPersonalCoach",dataUserInfo);

        JSONObject body = new JSONObject();
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId()); // 操作人id
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("searchContext", searchContext); // 搜索文本：手机号或者员工昵称
        body.put("state", "DUTY"); // 状态：搜索在职的
        body.put("current", 0);
        body.put("size", 20);
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result");
    }

    /**
     * @description:获取具体某个私教的可约时间
     * @author: xuyamei
     * @date:  2024/7/8 11:24
     * @param id 员工id
     * @param vo [normalTimeVOS,specialTimeVOS]
     * ex-enum-descriptions:[常规时间,特定可约时间]
     * @param dataUserInfo
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONArray getPersonalCoachTime(String id,String vo,DataUserInfo...dataUserInfo){
        setUp("API_getPersonalCoachTime",dataUserInfo);

        JSONObject body = new JSONObject();
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId()); // 操作人id
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("id", id); // 员工id
        
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result").getJSONArray(vo);
    }

    /**
     * @description 查询具体某个私教历史特定可约时间
     * @author: xuyamei
     * @date:  2024/7/8 11:50
     * @param
     * @return: com.alibaba.fastjson.JSONArray
     **/
    public JSONArray getCoachHistorySpecialDate(String id){
        setUp("API_getCoachHistorySpecialDate");

        JSONObject body = new JSONObject();
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId()); // 操作人id
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("id", id); // 员工id

        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONArray("result");

    }

    /**
     * @description: 设置常规可约时间
     * @author: xuyamei
     * @date:  2024/7/8 14:44
     * @param coachId ：教练id
     * @param normalTimeInfoRequests ：常规时间（可传空）
     * @param userInfo
     * @return: com.alibaba.fastjson.JSONArray
     **/
    public JSONArray createNormalDate(String coachId,JSONArray normalTimeInfoRequests,DataUserInfo...userInfo){
        setUp("API_createNormalDate",userInfo);

        JSONObject body = new JSONObject();
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId()); // 操作人id
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("coachId", coachId); // 员工id
        JSONObject infoRequests = new JSONObject();

        // 常规时间为空，则快速新建
        if (normalTimeInfoRequests.size() == 0){
            JSONArray timePeriodInfos = new JSONArray();

            int[] minuteOffset = {300,720,1080};
            int[] spanMinutes = {420,360,300};

            for (int i = 0; i < 3; i++){
                JSONObject timeInfo = new JSONObject();
                timeInfo.put("minuteOffset",minuteOffset[i]);
                timeInfo.put("spanMinutes",spanMinutes[i]);
                timePeriodInfos.add(timeInfo);
            }
            infoRequests.put("timePeriodInfos",timePeriodInfos);

            // 每星期
            String[] weekdays = {"MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"};
            infoRequests.put("weekdays",weekdays);
            normalTimeInfoRequests.add(infoRequests);
        }

        body.put("normalTimeInfoRequests",normalTimeInfoRequests);
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        try {
            Thread.sleep(5000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return dataApi.getBodyInJSON().getJSONArray("result");

    }



    /**
     * @description:创建特殊可约时间
     * @author: xuyamei
     * @date:  2024/7/23 16:39
     * @param coachId 教练id
     * @param dutyType ["OFF_DUTY","ON_DUTY"] ["全天休息","可约时间"]
     * @param specialTimeInfoRequests ：可单独传可约时间段，不用默认创建全天休息的时间
     * @param userInfo
     * @return: void
     **/
    public void createSpecialDate(String coachId,String dutyType,JSONObject specialTimeInfoRequests,DataUserInfo...userInfo){
        setUp("API_createSpecialDate",userInfo);

        JSONObject body = new JSONObject();
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("coachId", coachId);


        // 如果不传可约时间，则快速新建
        if (specialTimeInfoRequests.size() == 0){
            // 可约时间类型
            specialTimeInfoRequests.put("dutyType", dutyType);

            // 设置特定日期
            JSONArray selectedDates = new JSONArray();
            selectedDates.add(TimeUtils.getTodayTime());
            specialTimeInfoRequests.put("selectedDates", selectedDates);

            // 如果是可约时间非全天休息，则传可约时间段
            if (dutyType.equals("ON_DUTY")){
                // 时间段 00:00 ~ 23:59
                JSONArray timePeriodInfos = new JSONArray();
                JSONObject timeInfo = new JSONObject();
                timeInfo.put("minuteOffset", 0);
                timeInfo.put("spanMinutes", 1380);
                timePeriodInfos.add(timeInfo);
                specialTimeInfoRequests.put("timePeriodInfos", timePeriodInfos);
            }

        }

        body.put("specialTimeInfoRequest", specialTimeInfoRequests);

        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        try {
            Thread.sleep(5000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }


    /**
     * @description: 删除特殊可约时间
     * @author: xuyamei
     * @date:  2024/7/23 16:39
     * @param id 特约日期记录id
     * @param userInfo
     **/
    public void deleteSpecialDate(String id,DataUserInfo...userInfo){
        setUp("API_deleteSpecialDate",userInfo);

        JSONObject body = new JSONObject();
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());

        JSONArray ids = new JSONArray();
        ids.add(id);
        body.put("ids", ids);

        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
    }

    /**
     * @description: 修改特殊可约时间
     * @author: xuyamei
     * @date:  2024/7/24 11:16
     * @param coachId 教练id
     * @param dutyType 可约类型 ["OFF_DUTY","ON_DUTY"] ["全天休息","可约时间"]
     * @param timePeriodInfos 时间段 [{minuteOffset,spanMinutes}]  可约类型为全天休息时传空
     * @param userInfo
     * @return: void
     **/
    public void modifySpecialDate(String coachId,String dutyType,JSONArray timePeriodInfos,Long selectedDate,DataUserInfo...userInfo){
        setUp("API_modifySpecialDate",userInfo);

        JSONObject body = new JSONObject();
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("dutyType", dutyType);
        body.put("coachId", coachId);
        body.put("selectedDate", selectedDate);
        if (timePeriodInfos.size() != 0){
            body.put("timePeriodInfos", timePeriodInfos);
        }

        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);

    }


    /**
     * @description: 获取私教课程的可约时间块
     * @author: xuyamei
     * @date:  2024/7/24 17:17
     * @param coachId 教练id
     * @param courseId 课程id
     * @param selectedDate 选中日期
     * @param userInfos
     * @return: com.alibaba.fastjson.JSONArray
     **/
    public JSONArray getPersonalTimeBlocks(String coachId,String courseId,Long selectedDate,DataUserInfo...userInfos){
        setUp("API_getPersonalTimeBlocks",userInfos);

        JSONObject body = new JSONObject();
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("coachId", coachId);
        body.put("courseId", courseId);
        body.put("selectedDate", selectedDate);

        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONArray("result");
    }


    /**
     * @param startDate
     * @param endDate
     * @description:查询私教课表
     * @author: xuyamei
     * @date: 2024/6/23 17:46
     * @return: com.alibaba.fastjson.JSONArray
     **/
    public JSONArray getPersonalScheduleTable(Long startDate, Long endDate,String courseId) {
        setUp("API_getPersonalScheduleTable");
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        if (courseId.equals("")){
            body.put("courseId", courseId);
        }
        body.put("startDate", startDate);
        body.put("endDate", endDate);
        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs).assetsSuccess(true);
        if (Integer.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.totalCount")) > 0) {
            return dataApi.getBodyInJSON().getJSONObject("result").getJSONArray("timetableGroups").getJSONObject(0).getJSONArray("timetableList");
        }
        else {
            return null;
        }
    }



    /**
     * @description:删除私教课次
     * @author: xuyamei
     * @date:  2024/7/29 16:13
     * @param scheduleId ： 课次id
     * @return: void
     **/
    public void delPersonalScheduleItem(String scheduleId){
        setUp("API_delPersonalScheduleItem");
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("scheduleId", scheduleId);
        body.put("applyRestRule", false);
        
        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs).assetsSuccess(true);
    }

}
