package com.xiaomai.cases.polar.reserve.group;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.clue.MemberTools;
import com.xiaomai.cases.polar.course.CourseTools;
import com.xiaomai.cases.polar.finance.order.OrderTools;
import com.xiaomai.cases.polar.member.Tools;
import com.xiaomai.cases.polar.memberCard.CardTools;
import com.xiaomai.cases.polar.reserve.ReserveTools;
import com.xiaomai.cases.polar.schedule.group.GroupScheduleTools;
import com.xiaomai.cases.polar.setting.courseCategory.CourseCategoryTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.CommUtil;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Random;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.reserve
 * @Author: xuyamei
 * @CreateTime: 2024-06-25  09:16
 * @Description: 签到
 * @Version: 1.0
 */
public class TestSignIn extends BaseTestImpl {

    @Resource(name = "courseCategoryTools")
    CourseCategoryTools courseCategoryTools;
    @Resource(name = "courseTools")
    CourseTools courseTools;

    @Resource(name = "reserveTools")
    ReserveTools reserveTools;

    @Resource(name = "groupScheduleTools")
    GroupScheduleTools groupScheduleTools;

    MemberTools memberTools = new MemberTools();

    OrderTools orderTools = new OrderTools();
    CardTools cardTools = new CardTools();

    Tools tools = new Tools();

    String todayStartTimeTamp = CommUtil.oneKeyGetAddDay(-1);


    //获取今天结束日期的时间戳
    String todayEndDateTimeTamp = CommUtil.getNDayEndTimeTamp(-1);
    Long scheduleEndTime = TimeUtils.getTodayEndTime(-1);
    private String ruldId;
    private JSONArray memberInfo = new JSONArray();
    private String scheduleId;
    private Long startTime;
    private String courseId;


    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Reserve,"API_signIn", LoginAccount.GYM_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @Test(description = "签到")
    public void testSignIn() {
        // 创建团课课次
        createGroupSchedule();
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        // 创建点名学员A
        memberInfo = createMember("点名学员佳佳");
        // 查询课次详情 查课次的开始时间
        JSONObject getScheduleItemDetail = groupScheduleTools.getScheduleItemDetail(scheduleId);
        startTime = getScheduleItemDetail.getLongValue("startTime");
        // 预约
        String reserveId = reserveTools.addReserve("","", memberInfo.getString(1),xmAppApi.getLoginInfo().getAdminId(), memberInfo.getString(0),1,scheduleId,startTime,true);
        memberInfo.add(reserveId);
        try {
            Thread.sleep(2000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        // 操作签到
        reserveTools.signIn(true, memberInfo.getString(3),false);
        try {
            Thread.sleep(2000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        // check 1：课次学员是否包含该会员且会员状态为已签到
        getScheduleItemDetail = groupScheduleTools.getScheduleItemDetail(scheduleId);
        JSONArray reserveIds = getScheduleItemDetail.getJSONArray("memberReserveList");
        boolean success = false;
        for (int i = 0; i < reserveIds.size(); i++){
            if(reserveIds.getJSONObject(i).getString("id").equals(reserveId)){
                success = true;
                Assert.assertEquals(reserveIds.getJSONObject(i).getString("signInState"),"SIGNED","签到状态错误");
            }
        }
        Assert.assertTrue(success,"约课后课次详情学员不在课次中");

        // check 2: 预约记录是否包含该预约
        // check 2.1 学员详情预约记录
        JSONArray getPageByMember = reserveTools.getPageByMember(courseId,"SUCCESS","SIGNED","", startTime,scheduleEndTime, memberInfo.getString(0),"GROUP_CLASS");
        String[] result = new String[] {"id","benefitId","reserveMemberNum","courseId","courseType","scheduleStartTime","reserveState","scheduleId","signInState"};
        String[] resultData = new String[] {reserveId, memberInfo.getString(1),"1",courseId,"GROUP_CLASS",startTime+"","SUCCESS",scheduleId,"SIGNED"};
        success = false;
        for(int i =0;i<getPageByMember.size();i++){
            if (getPageByMember.getJSONObject(i).getString("id").equals(reserveId)){
                success = true;
                for(int j = 0;j<result.length;j++){
                    Assert.assertEquals(getPageByMember.getJSONObject(i).getString(result[j]),resultData[j],"约课产生的数据与实际数据不符合"+result[j]+"："+resultData[j]);
                }
            }
        }
        Assert.assertTrue(success,"约课后在会员详情页面未查询到相关信息");
        // check 2.2 预约记录列表
        JSONArray getPageByStudio = reserveTools.getPageByStudio(courseId,"SUCCESS","SIGNED","",startTime,scheduleEndTime, memberInfo.getString(0),"GROUP_CLASS","");
        success = false;
        for(int i =0;i<getPageByStudio.size();i++){
            if (getPageByStudio.getJSONObject(i).getString("id").equals(reserveId)){
                success = true;
                for(int j = 0;j<result.length;j++){
                    Assert.assertEquals(getPageByStudio.getJSONObject(i).getString(result[j]),resultData[j],"约课产生的数据与实际数据不符合"+result[j]+"："+resultData[j]);
                }
                Assert.assertEquals(getPageByStudio.getJSONObject(i).getString("memberId"), memberInfo.getString(0),"查询的约课数据不是同一个会员");
            }
        }
        Assert.assertTrue(success,"约课后在约课记录没有查询到相关信息");
        // check 2.3 预约记录详情
        JSONObject getDetailById = reserveTools.getDetailById(reserveId);
        for(int j = 0;j<result.length;j++){
            Assert.assertEquals(getDetailById.getString(result[j]),resultData[j],"约课产生的数据与实际数据不符合"+result[j]+"："+resultData[j]);
        }
        Assert.assertEquals(getDetailById.getString("memberId"), memberInfo.getString(0),"查询的约课数据不是同一个会员");

        // check 3： 会员卡消耗记录中包含该记录签到消耗
        JSONArray consumeRecord = cardTools.fetchPageOfConsumeRecord(memberInfo.getString(1),memberInfo.getString(2)).getJSONObject("result").getJSONArray("records");
        String[] result2 = new String[] {"resourceId","consumeType","changeOfPurchaseBalance"};
        String[] respect = new String[] {reserveId,"SIGN_IN","-1.00"};
        String[] message = new String[] {"会员卡消耗记录中记录的资源id与实际约课记录id不符合","会员卡消耗记录中记录的资源id与实际约课记录类型不符合","会员卡消耗记录中记录的资源id与实际约课记录余额不符合"};
        for (int i = 0; i < result2.length; i++){
            Assert.assertEquals(consumeRecord.getJSONObject(0).getString(result2[i]),respect[i],message[i]);
        }
    }

    @DataProvider(name = "dataProvider")
    public Object[][] dataProvider() {
        return new Object[][]{
                {"signIn", "签到失败，已经签到，无需重复操作"},  // 已经签到再次签到
                {"cancel", "已签到预约记录无法取消"},  // 已经签到取消预约

        };
    }
    @Test(description = "签到",priority = 1,dataProvider = "dataProvider")
    public void testSignIn2(String type,String message) {
        if (type.equals("signIn")){
            reserveTools.signIn(false, memberInfo.getString(3),false);
            JSONObject response = dataApi.getBodyInJSON();
            Assert.assertEquals(response.getString("message"),message,"已经操作签到，又操作签到提示错误");
        }else {
            reserveTools.cancelMemberReserve(memberInfo.getString(3),false);
            JSONObject response = dataApi.getBodyInJSON();
            Assert.assertEquals(response.getString("message"),message,"已经操作签到，又操作取消提示错误");
        }


    }








    /**
     * @description:买卡
     * @author: xuyamei
     * @date:  2024/6/24 19:42
     * @param courseId 课程id
     * @param memberId 会员id
     * @return: void
     **/
    public void signOrder(String courseId,String memberId){
        // 查询存量的卡
        JSONObject fetchPageOfMemberCard = cardTools.fetchPageOfMemberCard(courseId);
        int total = Integer.parseInt(fetchPageOfMemberCard.getString("total"));
        String cardId = "";
        BigDecimal quantity = new BigDecimal(0);
        float price = 0;
        int validPeriod = 0;
        if (total == 0) {
            cardId = cardTools.memberCardCreate("约课使用会员卡"+TimeUtils.getCurrentTime()).getString("result");
        }
        cardId = fetchPageOfMemberCard.getJSONArray("records").getJSONObject(0).getString("id");
        quantity = new BigDecimal(fetchPageOfMemberCard.getJSONArray("records").getJSONObject(0).getString("balance"));
        price = Float.parseFloat(fetchPageOfMemberCard.getJSONArray("records").getJSONObject(0).getString("price"));
        validPeriod = Integer.parseInt(fetchPageOfMemberCard.getJSONArray("records").getJSONObject(0).getString("validPeriod"));

        //获取签单要用的卡快照id
        String latestSnapshotId = orderTools.fetchDetailById(cardId,xmAppApi.getLoginInfo().getBrandId(),xmAppApi.getLoginInfo().getStudioId(),xmAppApi.getLoginInfo().getAdminId()).getJSONObject("result").getString("latestSnapshotId");

        //检查会员对该卡是否超出购买上限
        boolean limitResult= orderTools.checkAllowPurchase("MEMBER_CARD",cardId,cardId,"1",xmAppApi.getLoginInfo().getBrandId(),xmAppApi.getLoginInfo().getStudioId(),xmAppApi.getLoginInfo().getAdminId()).getBoolean("success");

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        if( limitResult == true){
            //创建订单
            JSONObject orderResult=orderTools.signOrder(cardId,latestSnapshotId,quantity,price,validPeriod,latestSnapshotId, price/2,"PURCHASE",
                    "MEMBER_CARD",memberId,price-price/2,price-price/2,"1");
        }
    }


    // 创建团课课次
    public void createGroupSchedule(){
        // 查询存量的约课课程
        // 查询存量的课程分类
        String categoryId = courseCategoryTools.getCourseCategoryPage("瑜伽");
        courseId = courseTools.getPersonalOrGroupCourseId("GROUP", "艾格瑜伽团课课程（点名）", categoryId, "STUDIO", "", 2, 1).getString(0);
        // 创建排课
        int[] minuteOffset = {60, 120, 180,  240, 300, 360,  420,  480, 540,  600,  660, 720, 780,  840,  900, 960, 1020, 1080, 1140, 1200, 1260};
        Random random = new Random();
        //1.1-创建排课日程（前一天的课程）
        groupScheduleTools.createGroupRuleSchedule(courseId, xmAppApi.getLoginInfo().getAdminId(), todayStartTimeTamp, todayEndDateTimeTamp, new ArrayList(), new ArrayList(), true, 1,minuteOffset[random.nextInt(20)]);
        try {
            Thread.sleep(2000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        //1.2-查询排课日程
        JSONArray getGroupRuleScheduleList = groupScheduleTools.getGroupRuleScheduleList(courseId, xmAppApi.getLoginInfo().getAdminId());
        //统计查询到的目标日程数量
        ruldId = XMJSONPath.readPath(getGroupRuleScheduleList.getJSONObject(0), "$.ruleId");
        Long scheduleEndTime = TimeUtils.getTodayEndTime(-1);
        try {
            Thread.sleep(2500);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        // 查询课次id
        JSONArray getGroupScheduleTable = groupScheduleTools.getGroupScheduleTable(Long.valueOf(todayStartTimeTamp), scheduleEndTime,courseId);
        for (int i = 0; i < getGroupScheduleTable.size(); i++){
            if (getGroupScheduleTable.getJSONObject(i).containsKey("ruleId")  && getGroupScheduleTable.getJSONObject(i).getString("ruleId").equals(ruldId)){
                scheduleId = getGroupScheduleTable.getJSONObject(i).getString("scheduleId");
                break;
            }
        }
    }

    /**
     * @description:创建学员并查询会员是否购买会员卡，如果已购买则查看权益，如果没有则进行购买
     * @author: xuyamei
     * @date:  2024/6/24 19:43
     * @param memberName：会员姓名
     * @return:
     **/
    public JSONArray createMember(String memberName){
        String memberId = "";
        // 查询存量的学员没有则创建学员，
        if (tools.commonSearch(memberName,"NORMAL").getJSONArray("result").size()>0){
            memberId = tools.commonSearch(memberName,"NORMAL").getJSONArray("result").getJSONObject(0).getString("id");
        }else if (tools.commonSearch(memberName,"HISTORY").getJSONArray("result").size()>0){
            memberId = tools.commonSearch(memberName,"HISTORY").getJSONArray("result").getJSONObject(0).getString("id");
        }else if (tools.commonSearch(memberName,"POTENTIAL").getJSONArray("result").size()>0){
            memberId = tools.commonSearch(memberName,"POTENTIAL").getJSONArray("result").getJSONObject(0).getString("id");
        }else{
            memberId = memberTools.create(memberName, RandomStringUtil.randomMobile("203")).getString("result");
        }

        // 查询是否有可用的会员卡，没有则购买
        JSONArray listUserReservableBenefit = cardTools.listUserReservableBenefit(courseId, "GROUP_CLASS", "MEMBER", memberId, Long.parseLong(todayStartTimeTamp));
        if (listUserReservableBenefit.size() == 0) {
            // 购买适用的会员卡
            signOrder(courseId, memberId);
            try {
                Thread.sleep(2000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            listUserReservableBenefit = cardTools.listUserReservableBenefit(courseId, "GROUP_CLASS", "MEMBER", memberId, Long.parseLong(todayStartTimeTamp));
        }
        // 查询权益
        String benefitId = listUserReservableBenefit.getJSONObject(0).getString("benefitId");
        String memberCardId = listUserReservableBenefit.getJSONObject(0).getString("memberCardId");

        JSONArray members = new JSONArray();
        members.add(memberId);
        members.add(benefitId);
        members.add(memberCardId);
        return members;
    }


}
