package com.xiaomai.cases.polar.finance.cashier;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.math.BigDecimal;

public class TestRefundByRecord extends XMBaseTest {
    CashierTools cashierTools=new CashierTools();

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_refundByRecord")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "流水退款")
    public void testRefundByRecord(){
        //此接口可真实退收款码进来的流水，只用把signId和payTransNo改成同一个收款成功流水id，transAmount改成这笔收款流水的真实可退金额即可，这些都只能写死，因为场馆不会一直有收款成功的流水；
        //目前1808757176611880962这笔流水是已经结算过的收款流水，商户号下没有钱退，但是当商户号下有钱可退的时候，这个case会报错，因为可以退成功

        //乐动收银退款预校验-检查流水是否可退
        String checkBeforeRefundCode=cashierTools.checkBeforeRefund("1808757176611880962", BigDecimal.valueOf(0.01)).getJSONObject("result").getString("code");

            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }

            //如果校验为可退
            if("SUCCESS".equals(checkBeforeRefundCode)){

                //流水退款
                JSONObject refundByRecordResult=new JSONObject();
                refundByRecordResult.put("transAmount",0.01);
                refundByRecordResult.put("refundReason", RandomStringUtil.randomString(6));
                refundByRecordResult.put("orderType","PAY_QR_CODE");
                refundByRecordResult.put("payTransNo","1808757176611880962");
                refundByRecordResult.put("brandId", xmAppApi.getLoginInfo().getBrandId());
                refundByRecordResult.put("studioId", xmAppApi.getLoginInfo().getStudioId());
                refundByRecordResult.put("operatorId", xmAppApi.getLoginInfo().getAdminId());

                xmAppApi.doRequest(RequestType.JSON, params, refundByRecordResult.toJSONString(), headers).assetsSuccess(true);
                String success = xmAppApi.getBodyInJSON().getString("success");
                String failCode = xmAppApi.getBodyInJSON().getJSONObject("result").getString("failCode");
                Assert.assertEquals(success, "true", "获取流水退款失败");
                Assert.assertEquals(failCode, "OTHER_ERROR", "当前乐动收银余额不足，无法退款，请在线收款后再次发起退款或者线下处理退款");

            }

            else{
                Assert.assertEquals(checkBeforeRefundCode,"AMOUNT_LIMIT","订单关联流水可退金额不足，请修改退款金额后重试");
            }


            }
        }




