package com.xiaomai.cases.polar.data.financeData;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestGetOrderTrend extends XMBaseTest {

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Data)
                .setApiName("API_getOrderTrend")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @DataProvider
    public Object[][] dataProvider(){
        return new Object[][]{

                {"DAY","ORDER_RECEIVABLE_AMOUNT", TimeUtils.getTodayEndTime(),TimeUtils.getTodayTime()},//订单应收金额,今天
                {"MONTH","ORDER_ACTUAL_AMOUNT",TimeUtils.getMonthLastDay(),TimeUtils.getMonthFristDay()},//订单实收金额,本月
                {"DAY","ORDER_REFUND_AMOUNT", TimeUtils.getTodayEndTime(),TimeUtils.getTodayTime()},//退款金额,今天
                {"MONTH","ORDER_UNPAID_AMOUNT",TimeUtils.getMonthLastDay(),TimeUtils.getMonthFristDay()},//欠费金额,本月

        };
    }

    @Test(description = "数据中心-财务数据-订单趋势图",dataProvider = "dataProvider")
    public void testGetOrderTrend(String dateType,String metric,long endTime,long startTime){


        JSONObject trend=new JSONObject();
        trend.put("dateType",dateType);
        trend.put("endTime", endTime);
        trend.put("startTime", startTime);
        trend.put("metric",metric);
        trend.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        trend.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        trend.put("operatorId",xmAppApi.getLoginInfo().getAdminId());


        xmAppApi.doRequest(RequestType.JSON,params,trend.toJSONString(),headers).assetsSuccess(true);
        String trendResult=xmAppApi.getBodyInJSON().getString("success");
        Assert.assertEquals(trendResult,"true","获取财务数据-订单趋势图失败");

    }


    @DataProvider
    public Object[][] dataProvider1(){
        return new Object[][]{
                {"WEEK","ORDER_RECEIVABLE_AMOUNT",TimeUtils.getWeekLastTime(),TimeUtils.getWeekFirstTime()},//订单应收金额，本周
                {"WEEK","ORDER_ACTUAL_AMOUNT",TimeUtils.getWeekLastTime(),TimeUtils.getWeekFirstTime()},//订单实收金额，本周
                {"WEEK","ORDER_REFUND_AMOUNT",TimeUtils.getWeekLastTime(),TimeUtils.getWeekFirstTime()},//退款金额，本周
                {"WEEK","ORDER_UNPAID_AMOUNT",TimeUtils.getWeekLastTime(),TimeUtils.getWeekFirstTime()},//欠费金额，本周

        };
    }


    @Test(description = "数据中心-财务数据-订单趋势图",dataProvider = "dataProvider1")
    public void testGetOrderTrend1(String dateType,String metric,String endTime,String startTime){


        JSONObject trend=new JSONObject();
        trend.put("dateType",dateType);
        trend.put("endTime", endTime);
        trend.put("startTime", startTime);
        trend.put("metric",metric);
        trend.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        trend.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        trend.put("operatorId",xmAppApi.getLoginInfo().getAdminId());


        xmAppApi.doRequest(RequestType.JSON,params,trend.toJSONString(),headers).assetsSuccess(true);
        String trendResult=xmAppApi.getBodyInJSON().getString("success");
        Assert.assertEquals(trendResult,"true","获取财务数据-订单趋势图失败");

    }



}
