package com.xiaomai.cases.polar.invitationGifts;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.springframework.stereotype.Component;

@Component("InvitationGiftsMinTools")
public class InvitationGiftsMinTools extends BaseTestImpl {
    /**
     * @param
     * @description:小程序获取邀请有礼详情-邀请人页面
     * @author: yangjian
     * @param memberId 会员ID
     **/
    public JSONObject invitationActivityGetStudioActivityDetail(String memberId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Lunar_Invitation)
                .setApiName("API_invitationActivityGetStudioActivityDetail")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("promoterId", memberId);//String memberId = userTools.getMemberInfo().getString("memberId");

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }
    /**
     * @param
     * @description:被邀请人页面
     * @author: yangjian
     * @param memberId 会员ID
     * @param activityId 邀请有礼活动ID
     **/
    public JSONObject invitationActivityGetStudioActivityDetail1(String memberId,String activityId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Lunar_Invitation)
                .setApiName("API_invitationActivityGetStudioActivityDetail")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("activityId", activityId);
        jsonObject.put("promoterId", memberId);//String memberId = userTools.getMemberInfo().getString("memberId");

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:参与邀请有礼活动
     * @author: yangjian
     * @param memberId 会员ID
     * @param promoteRecordId //被邀请人页面memberPromoteRecord-id
     **/
    public JSONObject joinActivity(String memberId,String promoteRecordId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Lunar_Invitation)
                .setApiName("API_joinActivity")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("inviteeId", memberId);
        jsonObject.put("newRegisterMember", true);
        jsonObject.put("noConsumeMember", true);
        jsonObject.put("promoteRecordId", promoteRecordId);//String memberId = userTools.getMemberInfo().getString("memberId");

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:生成推广记录
     * @author: yangjian
     * @param memberId 会员ID
     * @param activityId 活动ID
     **/
    public JSONObject promoteActivity(String memberId,String activityId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Lunar_Invitation)
                .setApiName("API_promoteActivity")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("promoterId", memberId);
        jsonObject.put("activityId", activityId);



        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

}
