package com.xiaomai.cases.polar.finance.cashier;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;

import java.math.BigDecimal;

public class CashierTools extends XMBaseTest {

    /**
     * @param
     * @description: 分页筛选收银流水-搜索
     * @param buyerName:支付姓名 不用需要传null
     * @param buyerPhone：支付手机号 不用需要传null
     * @param businessNo：支付订单号 不用需要传null
     * @author: yangfangfang
     **/
    public JSONObject page_select(String buyerName, String buyerPhone, String businessNo, DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_page")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("buyerName",buyerName);
        jsonObject.put("buyerPhone",buyerPhone);
        jsonObject.put("businessNo",businessNo);
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description: 分页筛选收银流水-筛选
     * @param subChannel:支付方式 [ "支付宝", "微信" ] [ ALI, WX ]
     * @param orderType：来源 [ "未知", "签单", "退单", "作废订单", "收款码", "B端短信充值", "电子合同" ][ UNKNOWN, SIGN_ORDER, REFUND_ORDER, DISCARD_ORDER, PAY_QR_CODE, B_SMS_RECHARGE, ELE_CONTRACT ]
     * @param transState :状态 [ PAY_INIT: 支付初始态;PAYING: 支付中;PAY_FAIL: 支付失败;PAY_SUCCESS: 支付成功（入账中）;PAY_IN: 入账成功;REFUND_INIT: 退款初始态;REFUNDING: 退款中;REFUND_SUCCESS: 退款成功;REFUND_FAIL: 退款失败; ]
     * @author: yangfangfang
     **/

    public JSONObject page_sift(String subChannel, String orderType,String transState, DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_page")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);
        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("subChannel",subChannel);

        JSONArray transStateList=new JSONArray();
        transStateList.add(transState);
        jsonObject.put("transStateList",transStateList);

        jsonObject.put("orderType",orderType);

        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }




    /**
     * @param
     * @description: 分页筛选收银流水-筛选
     * @param signId:支付流水ID
     * @param actualAmount：实际可退金额
     * @author: yangfangfang
     **/

    public JSONObject checkBeforeRefund(String signId, BigDecimal actualAmount,  DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_checkBeforeRefund")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();

        JSONArray ids=new JSONArray();
        ids.add(signId);
        jsonObject.put("ids",ids);

        jsonObject.put("amount",actualAmount);
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());


        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

}
