package com.xiaomai.cases.polar.export;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author zxy
 * @Description
 * @Date 2024/11/15 15:01
 */
public class TestExportCard extends XMBaseTest {
    ExportTool exportTool = new ExportTool();
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Export)
                .setApiName("API_exportCard")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("zyx")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @DataProvider
    public Object[][] data(){
        return new Object[][]{
                {"MEMBER","导出已售会员卡"},//会员卡
                {"EXPERIENCE","导出已售体验卡"},//体验卡
                {"DEPOSIT","导出已售储值卡"},//储值卡
                {"TRAINING","导出已售训练营"}//训练营
        };
    }

    @Test(description = "售卖记录/训练营报名记录导出",dataProvider = "data")
    public void testExportCard(String accountType,String workflowName){
        List memberCardStateList = new ArrayList();
        memberCardStateList.add("DISCARD");

        JSONObject object = new JSONObject();
        object.put("accountType",accountType);
        object.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        object.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        object.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        object.put("memberCardStateList",memberCardStateList);

        if (accountType == "TRAINING"){
            object.put("current",0);
            object.put("size",20);
        }

        xmAppApi.doRequest(RequestType.JSON,params,object.toString(),headers).assetsSuccess(true);

        try {
            Thread.sleep(8000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        JSONObject res = exportTool.pageStudioExportRecord().getJSONObject("result").getJSONArray("records").getJSONObject(0);
        Assert.assertEquals(res.getString("id"),xmAppApi.getBodyInJSON().getString("result"));
        Assert.assertEquals(res.getString("workflowName"),workflowName);
        Assert.assertEquals(res.getString("state"),"SUCCESS");

        //下载文件
        if(res.getString("state").equals("SUCCESS")){
            exportTool.getUrl(res.getJSONObject("json").getString("resourceId"));
        }
    }
}
