package com.xiaomai.cases.polar.export;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @Author zxy
 * @Description
 * @Date 2024/11/15 16:02
 */
public class TestExportVoucher extends XMBaseTest {
    ExportTool exportTool = new ExportTool();
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Export)
                .setApiName("API_exportVoucher")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("zyx")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "导出订单列表")
    public void testExportVoucher(){
        JSONObject object = new JSONObject();
        object.put("current",0);
        object.put("size",20);
        object.put("supplierId", xmAppApi.getLoginInfo().getStudioId());
        object.put("source","SYSTEM");
        object.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        object.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        object.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON,params,object.toString(),headers).assetsSuccess(true);

        try {
            Thread.sleep(6000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

        JSONObject res = exportTool.pageStudioExportRecord().getJSONObject("result").getJSONArray("records").getJSONObject(0);
        Assert.assertEquals(res.getString("id"),xmAppApi.getBodyInJSON().getString("result"));
        Assert.assertEquals(res.getString("workflowName"),"导出订单列表");
        Assert.assertEquals(res.getString("state"),"SUCCESS");

        //下载文件
        if(res.getString("state").equals("SUCCESS")){
            exportTool.getUrl(res.getJSONObject("json").getString("resourceId"));
        }
    }
}
