package com.xiaomai.cases.polar.member;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestFindDetailById extends XMBaseTest {

    Tools tools=new Tools();

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_findStudioMemberDetail")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @DataProvider
    public  Object[][] dataProvider(){
        return new Object[][]{
                {"NORMAL","NORMAL"},
                {"HISTORY","HISTORY"}
        };
    }

    //编辑会员资料前调用的会员详情，非点击会员之后的会员详情findStudioMemberDetail，点击之后的正式会员详情和流失会员详情已在TestForceUpdate中覆盖，这里就不再冗余了
    @Test(description = "编辑会员资料调用的会员详情",dataProvider = "dataProvider")
    public void testFindDetailById(String searchType,String status){

        //获取正式/流失会员列表
        JSONObject memberResult=tools.search(searchType,status);
        String id=memberResult.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("memberId",id);
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());


        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(true);
        JSONObject response=xmAppApi.getBodyInJSON();
        String success=response.getString("success");
        Assert.assertEquals(success,"true","获取正式/流失会员详情以及更多资料失败");

    }

    @Test(description = "编辑会员资料调用的会员详情-会员id不能为空",dataProvider = "dataProvider")
    public void testFindDetailById_1(String searchType,String status){

        //获取正式/流失会员列表
        JSONObject memberResult=tools.search(searchType,status);
        String id=memberResult.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");

        JSONObject jsonObject1=new JSONObject();
        jsonObject1.put("memberId","");
        jsonObject1.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject1.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject1.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON,params,jsonObject1.toJSONString(),headers).assetsSuccess(false);
        Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$message"),"会员id不能为空");

    }


}
