package com.xiaomai.cases.polar.applet;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;

import java.util.Random;

/**
 * @Author zxy
 * @Description
 * @Date 2024/7/1 16:15
 */
public class AppletTools extends BaseTestImpl {
    //查询小程序租户授权信息
    public JSONObject getAuthDetail(DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Applet)
                .setApiName("API_getAuthDetail")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        Random random = new Random();

        object.put("tenantId",dataApi.getLoginInfo().getStudioId());
        object.put("tenantType","STUDIO");
        object.put("withExtInfo",random.nextBoolean());


        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //获取小程序页面配置
    public JSONObject getPageConfig(String pageKey,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Applet)
                .setApiName("API_getPageConfig")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("tenantId",dataApi.getLoginInfo().getStudioId());
        object.put("tenantType","STUDIO");
        object.put("pageKey",pageKey);

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //获取小程序全局配置
    public JSONObject getStyleConfig(DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Applet)
                .setApiName("API_getStyleConfig")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("tenantId",dataApi.getLoginInfo().getBrandId());
        object.put("tenantType","BRAND");

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
}
