package com.xiaomai.cases.polar.course;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.springframework.stereotype.Component;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.course
 * @Author: xuyamei
 * @CreateTime: 2024-04-29  20:21
 * @Description: 课程工具类
 * @Version: 1.0
 */
@Component("courseTools")
public class CourseTools extends XMBaseTest {

    /**
     * @description:创建私教课程
     * @author: xuyamei
     * @date:  2024/5/6 10:53
     * @param courseName:课程名称
     * @param categoryId：课程分类id
     * @param sourceType：课程来源类型 1：品牌BRAND 2：场馆STUDIO
     * @param sizeType：课程大小类型 1：1对1 ONE_TO_ONE 2：1v2 ONE_TO_MANY
     * @param capacity：课次容量
     * @param minCapacity：开课人数
     * @return: 课程id
     **/
    public String createPersonalCourse(String courseName,String categoryId,String sourceType,String sizeType,int capacity,int minCapacity,DataUserInfo...dataUserInfo){
        dataApi.setApiModule(ApiModule.Polar_Course)
                .setApiName("API_personalCreate")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfo);

        JSONObject body= new JSONObject();
        body.put("courseName", courseName);
        body.put("duration", 60);      // 时长
        body.put("difficulty", 3);     // 难度
        body.put("color", "#AACF53");
        body.put("coverId", "0");
        body.put("timeUnit", "MINUTE");
        body.put("categoryId", categoryId);
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("sourceId", dataApi.getLoginInfo().getStudioId());  // 来源：场馆、品牌
        body.put("sourceType", sourceType);
        body.put("brandId", dataApi.getLoginInfo().getBrandId());  // 品牌
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("sizeType", sizeType);  // 私教模式
        body.put("allArea", false); // 场地
        JSONArray coachIds = new JSONArray(); // 教练
        coachIds.add(dataApi.getLoginInfo().getAdminId());
        body.put("coachIds", coachIds);
        if (sizeType.equals("ONE_TO_MANY")){  // 一对多需要传课次容量及开课人数
            body.put("capacity", capacity); // 课容量
            body.put("minCapacity", minCapacity); // 开课人数
        }


        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getString("result");
    }
    /**
     * @description:创建团课
     * @author: xuyamei
     * @date:  2024/5/7 10:18
     * @param courseName ：课程名称
     * @param categoryId ：课程类型
     * @param sourceType：课程来源类型 1：品牌BRAND 2：场馆STUDIO
     * @return: java.lang.String
     **/
    public String createGroupCourse(String courseName,String categoryId,String sourceType,DataUserInfo...dataUserInfo){
        dataApi.setApiModule(ApiModule.Polar_Course)
                .setApiName("API_createGroupCourse")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfo);
        String introduction = "{\"items\":[{\"content\":\"花花世界的\",\"aspect\":\"\",\"type\":\"TEXT\"}]}";
        JSONObject body= new JSONObject();
        body.put("courseName", courseName);
        body.put("duration", 60);      // 时长
        body.put("difficulty", 2);     // 难度
        body.put("color", "#AACF53");
        body.put("coverId", "0");
        body.put("timeUnit", "MINUTE");
        body.put("categoryId", categoryId);
        body.put("introduction", introduction);
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("sourceId", dataApi.getLoginInfo().getStudioId());  // 来源：场馆、品牌
        body.put("sourceType", sourceType);
        body.put("brandId", dataApi.getLoginInfo().getBrandId());  // 品牌
        body.put("studioId", dataApi.getLoginInfo().getStudioId()); // 场馆
        body.put("calorie", 0);  // 卡路里 传0对于后端是未设置

        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getString("result");
    }

    /**
     * @description:获取存量的课程id，没有则新建
     * @author: xuyamei
     * @date:  2024/5/7 10:11
     * @param courseType ：课程类型 PERSONAL私教;GROUP团课
     * @param courseName：课程名称
     * @param categoryId: 课程分类id
     * @param sourceType:课程来源类型 1：品牌BRAND 2：场馆STUDIO
     * @param sizeType:课程大小类型 1：1对1 ONE_TO_ONE 2：1v2 ONE_TO_MANY （团课无需传）
     * @param capacity: 课次容量（团课无需传）
     * @param minCapacity:开课人数（团课无需传）
     * @return: 返回课程id和姓名数组
     **/
    public JSONArray getPersonalOrGroupCourseId(String courseType, String courseName, String categoryId, String sourceType, String sizeType, int capacity, int minCapacity, DataUserInfo...dataUserInfo) {
        JSONObject result = new JSONObject();
        JSONArray getNameAndId = new JSONArray();

        // 查询存量的课程
        if (courseType.equals("GROUP")) { // 查询的是团课
            result = getGroupClassPage("", 0, courseName, "",dataUserInfo);
            String total = result.getString("total");
            if (Integer.parseInt(total) > 0) {
                result = getGroupClassPage("", 0, courseName, "", dataUserInfo).getJSONArray("records").getJSONObject(0);
                String courseId = result.getString("brandCourseId");
                getNameAndId.add(courseId);
                getNameAndId.add(result.getString("courseName"));
            } else {
                getNameAndId.add(createGroupCourse(courseName, categoryId, sourceType,dataUserInfo));
                getNameAndId.add(courseName);
            }
        } else if (courseType.equals("PERSONAL")) { // 查询的是私教课
            result = getPersonalPage("", 0, courseName, "", "", "",dataUserInfo);
            String total = result.getString("total");
            if (Integer.parseInt(total) > 0) {
                result = getPersonalPage("", 0, courseName, "", sizeType, "").getJSONArray("records").getJSONObject(0);
                String courseId = result.getString("brandCourseId");
                getNameAndId.add(courseId);
                getNameAndId.add(result.getString("courseName"));
            } else {
                getNameAndId.add(createPersonalCourse(courseName, categoryId, sourceType, sizeType, capacity, minCapacity,dataUserInfo));
                getNameAndId.add(courseName);
            }
        }
        return getNameAndId;
    }


    /**
     * @description: 编辑课程状态
     * @author: xuyamei
     * @date:  2024/5/6 15:24
     * @param courseId:课程id
     * @param courseState：课程状态  启用ON, 停用OFF, 删除DELETE
     * @param checkOnly：是否只校验：true只做校验操作，false做修改操作
     * @return: 返回code，如果success 则允许删除
     **/
    public String modifyCourseStatus(String courseId,String courseState,boolean checkOnly){
        dataApi.setApiModule(ApiModule.Polar_Course)
                .setApiName("API_modifyCourseStatus")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONObject body= new JSONObject();
        body.put("brandCourseId", courseId);
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId()); // 场馆
        body.put("courseState",courseState);
        body.put("checkOnly",checkOnly); // 是否只校验
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result").getString("resultCode");

    }

    /**
     * @description:获取课次详情
     * @author: xuyamei
     * @date:  2024/5/6 16:19
     * @param courseId：课程id
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject getCourseDetail(String courseId){
        dataApi.setApiModule(ApiModule.Polar_Course)
                .setApiName("API_getCourseDetail")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONObject body= new JSONObject();
        body.put("brandCourseId", courseId);
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result");
    }

    /**
     * @description:团课列表
     * @author: xuyamei
     * @date:  2024/5/6 16:41
     * @param courseState ：课程状态 ON启用;OFF停用
     * @param current:页码
     * @param courseNameLike：课程名称
     * @param categoryId：课程分类id
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject getGroupClassPage(String courseState,int current,String courseNameLike,String categoryId,DataUserInfo...dataUserInfo){
        dataApi.setApiModule(ApiModule.Polar_Course)
                .setApiName("API_getGroupClassPage")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfo);

        JSONObject body= new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("current", current);
        body.put("size", 20);
        if (!courseState.equals("")){
            body.put("courseState",courseState); // 状态
        }
        body.put("courseNameLike",courseNameLike);
        if (!categoryId.equals("")){
            JSONArray categoryIds = new JSONArray();
            categoryIds.add(categoryId);
            body.put("categoryIds",categoryIds);
        }
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result");
    }

    /**
     * @description:获取私教课列表
     * @author: xuyamei
     * @date:  2024/5/6 16:59
     * @param courseState：课程状态
     * @param current：页码 第一页从0开始
     * @param courseNameLike：课程名称
     * @param categoryId：课程分类id
     * @param sizeType：私教模式 {"1对1":ONE_TO_ONE;"1对多":ONE_TO_MANY;}
     * @param coachId：教练id
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject getPersonalPage(String courseState,int current,String courseNameLike,String categoryId,String sizeType,String coachId,DataUserInfo...dataUserInfo){
        dataApi.setApiModule(ApiModule.Polar_Course)
                .setApiName("API_getPersonalPage")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfo);

        JSONObject body= new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("current", current);
        body.put("size", 20);
        if (!courseState.equals("")){
            body.put("courseState",courseState); // 状态
        }
        body.put("courseNameLike",courseNameLike);
        if (!categoryId.equals("")){
            JSONArray categoryIds = new JSONArray();
            categoryIds.add(categoryId);
            body.put("categoryIds",categoryIds);
        }
        if (!sizeType.equals("")){
            body.put("sizeType",sizeType);
        }
        if(!coachId.equals("")){
            body.put("coachId",coachId);
        }
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result");
    }


    /**
     * @description:校验场馆课程名称是否重复
     * @author: xuyamei
     * @date:  2024/5/6 18:17
     * @param courseName :课程名称
     * @return: boolean：返回false表示没有重复
     **/
    public boolean checkCourseNameDup(String courseName){
        dataApi.setApiModule(ApiModule.Polar_Course)
                .setApiName("API_checkCourseNameDup")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONObject body= new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("courseName",courseName);
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getBoolean("result");
    }

}
