package com.xiaomai.cases.polar.training;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.lunar.user.UserTools;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import javax.annotation.Resource;

public class TestTrainingPlanRecordCreate extends BaseTestImpl {
    @Resource(name="trainingTools")
    TrainingTools trainingTools;
    @Resource(name="userTools")
    UserTools userTools;

    DataUserInfo info = new DataUserInfo();
    String memberId;
    String templateId;

    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Training,"API_trainingPlanRecordCreate", LoginAccount.GYM_PROD, Terminal.B,"xyy");
        super.beforeTest();
    }

    @Test(description = "保存动作训练计划>查看计划>发送给学员>删除训练计划")
    public void testTrainingPlanRecordCreate_1()throws InterruptedException{
        info.setTerminal(Terminal.minApp);
        info.setLoginUser(LoginAccount.GYM_MINIAPPC);
        //1.获取会员id
        memberId = userTools.getMemberInfo(info).getString("memberId");

        //2.搜索动作,获取相关参数
        String exerciseId = trainingTools.getListByName("哑铃").getJSONArray("result").getJSONObject(0).getString("id");
        String exerciseName = trainingTools.getListByName("哑铃").getJSONArray("result").getJSONObject(0).getString("name");
        String trainExerciseType = trainingTools.getListByName("哑铃").getJSONArray("result").getJSONObject(0).getString("trainExerciseType");
        String muscle = trainingTools.getListByName("哑铃").getJSONArray("result").getJSONObject(0).getString("muscle");

        //3.构建动作组内容，以便后续创建训练计划时使用
        String content = "[{\"id\":\""+exerciseId+"\",\"name\":\""+exerciseName+"\",\"trainExerciseType\":\""+trainExerciseType+"\",\"muscle\":\""+muscle+"\",\"arrange\":[{\"timeAmount\":{\"num\":\"1\",\"unit\":\"times\"},\"weightAmount\":{\"num\":\"0.01\",\"unit\":\"KG\"}}]}]";

        String itemName = "热身运动";//模板内容标题
        String itemType = "EXERCISE";//模板内容类型
        //4.创建模板
        String templateName = "动作模板"+ RandomStringUtil.randomString(5);
        templateId = trainingTools.trainingTemplateCreate(itemType,itemName,templateName);
        //获取模板id、模板内容id、创建者、创建时间
        String templateItemId = XMJSONPath.readPath(trainingTools.trainingTemplateDetail(templateId),"$.result.templateItemList[0].templateItemId");
        String creatorName = XMJSONPath.readPath(trainingTools.trainingTemplateDetail(templateId),"$.result.creatorName");
        String lastUpdated = XMJSONPath.readPath(trainingTools.trainingTemplateDetail(templateId),"$.result.lastUpdated");

        //获取b端训练计划列表数据条数
        int num = Integer.parseInt(XMJSONPath.readPath(trainingTools.trainingPlanRecordPage(memberId,""),"$.result.total"));
        //5.创建训练计划
        String planName = "动作训练计划"+RandomStringUtil.randomString(5);
        //获取c端训练计划列表数据条数
        int total = Integer.parseInt(XMJSONPath.readPath(trainingTools.listMyTrainingPlan(memberId,planName,info),"$.result.total"));

        //构建template对象
        JSONArray templateItemList=new JSONArray();
        JSONObject item = new JSONObject();
        item.put("templateItemId",templateItemId);
        item.put("templateItemName",itemName);
        item.put("trainingTemplateItemType",itemType);
        templateItemList.add(item);

        JSONObject template = new JSONObject();
        template.put("templateId",templateId);
        template.put("templateName",templateName);
        template.put("templateItemList",templateItemList);
        template.put("creatorName",creatorName);
        template.put("lastModified",lastUpdated);

        //构建trainList
        JSONArray trainList = new JSONArray();
        JSONObject train = new JSONObject();
        train.put("name",itemName);
        train.put("content",content);
        train.put("trainingTemplateItemType",itemType);
        trainList.add(train);

        //构建请求
        JSONObject body = new JSONObject();
        body.put("memberId",memberId);
        body.put("trainingPlanName",planName);
        body.put("template",template);
        body.put("id","");
        body.put("sendStatus","UN_SEND");//保存
        body.put("templateId",templateId);
        body.put("templateName",templateName);
        body.put("trainingTemplateDetailList",trainList);
        body.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        body.put("creator",xmAppApi.getLoginInfo().getAdminId());
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());

        //调用请求
        xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers).assetsSuccess(true);
        String recordId = XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$.result");

        //检验b端学员名下数据+1
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(trainingTools.trainingPlanRecordPage(memberId,""),"$.result.total"))==num+1);
        //检验c端学员名下数据未变化
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(trainingTools.listMyTrainingPlan(memberId,planName,info),"$.result.total"))==total);

        //检验训练计划详情的状态为未发送，计划内容数据匹配创建值
        Assert.assertEquals(XMJSONPath.readPath(trainingTools.trainingPlanRecordDetail(recordId),"$.result.sendStatus"),"UN_SEND");
        Assert.assertEquals(XMJSONPath.readPath(trainingTools.trainingPlanRecordDetail(recordId),"$.result.itemDetailList[0].name"),itemName);
        Assert.assertEquals(XMJSONPath.readPath(trainingTools.trainingPlanRecordDetail(recordId),"$.result.itemDetailList[0].trainingTemplateItemType"),itemType);

        //操作发送给学员：训练计划状态从未发送变成已发送
        trainingTools.updateSendStatus(recordId);
        //检验训练计划详情的状态为已发送
        Assert.assertEquals(XMJSONPath.readPath(trainingTools.trainingPlanRecordDetail(recordId),"$.result.sendStatus"),"SEND");
        Thread.sleep(3000);
        //检验c端学员名下数据+1
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(trainingTools.listMyTrainingPlan(memberId,planName,info),"$.result.total"))==total+1);

        //检验c端训练记录详情
        Assert.assertEquals(XMJSONPath.readPath(trainingTools.findMyTrainingPlanDetailById(recordId,info),"$.result.studioId"),xmAppApi.getLoginInfo().getStudioId());
        Assert.assertEquals(XMJSONPath.readPath(trainingTools.findMyTrainingPlanDetailById(recordId,info),"$.result.trainingPlanName"),planName);
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(trainingTools.findMyTrainingPlanDetailById(recordId,info),"$.result.itemDetailList").size()>0);
        //检验c端分享的数据
        Assert.assertEquals(XMJSONPath.readPath(trainingTools.getShareDetail(recordId,info),"$.result.detail.trainingPlanName"),planName);
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(trainingTools.getShareDetail(recordId,info),"$.result.detail.itemDetailList").size()>0);

        //5.清理数据
        //删除训练计划
        trainingTools.trainingPlanRecordDelete(recordId);
        //检验训练计划列表数据跟初始保持一致
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(trainingTools.trainingPlanRecordPage(memberId,""),"$.result.total"))==num);
        //删除训练模板
        trainingTools.trainingTemplateDelete(templateId);
    }
    @DataProvider
    public Object[][] dataProvider() {
        return new Object[][]{
                {""},
                {"{\"items\":[{\"content\":\"自动化脚本生成的文本\",\"aspect\":\"\",\"type\":\"TEXT\"}]}"},
        };
    }
    @Test(description = "保存并发送图文训练计划>查看计划>编辑计划>删除训练计划",dataProvider = "dataProvider")
    public void testTrainingPlanRecordCreate_2(String content)throws InterruptedException{
        info.setTerminal(Terminal.minApp);
        info.setLoginUser(LoginAccount.GYM_MINIAPPC);

        //1.获取会员id
        memberId = userTools.getMemberInfo(info).getString("memberId");

        String itemName = "饮食搭配";//模板内容标题
        String itemType = "GRAPHIC";//模板内容类型

        //2.创建模板
        String templateName = "图文模板"+ RandomStringUtil.randomString(5);
        templateId = trainingTools.trainingTemplateCreate(itemType,itemName,templateName);
        //获取模板id、模板内容id、创建者、创建时间
        String templateItemId = XMJSONPath.readPath(trainingTools.trainingTemplateDetail(templateId),"$.result.templateItemList[0].templateItemId");
        String creatorName = XMJSONPath.readPath(trainingTools.trainingTemplateDetail(templateId),"$.result.creatorName");
        String lastUpdated = XMJSONPath.readPath(trainingTools.trainingTemplateDetail(templateId),"$.result.lastUpdated");

        //获取b端训练计划列表数据条数
        int num = Integer.parseInt(XMJSONPath.readPath(trainingTools.trainingPlanRecordPage(memberId,""),"$.result.total"));

        //训练计划名称
        String planName = "图文训练计划"+RandomStringUtil.randomString(5);
        //获取c端训练计划列表数据条数
        int total = Integer.parseInt(XMJSONPath.readPath(trainingTools.listMyTrainingPlan(memberId,planName,info),"$.result.total"));


        //构建template对象
        JSONArray templateItemList=new JSONArray();
        JSONObject item = new JSONObject();
        item.put("templateItemId",templateItemId);
        item.put("templateItemName",itemName);
        item.put("trainingTemplateItemType",itemType);
        templateItemList.add(item);

        JSONObject template = new JSONObject();
        template.put("templateId",templateId);
        template.put("templateName",templateName);
        template.put("templateItemList",templateItemList);
        template.put("creatorName",creatorName);
        template.put("lastModified",lastUpdated);

        //构建trainList
        JSONArray trainList = new JSONArray();
        JSONObject train = new JSONObject();
        train.put("name",itemName);
        train.put("content",content);
        train.put("trainingTemplateItemType",itemType);
        trainList.add(train);

        //3.构建请求
        JSONObject body = new JSONObject();
        body.put("memberId",memberId);
        body.put("trainingPlanName",planName);
        body.put("template",template);
        body.put("id","");
        body.put("sendStatus","SEND");//保存并发送
        body.put("templateId",templateId);
        body.put("templateName",templateName);
        body.put("trainingTemplateDetailList",trainList);
        body.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        body.put("creator",xmAppApi.getLoginInfo().getAdminId());
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());

        //调用请求
        xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers).assetsSuccess(true);
        String recordId = XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$.result");

        //检验b端学员名下数据+1
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(trainingTools.trainingPlanRecordPage(memberId,""),"$.result.total"))==num+1);
        Thread.sleep(3000);
        //检验c端学员名下数据+1
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(trainingTools.listMyTrainingPlan(memberId,planName,info),"$.result.total"))==total+1);

        //4.编辑模板
        String editName = "编辑训练计划"+RandomStringUtil.randomString(3);
        trainingTools.trainingPlanRecordEdit(memberId,content,editName,recordId,templateId,templateName,itemType,itemName);
        //检验编辑后的训练计划详情数据一致
        Assert.assertEquals(XMJSONPath.readPath(trainingTools.trainingPlanRecordDetail(recordId),"$.result.trainingPlanName"),editName);;


        //5.清理数据
        //删除训练计划
        trainingTools.trainingPlanRecordDelete(recordId);
        //检验训练计划列表数据跟初始保持一致
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(trainingTools.trainingPlanRecordPage(memberId,""),"$.result.total"))==num);
        //删除训练模板
        trainingTools.trainingTemplateDelete(templateId);
    }
}
