package com.xiaomai.cases.polar.admin;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.studioConfig.ConfigTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.Random;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.admin
 * @Author: xuyamei
 * @CreateTime: 2024-02-29  18:55
 * @Description: 员工复职
 * @Version: 1.0
 */
public class TestReinStateStudioAdmin extends BaseTestImpl {
    @Resource(name = "adminTools")
    AdminTools adminTools;
    @Resource(name = "configTools")
    ConfigTools configTools;
    @BeforeClass
    @Override
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Admin,"API_reinStateStudioAdmin", LoginAccount.GYM_PROD2, Terminal.B,"xym");
        super.beforeTest();
    }

    @Test
    public void testReinStateStudioAdmin() {
        // 获取离职员工
        String body = "{\"size\":10,\"current\":0,\"state\":\"LEFT\"}";
        JSONObject adminPage = adminTools.pageStudioAdmin(body);
        int total = Integer.parseInt(adminPage.getJSONObject("result").getString("total"));
        if (total>1){
            int pages = Integer.parseInt(adminPage.getJSONObject("result").getString("pages"));
            // 随机获取一页
            Random rand = new Random();
            int pageIndex = rand.nextInt(pages);
            // 随机获取一页的随机员工
            Random random = new Random();
            int index = pageIndex ==  pages ? random.nextInt(total%20-1)+1 : random.nextInt(19)+1;
            body = "{\"size\":20,\"current\":"+pageIndex+",\"state\":\"LEFT\"}";
            adminPage = adminTools.pageStudioAdmin(body);

            String adminId = adminPage.getJSONObject("result").getJSONArray("records").getJSONObject(index).getString("id");
            String phone = adminPage.getJSONObject("result").getJSONArray("records").getJSONObject(index).getString("phone");
            String name = adminPage.getJSONObject("result").getJSONArray("records").getJSONObject(index).getString("name");
            body = "{\"id\":\""+adminId+"\"}";
            xmAppApi.doRequest(RequestType.JSON,params,body,headers).assetsSuccess(true);
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            // check 1：用手机号查询离职员工是否有这个员工
            body = "{\"size\":10,\"current\":0,\"state\":\"DUTY\",\"searchContext\":\""+phone+"\"}";
            adminPage = adminTools.pageStudioAdmin(body);
            total = Integer.parseInt(adminPage.getJSONObject("result").getString("total"));
            Assert.assertEquals(total,1,"员工离职失败,用手机号查询离职员工未返回数据");

            try {
                Thread.sleep(12000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            // check 2: 生成对应的操作日志
            body = "{\"current\":0,\"size\":10,\"domainId\":\""+xmAppApi.getLoginInfo().getStudioId()+"\",\"content\": \""+name+"\",\"brandId\":\""+xmAppApi.getLoginInfo().getBrandId()+"\",\"studioId\": \""+xmAppApi.getLoginInfo().getStudioId()+"\",\"opEventKey\":\"RESTORE_ADMIN\"}";
            JSONObject response = configTools.getOpauditPage(body);
            Assert.assertEquals(response.getJSONObject("result").getJSONArray("records").getJSONObject(0).getJSONObject("target").getString("targetId"),adminId,"员工离职未生成操作日志");

        }


    }

}
