package com.xiaomai.cases.polar.clue;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author zxy
 * @Description
 * @Date 2024/6/30 14:40
 */
public class TestRecycle extends XMBaseTest {
    MemberTools memberTools = new MemberTools();
    String memberId;

    @BeforeMethod
    public void beforeTest(){

        xmAppApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_recycle")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("zyx")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "从私海回收线索")
    public void testRecycle(){
        String name = "自动化潜在会员"+ RandomStringUtil.randomString(3);
        String phone = RandomStringUtil.randomMobile("666");

        //查看私有池列表是否有数据,有数据则取第一条数据
        JSONArray array = memberTools.searchMember(1,"POTENTIAL").getJSONObject("result").getJSONArray("records");
        //查看全部线索是否有数据,有数据则取第一条数据
        JSONArray array1 = memberTools.searchMember(0,"POTENTIAL").getJSONObject("result").getJSONArray("records");

        int size = array.size();
        int size1 = array1.size();

        if(size != 0){
            memberId = array.getJSONObject(0).getString("id");//查看私有池列表是否有数据,有数据则取第一条数据
        }
        else if(size == 0 && size1 != 0){
            memberId = array1.getJSONObject(0).getString("id");//私有池无数据，全部线索有数据，则从全部线索取第一条数据
            //分配线索至私有池(只有私有池的线索才可以回收)
            memberTools.distributeToPrivate(memberId);
        }
        else {
            memberId = memberTools.create(name,phone).getString("result");//私有池和全部线索都无数据，则新建一个线索
            //分配线索至私有池(只有私有池的线索才可以回收)
            memberTools.distributeToPrivate(memberId);
        }

        List memberIds = new ArrayList();
        memberIds.add(memberId);

        try {
            Thread.sleep(2000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

        JSONObject object = new JSONObject();
        object.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        object.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        object.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        object.put("memberIds",memberIds);
        object.put("destination","INITIAL");

        xmAppApi.doRequest(RequestType.JSON,params,object.toString(),headers).assetsSuccess(true);

        JSONObject res = memberTools.findStudioMemberDetail(memberId).getJSONObject("result");
        Assert.assertEquals(res.getString("saleId"),"-1");
        Assert.assertEquals(res.getString("position"),"INITIAL");//线索位置：待分配池
    }
}
