package com.xiaomai.cases.polar.member;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.clue.MemberTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestForceUpdate extends XMBaseTest {

    Tools tools= new Tools();


    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_forceUpdate")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "编辑正式会员信息")
    public void  testForceUpdate() {


        JSONObject create=tools.create("编辑正式会员"+RandomStringUtil.randomString(3),RandomStringUtil.randomMobile("88"));
        String memberId=create.getString("result");

        //创建订单转成正式会员




        //编辑
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
        jsonObject.put("status", "POTENTIAL");
        jsonObject.put("name", "自动化正式会员" + RandomStringUtil.randomString(2));
        jsonObject.put("phone", RandomStringUtil.randomMobile("22"));
        jsonObject.put("gender", "WOMEN");
        jsonObject.put("wechat", RandomStringUtil.randomMobile("66"));
        jsonObject.put("birthday", TimeUtils.getBeforeDayDate(10));
        jsonObject.put("idCardType", "IDENTITY");
        jsonObject.put("idCardCode", "411421199808080225");
        jsonObject.put("height", "186");
        jsonObject.put("weight", "76");
        jsonObject.put("trainTarget", "塑形"+RandomStringUtil.randomString(2));
        jsonObject.put("profession", "金融"+RandomStringUtil.randomString(2));
        jsonObject.put("incomeLevel", "亿万富翁"+RandomStringUtil.randomString(2));
        jsonObject.put("address", "地址"+RandomStringUtil.randomString(6));
        jsonObject.put("emergencyContactPerson", RandomStringUtil.randomString(3));
        jsonObject.put("emergencyContactPhone", RandomStringUtil.randomMobile("66"));
        jsonObject.put("resourceId", "1");
        jsonObject.put("intention", "HIGH");
        jsonObject.put("creatorId", xmAppApi.getLoginInfo().getAdminId());
        jsonObject.put("remark", "备注"+RandomStringUtil.randomString(12));
        jsonObject.put("memberId", memberId);


        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);
        Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$success"),"true","编辑正式会员信息失败");


    }

}
