package com.xiaomai.cases.lunar.training;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.lunar.user.UserTools;
import com.xiaomai.cases.polar.training.TrainingTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.lunar.training
 * @Author: xuyamei
 * @CreateTime: 2024-07-31  15:03
 * @Description: 小程序训练营详情
 * @Version: 1.0
 */
public class TestTrainingFindDetailById extends BaseTestImpl {
    @Resource(name = "trainingCTools")
    TrainingCTools trainingCTools;
    @Resource(name = "userTools")
    UserTools userTools;

    @Resource(name = "trainingTools")
    TrainingTools trainingTools;

    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Lunar_Training,"API_findDetailById", LoginAccount.GYM_MINIAPPC, Terminal.minApp,"xym");
        super.beforeTest();
    }

    @Test
    public void testTrainingFindDetailById(){
        // 获取微信学员
        String memberId = userTools.getMemberInfo().getString("memberId");
        // 获取训练营活动
        String id = trainingCTools.getAppliableCampList("量训练营Ｃ端报名活动").getJSONObject(0).getString("id");
        JSONObject findDetailById = trainingCTools.findDetailById(id,memberId);
        String[] keys = {"id","studioId","state","title","courseId","openStartDate","openEndDate","totalClassHour","price","trainerIds"};

        trainingTools.findTrainingDetailById(id);
        JSONObject findTrainingDetailById = dataApi.getBodyInJSON().getJSONObject("result");
        for (int i = 0; i < keys.length; i++){
            Assert.assertEquals(findDetailById.getString(keys[i]),findTrainingDetailById.getString(keys[i]),"训练营详情返回值与B端对比内容不一致");
        }
    }
}
