package com.xiaomai.cases.polar.schedule.group;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.course.CourseTools;
import com.xiaomai.cases.polar.setting.courseCategory.CourseCategoryTools;
import com.xiaomai.cases.polar.setting.venue.VenueAreaTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.CommUtil;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.*;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 查看团课课表
 *
 * @author adu
 * data 2024/6/30 11:19
 */

public class TestGetGroupScheduleTable extends BaseTestImpl {
    @Resource(name = "courseCategoryTools")
    CourseCategoryTools courseCategoryTools;
    @Resource(name = "courseTools")
    CourseTools courseTools;
    @Resource(name = "groupScheduleTools")
    GroupScheduleTools groupScheduleTools;
    @Resource(name = "venueAreaTools")
    VenueAreaTools venueAreaTools;
    String courseName = "阿杜自动化团课课程";
    String courseId = "";
    String venueAreaId = "";
    String chiefCoachIdS = "";
    String assistCoachId1 = "";
    String assistCoachId2 = "";
    List<String> venueAreaIds = null;
    List<String> assistCoachIdS = null;



    @BeforeClass
    @Override
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Schedule, "API_getGroupScheduleTable", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();
        //获取存量课程ID
        courseId = groupScheduleTools.getStockGroupCourseId(courseName);
        if (courseId == "") {
            //获取存量课程分类ID
            String categoryId = courseCategoryTools.getCourseCategoryPage("普拉提");
            courseId = courseTools.createGroupCourse(courseName, categoryId, "STUDIO");
        }
        //获取存量场地
        venueAreaIds = groupScheduleTools.getStockArea("流星花园秘密基地");
        //获取存量教练
        List<String> chiefCoachId = new ArrayList<>();
        chiefCoachId.add("杜君丽");
        chiefCoachIdS = groupScheduleTools.getStudioAdminId(chiefCoachId).get(0).toString();
        //获取存量助教
        List<String> assistCoachIds = new ArrayList<>();
        assistCoachIds.add("木头");
        assistCoachIds.add("吴彦祖");
        assistCoachIdS = groupScheduleTools.getStudioAdminId(assistCoachIds);
        //1.创建排课
        groupScheduleTools.createGroupRuleSchedule(courseId, chiefCoachIdS, CommUtil.oneKeyGetWeekStartDay(), CommUtil.oneKeyGetWeekEndDay(), venueAreaIds, assistCoachIdS, false, 1, 480);
        //2.创建排课，构造冲突
        groupScheduleTools.createGroupRuleSchedule(courseId, chiefCoachIdS, CommUtil.oneKeyGetWeekStartDay(), CommUtil.oneKeyGetWeekEndDay(), venueAreaIds, assistCoachIdS, true, 1, 480);
        //获取存量场地
        venueAreaId = venueAreaIds.get(0).toString();
        //获取存量助教
        assistCoachId1 = assistCoachIdS.get(0).toString();
        assistCoachId2 = assistCoachIdS.get(1).toString();


    }

    @DataProvider(name = "filterGroupScheduleTableDateByCondition")
    public Object[][] dataProvider() {
        //组装已上课课次状态
        List<String> doneStatus = new ArrayList<>();
        doneStatus.add("IN_PROGRESS");
        doneStatus.add("DONE");
        //组装待上课课次状态
        List<String> todoStatus = new ArrayList<>();
        todoStatus.add("TODO");
        //组装已取消课次状态
        List<String> cancelledStatus = new ArrayList<>();
        cancelledStatus.add("CANCELLED");

        return new Object[][]{
                {"", "", "", new ArrayList<>(),14},//无筛选条件
                {courseId, "", "", new ArrayList<>(),14},//根据课程
                {"", chiefCoachIdS, "", new ArrayList<>(),14},//根据主教练
                {"", assistCoachId1, "", new ArrayList<>(),14},//根据助教1
                {"", assistCoachId2, "", new ArrayList<>(),14},//根据助教2
                {"", "", venueAreaId, new ArrayList<>(),14},//根据场地
                {"", "", "", doneStatus,0},//根据课程状态已上课["IN_PROGRESS", "DONE"]
                {"", "", "", todoStatus,14},//根据课程状态待上课["TODO"]
                {"", "", "", cancelledStatus,0},//根据课程状态已取消["CANCELLED"]
                {"", chiefCoachIdS, venueAreaId, new ArrayList<>(),14},//根据场地和主教练
                {courseId, assistCoachId2, venueAreaId, new ArrayList<>(),14},//场地和助教，课程
                {courseId, chiefCoachIdS, venueAreaId, todoStatus,14},// 课程名称，教练，课次状态(待上课)，场地
        };
    }

    @Test(dataProvider = "filterGroupScheduleTableDateByCondition")
    public void testGetGroupScheduleTable(String courseId, String coachId, String venueAreaId, List<String> statusSet,int totalCount) {

        //1. 查看/筛选团课课表
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("startDate", CommUtil.oneKeyGetWeekStartDay());
        body.put("endDate", CommUtil.oneKeyGetWeekEndDay());
        body.put("courseId", courseId);
        body.put("coachId", coachId);
        body.put("venueAreaId", venueAreaId);
        body.put("statusSet", statusSet);
        xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(xmAppApi.getApi_response(),"$.success"))==true,"调用接口返回结果："+XMJSONPath.readPath(xmAppApi.getApi_response(),"$.message"));

        int resultCount=Integer.parseInt(XMJSONPath.readPath(xmAppApi.getApi_response(),"$.result.totalCount"));
        Assert.assertTrue(resultCount>=totalCount,"查询到的课表数据和预期不一致");


    }
    @Test(description = "删除此case创建的日程",priority = 1)
    public void delData(){
        List<String> ruleIdIds = new ArrayList<>();
        //查询这个case创建的相关日程
        JSONArray result = groupScheduleTools.getGroupRuleScheduleList(courseId, chiefCoachIdS);
        int count = result.size();
        if (count > 0) {//如果有数据，则获取对应日程ID
            ruleIdIds = result.stream().map(obj -> {
                        JSONObject ruldIdInfo = (JSONObject) obj;
                        return ruldIdInfo.getString("ruleId");
                    }
            ).collect(Collectors.toList());
        }
        if (ruleIdIds != null) {//获取到的日程ID不为空时，则逐个删除相关日程
            ruleIdIds.stream().forEach(ruleId -> {
                //删除对应日程
                groupScheduleTools.delGroupRuleSchedule(ruleId, true);

            });
        }


    }
}

    