package com.xiaomai.cases.polar.charts;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;

import java.util.ArrayList;
import java.util.List;

public class ChartsTools extends BaseTestImpl {
    /**
     * @param
     * @description:会员排行榜列表
     * @author: yangjian
     * @param memberRankType 月、季度、年

     **/
    public JSONObject fetchPageOfMemberRank(String memberRankType,long startDate,long endDate, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Charts)
                .setApiName("API_fetchPageOfMemberRank")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("memberRankType", memberRankType);//MONTH 、SEASON、YEAR
        jsonObject.put("startDate", startDate);
        jsonObject.put("endDate", endDate);
        jsonObject.put("size", 20);
        jsonObject.put("current", 0);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }
    /**
     * @param
     * @description:会员排行榜列表搜索
     * @author: yangjian
     * @param memberRankType 月、季度、年
     * @param memberId 需要列表搜搜索的会员ID

     **/
    public JSONObject fetchPageOfMemberRankofmember(String memberRankType,String memberId,long startDate,long endDate, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Charts)
                .setApiName("API_fetchPageOfMemberRank")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("memberRankType", memberRankType);//MONTH 、SEASON、YEAR
        jsonObject.put("startDate", startDate);
        jsonObject.put("endDate", endDate);
        jsonObject.put("memberId", memberId);
        jsonObject.put("size", 20);
        jsonObject.put("current", 0);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:会员排行榜规则查看
     * @author: yangjian

     **/
    public JSONObject findRule(DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Charts)
                .setApiName("API_findRule")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:设置默认规则设置
     * @author: yangjian
     * @param reward 奖励规则


     **/
    public JSONObject memberRankListsaveRule1(String reward,String monthRandThreshold,DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Charts)
                .setApiName("API_memberRankListsaveRule")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        List<String> rankPosterResourceIdList = new ArrayList<>();//三张系统默认图
        rankPosterResourceIdList.add("1914597066483085313");
        rankPosterResourceIdList.add("1914597080835993602");
        rankPosterResourceIdList.add("1914597094131937282");

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());
        jsonObject.put("openSeasonRank", "NO");
        jsonObject.put("openYearRank", "NO");
        jsonObject.put("rankBackgroundResourceId", "1914596968827105282");//推广背景图,给了固定的推广图
        jsonObject.put("rankPosterResourceIdList", rankPosterResourceIdList);//榜单海报图
        jsonObject.put("reward", reward);//奖励规则
        jsonObject.put("monthRandThreshold", monthRandThreshold);//上月榜条件
        jsonObject.put("monthRankTitle", "内卷自动化");//月榜自定义名称

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:会员排行榜规则保存
     * @author: yangjian
     * @param openSeasonRank 季度榜是否开启 YES开启；NO关闭
     * @param openYearRank 年度榜是否开启 YES开启；NO关闭
     * @param reward 奖励规则
     * @param openYearRank 奖励规则

     **/
    public JSONObject memberRankListsaveRule(String openSeasonRank,String openYearRank,String reward,String monthRandThreshold,String monthRankTitle,String seasonRankThreshold,String seasonRankTitle,String yearRankThreshold,String yearRankTitle,DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Charts)
                .setApiName("API_memberRankListsaveRule")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        List<String> rankPosterResourceIdList = new ArrayList<>();//三张系统默认图
        rankPosterResourceIdList.add("1914597066483085313");
        rankPosterResourceIdList.add("1914597080835993602");
        rankPosterResourceIdList.add("1914597094131937282");

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());
        jsonObject.put("openSeasonRank", openSeasonRank);//季度榜 YES开启；NO关闭
        jsonObject.put("openYearRank", openYearRank);//年度榜单 YES开启；NO关闭
        jsonObject.put("rankBackgroundResourceId", "1914596968827105282");//推广背景图,给了固定的推广图
        jsonObject.put("rankPosterResourceIdList", rankPosterResourceIdList);//榜单海报图
        jsonObject.put("reward", reward);//奖励规则
        jsonObject.put("monthRandThreshold", monthRandThreshold);//上月榜条件
        jsonObject.put("monthRankTitle", monthRankTitle);//月榜自定义名称
        jsonObject.put("seasonRankThreshold", seasonRankThreshold);//上季度榜条件
        jsonObject.put("seasonRankTitle", seasonRankTitle);//季度榜自定义名称
        jsonObject.put("yearRankThreshold", yearRankThreshold);//上年度榜条件
        jsonObject.put("yearRankTitle", yearRankTitle);//年榜自定义名称

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:会员排行榜导出
     * @author: yangjian
     * @param memberRankType MONTH 、SEASON、YEAR分别是月榜、季度、年榜的导出

     **/
    public JSONObject memberRankList_export(String memberRankType,long startDate,long endDate, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Charts)
                .setApiName("API_memberRankList_export")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("memberRankType", memberRankType);
        jsonObject.put("startDate", startDate);
        jsonObject.put("endDate", endDate);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }
}
