package com.xiaomai.cases.polar.eleContract;

import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.eleContract
 * @Author: xuyamei
 * @CreateTime: 2024-08-05  13:54
 * @Description: 获取单个合同模板
 * @Version: 1.0
 */
public class TestGetTemplate extends BaseTestImpl {
    @Resource(name = "eleContractTools")
    EleContractTools eleContractTools;

    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_EleContract,"API_getTemplate", LoginAccount.DZHT_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @Test
    public void testGetTemplate(){
        String id = eleContractTools.getNormalTemplateList("").getJSONObject(0).getString("id");
        String body = "{\"id\":\""+id+"\"}";
        xmAppApi.doRequest(RequestType.JSON,params,body,headers).assetsSuccess(true);
        Assert.assertEquals(xmAppApi.getBodyInJSON().getJSONObject("result").getString("id"),id);
    }
}
