package com.xiaomai.cases.polar.goods;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.lunar.goods.GoodCTools;
import com.xiaomai.cases.polar.goods.Tools.GoodTools;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.math.RoundingMode;

public class TestModifyGoods extends XMBaseTest {
    GoodTools goodTools=new GoodTools();
    GoodCTools goodCTools=new GoodCTools();

    String createGoodsId;


    DataUserInfo info =new DataUserInfo();



    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModule.Polar_Goods)
                .setApiName("API_modifyGoods")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "编辑物品")
    public void testModifyGoods() {

        //切换端位
        info.setTerminal(Terminal.minApp);
        info.setLoginUser(LoginAccount.GYM_MINIAPPC);


        String name="自动化编辑后单规格";

        //case1：单规格改单规格

        //创建了一个单规格&启用&开启小程序售卖
        JSONObject createGoods=goodTools.createGoods_single("YES","0.01",10);
        createGoodsId=createGoods.getString("result");

        //修改物品状态为关闭
        JSONObject modifyGoodsState=goodTools.modifyGoodsState(createGoodsId,"NO");


        //单规格修改成单规格
        //物品名称重名校验：为false才是不重名
        boolean checkRepeatNameForStudio=Boolean.parseBoolean(goodTools.checkRepeatNameForStudio(name).getString("result"));

        if(checkRepeatNameForStudio==false) {

            JSONObject jsonObject = new JSONObject();
            //商品介绍不为空，纯文本
            JSONObject description = new JSONObject();
            JSONArray items = new JSONArray();
            JSONObject item1 = new JSONObject();
            item1.put("type", "TEXT");
            item1.put("content", "自动化编辑后单规格");
            item1.put("aspect", "");

            items.add(item1);

            description.put("items", items);
            jsonObject.put("description", description.toString());

            jsonObject.put("groupId", "1873903328974499841");
            JSONArray images=new JSONArray();
            jsonObject.put("images",images);
            jsonObject.put("multiSpec", false);
            jsonObject.put("name", name);
            jsonObject.put("xcxSaleState", "YES");
            JSONObject jsonObject2 = new JSONObject();

            jsonObject2.put("inventory", "100");
            jsonObject2.put("price", "0.09");

            jsonObject.put("singleSpecInfo", jsonObject2);
            jsonObject.put("id",createGoodsId);
            jsonObject.put("brandId", xmAppApi.getLoginInfo().getBrandId());
            jsonObject.put("studioId", xmAppApi.getLoginInfo().getStudioId());
            jsonObject.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
            xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);


            //校验1：修改后字段：获取B端物品详情
            JSONObject getDetail_goods=goodTools.getDetail_goods(createGoodsId).getJSONObject("result");
            Assert.assertEquals(getDetail_goods.getString("name"),"自动化编辑后单规格","编辑物品名称但详情非编辑后的物品名称");
            Assert.assertEquals(getDetail_goods.getJSONObject("group").getString("id"),"1873903328974499841","编辑物品分组但详情非编辑后的分组");
            Assert.assertEquals(getDetail_goods.getBoolean("multiSpec").booleanValue(),false,"编辑成单规格但详情非编辑后的单规格");
            Assert.assertEquals(getDetail_goods.getString("state"),"YES","编辑成单规格成功后但详情非编辑后的启用状态");
            Assert.assertEquals(getDetail_goods.getString("xcxSaleState"),"YES","编辑成单规格成功后但详情非编辑后的开启小程序售卖");
            Assert.assertEquals(getDetail_goods.getString("inventory"),"100","编辑成单规格成功后但详情总库存非编辑后的100");
            Assert.assertEquals(getDetail_goods.getJSONObject("singleSpecInfo").getString("inventory"),"100","编辑成单规格成功后但详情库存非编辑后的100");
            Assert.assertEquals(getDetail_goods.getJSONObject("singleSpecInfo").getBigDecimal("price").setScale(2, RoundingMode.HALF_UP).toString(),"0.09","编辑成单规格成功后但详情价格非编辑后的0.09");


            //校验2：修改后字段：获取C端物品详情
            JSONObject getDetail_goodsC=goodCTools.getDetail_goods_C(createGoodsId,info).getJSONObject("result");
            Assert.assertEquals(getDetail_goodsC.getString("name"),"自动化编辑后单规格","编辑物品名称但详情非编辑后的物品名称");
            Assert.assertEquals(getDetail_goodsC.getJSONObject("group").getString("id"),"1873903328974499841","编辑物品分组但详情非编辑后的分组");
            Assert.assertEquals(getDetail_goodsC.getBoolean("multiSpec").booleanValue(),false,"编辑成单规格但详情非编辑后的单规格");
            Assert.assertEquals(getDetail_goodsC.getString("state"),"YES","编辑成单规格成功后但详情非编辑后的启用状态");
            Assert.assertEquals(getDetail_goodsC.getString("xcxSaleState"),"YES","编辑成单规格成功后但详情非编辑后的开启小程序售卖");
            Assert.assertEquals(getDetail_goodsC.getString("inventory"),"100","编辑成单规格成功后但详情总库存非编辑后的100");
            Assert.assertEquals(getDetail_goodsC.getJSONObject("singleSpecInfo").getString("inventory"),"100","编辑成单规格成功后但详情库存非编辑后的100");
            Assert.assertEquals(getDetail_goodsC.getJSONObject("singleSpecInfo").getBigDecimal("price").setScale(2, RoundingMode.HALF_UP).toString(),"0.09","编辑成单规格成功后但详情价格非编辑后的0.09");

            //校验3：获取B端物品列表
            JSONObject afterStudioGoods = goodTools.studioGoods("");
            JSONArray records = afterStudioGoods.getJSONObject("result").getJSONArray("records");
            boolean success=false;
            for (int i = 0; i < records.size(); i++) {
                if (records.getJSONObject(i).getString("name").equals(name)) {
                    success=true;
                    break;
                }
            }
            Assert.assertEquals(success, true, "物品列表中有此编辑后的物品名称");

            //校验4：获取C端物品列表
            JSONObject afterStudioGoodsC = goodCTools.pageXcxHomeGoodsC(info);
            JSONArray recordsC = afterStudioGoodsC.getJSONObject("result").getJSONArray("records");
            boolean successC=false;
            for (int i = 0; i < recordsC.size(); i++) {
                if (recordsC.getJSONObject(i).getString("name").equals(name)) {
                    successC=true;
                    break;
                }
            }
            Assert.assertEquals(successC, true, "C端物品列表中有此编辑后的物品名称");

            //校验5：生成一条编辑记录，类型为编辑物品
            JSONObject pageGoodsModifyRecord=goodTools.pageGoodsModifyRecord(createGoodsId);
            String pageGoodsModifyRecordResult=pageGoodsModifyRecord.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("type");
            Assert.assertEquals(pageGoodsModifyRecordResult,"MODIFY","创建多规格物品后，未生成类型为编辑物品的编辑记录");


            try {
                Thread.sleep(5000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }

            //case2：单规格改多规格

            String name1="自动化编辑后多规格";

            //校验5：获取编辑记录
            JSONObject beforePageGoodsModifyRecord1=goodTools.pageGoodsModifyRecord(createGoodsId);
            int beforeTotal1=Integer.parseInt(beforePageGoodsModifyRecord1.getJSONObject("result").getString("total"));

            //修改物品状态为关闭
            JSONObject modifyGoodsState1=goodTools.modifyGoodsState(createGoodsId,"NO");

            //单规格修改成单规格
            //物品名称重名校验：为false才是不重名
            boolean checkRepeatNameForStudio1=Boolean.parseBoolean(goodTools.checkRepeatNameForStudio(name1).getString("result"));

            if(checkRepeatNameForStudio1==false) {

                String color1 = "黑色";
                String color2 = "白色";
                String size1 = "大的";
                String size2 = "小的";
                String skin1 = "貂蝉";
                String skin2 = "王昭君";

                JSONObject jsonObject1 = new JSONObject();
                //商品介绍为空
                // JSONObject description=new JSONObject();
                // jsonObject.put("description",description.toString());

                //商品介绍不为空，纯文本
                JSONObject description1 = new JSONObject();
                JSONArray items1 = new JSONArray();
                JSONObject item11 = new JSONObject();
                item11.put("type", "TEXT");
                item11.put("content", "自动化编辑后的多规格三个规格，每个规格都有两个规格值");
                item11.put("aspect", "");

                items1.add(item11);

                description1.put("items", items1);
                jsonObject1.put("description", description1.toString());

                JSONArray images1=new JSONArray();
                jsonObject1.put("images",images1);
                jsonObject1.put("groupId", "1873912725360504834");
                jsonObject1.put("multiSpec", true);
                jsonObject1.put("name", name1);
                jsonObject1.put("xcxSaleState", "YES");


                JSONObject multiSpecInfo = new JSONObject();

                //设置三个规格和每个都有两个规格值
                JSONArray specList = new JSONArray();
                JSONObject specList1 = new JSONObject();
                specList1.put("name", "颜色");

                JSONArray specList1SpecValues = new JSONArray();
                JSONObject specList1SpecValues1 = new JSONObject();
                specList1SpecValues1.put("name", color1);
                JSONObject specList1SpecValues2 = new JSONObject();
                specList1SpecValues2.put("name", color2);
                specList1SpecValues.add(specList1SpecValues1);
                specList1SpecValues.add(specList1SpecValues2);
                specList1.put("specValues", specList1SpecValues);

                JSONObject specList2 = new JSONObject();
                specList2.put("name", "尺码");

                JSONArray specList2SpecValues = new JSONArray();
                JSONObject specList2SpecValues1 = new JSONObject();
                specList2SpecValues1.put("name", size1);
                JSONObject specList2SpecValues2 = new JSONObject();
                specList2SpecValues2.put("name", size2);
                specList2SpecValues.add(specList2SpecValues1);
                specList2SpecValues.add(specList2SpecValues2);
                specList2.put("specValues", specList2SpecValues);


                JSONObject specList3 = new JSONObject();
                specList3.put("name", "限定皮肤");

                JSONArray specList3SpecValues = new JSONArray();
                JSONObject specList3SpecValues1 = new JSONObject();
                specList3SpecValues1.put("name", skin1);
                JSONObject specList3SpecValues2 = new JSONObject();
                specList3SpecValues2.put("name", skin2);
                specList3SpecValues.add(specList3SpecValues1);
                specList3SpecValues.add(specList3SpecValues2);
                specList3.put("specValues", specList3SpecValues);

                specList.add(specList1);
                specList.add(specList2);
                specList.add(specList3);

                multiSpecInfo.put("specList", specList);


                try {
                    Thread.sleep(3000);
                } catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }

                //排列出来的组合2*2*2
                JSONArray specCombinationList = new JSONArray();

                JSONObject specCombinationList1 = new JSONObject();

                JSONArray specCombinationList1Specs = new JSONArray();
                specCombinationList1Specs.add(color1);
                specCombinationList1Specs.add(size1);
                specCombinationList1Specs.add(skin1);
                specCombinationList1.put("specs", specCombinationList1Specs);
                specCombinationList1.put("price", "0.01");
                specCombinationList1.put("inventory", 10);

                specCombinationList.add(specCombinationList1);

                JSONObject specCombinationList2 = new JSONObject();
                JSONArray specCombinationList2Specs = new JSONArray();
                specCombinationList2Specs.add(color1);
                specCombinationList2Specs.add(size1);
                specCombinationList2Specs.add(skin2);
                specCombinationList2.put("specs", specCombinationList2Specs);
                specCombinationList2.put("price", "0.01");
                specCombinationList2.put("inventory", 10);

                specCombinationList.add(specCombinationList2);


                JSONObject specCombinationList3 = new JSONObject();
                JSONArray specCombinationList3Specs = new JSONArray();
                specCombinationList3Specs.add(color1);
                specCombinationList3Specs.add(size2);
                specCombinationList3Specs.add(skin1);
                specCombinationList3.put("specs", specCombinationList3Specs);
                specCombinationList3.put("price", "0.01");
                specCombinationList3.put("inventory", 10);

                specCombinationList.add(specCombinationList3);


                JSONObject specCombinationList4 = new JSONObject();
                JSONArray specCombinationList4Specs = new JSONArray();
                specCombinationList4Specs.add(color1);
                specCombinationList4Specs.add(size2);
                specCombinationList4Specs.add(skin2);
                specCombinationList4.put("specs", specCombinationList4Specs);
                specCombinationList4.put("price", "0.01");
                specCombinationList4.put("inventory", 10);

                specCombinationList.add(specCombinationList4);


                JSONObject specCombinationList5 = new JSONObject();
                JSONArray specCombinationList5Specs = new JSONArray();
                specCombinationList5Specs.add(color2);
                specCombinationList5Specs.add(size1);
                specCombinationList5Specs.add(skin1);
                specCombinationList5.put("specs", specCombinationList5Specs);
                specCombinationList5.put("price", "0.01");
                specCombinationList5.put("inventory", 10);

                specCombinationList.add(specCombinationList5);


                JSONObject specCombinationList6 = new JSONObject();
                JSONArray specCombinationList6Specs = new JSONArray();
                specCombinationList6Specs.add(color2);
                specCombinationList6Specs.add(size1);
                specCombinationList6Specs.add(skin2);
                specCombinationList6.put("specs", specCombinationList6Specs);
                specCombinationList6.put("price", "0.01");
                specCombinationList6.put("inventory", 10);

                specCombinationList.add(specCombinationList6);

                JSONObject specCombinationList7 = new JSONObject();
                JSONArray specCombinationList7Specs = new JSONArray();
                specCombinationList7Specs.add(color2);
                specCombinationList7Specs.add(size2);
                specCombinationList7Specs.add(skin1);
                specCombinationList7.put("specs", specCombinationList7Specs);
                specCombinationList7.put("price", "0.01");
                specCombinationList7.put("inventory", 10);

                specCombinationList.add(specCombinationList7);


                JSONObject specCombinationList8 = new JSONObject();
                JSONArray specCombinationList8Specs = new JSONArray();
                specCombinationList8Specs.add(color2);
                specCombinationList8Specs.add(size2);
                specCombinationList8Specs.add(skin2);
                specCombinationList8.put("specs", specCombinationList8Specs);
                specCombinationList8.put("price", "0.01");
                specCombinationList8.put("inventory", 10);

                specCombinationList.add(specCombinationList8);


                multiSpecInfo.put("specCombinationList", specCombinationList);
                jsonObject1.put("multiSpecInfo", multiSpecInfo);
                jsonObject1.put("id",createGoodsId);
                jsonObject1.put("brandId", xmAppApi.getLoginInfo().getBrandId());
                jsonObject1.put("studioId", xmAppApi.getLoginInfo().getStudioId());
                jsonObject1.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
                xmAppApi.doRequest(RequestType.JSON, params, jsonObject1.toJSONString(), headers).assetsSuccess(true);



                //校验1：修改后字段：获取B端物品详情
                JSONObject getDetail_goods1=goodTools.getDetail_goods(createGoodsId).getJSONObject("result");
                Assert.assertEquals(getDetail_goods1.getString("name"),"自动化编辑后多规格","编辑物品名称但详情非编辑后的物品名称");
                Assert.assertEquals(getDetail_goods1.getJSONObject("group").getString("id"),"1873912725360504834","编辑物品分组但详情非编辑后的分组");
                Assert.assertEquals(getDetail_goods1.getBoolean("multiSpec").booleanValue(),true,"编辑成多规格但详情非编辑后的多规格");
                Assert.assertEquals(getDetail_goods1.getString("state"),"YES","编辑成多规格成功后但详情非编辑后的启用状态");
                Assert.assertEquals(getDetail_goods1.getString("xcxSaleState"),"YES","编辑成多规格成功后但详情非编辑后的开启小程序售卖");
                Assert.assertEquals(getDetail_goods1.getString("inventory"),"80","编辑成多规格成功后但详情总库存非编辑后的80");


                //校验2：修改后字段：获取C端物品详情
                JSONObject getDetail_goodsC1=goodCTools.getDetail_goods_C(createGoodsId,info).getJSONObject("result");
                Assert.assertEquals(getDetail_goodsC1.getString("name"),"自动化编辑后多规格","编辑物品名称但详情非编辑后的物品名称");
                Assert.assertEquals(getDetail_goodsC1.getJSONObject("group").getString("id"),"1873912725360504834","编辑物品分组但详情非编辑后的分组");
                Assert.assertEquals(getDetail_goodsC1.getBoolean("multiSpec").booleanValue(),true,"编辑成多规格但详情非编辑后的多规格");
                Assert.assertEquals(getDetail_goodsC1.getString("state"),"YES","编辑成多规格成功后但详情非编辑后的启用状态");
                Assert.assertEquals(getDetail_goodsC1.getString("xcxSaleState"),"YES","编辑成多规格成功后但详情非编辑后的开启小程序售卖");
                Assert.assertEquals(getDetail_goodsC1.getString("inventory"),"80","编辑成多规格成功后但详情总库存非编辑后的80");

                //校验3：获取B端物品列表
                JSONObject afterStudioGoods1 = goodTools.studioGoods("");
                JSONArray records1 = afterStudioGoods1.getJSONObject("result").getJSONArray("records");
                boolean success1=false;
                for (int i = 0; i < records1.size(); i++) {
                    if (records1.getJSONObject(i).getString("name").equals(name1)) {
                        success1=true;
                        break;
                    }
                }
                Assert.assertEquals(success1, true, "物品列表中有此编辑后的物品名称");

                //校验4：获取C端物品列表
                JSONObject afterStudioGoodsC1 = goodCTools.pageXcxHomeGoodsC(info);
                JSONArray recordsC1 = afterStudioGoodsC1.getJSONObject("result").getJSONArray("records");
                boolean successC1=false;
                for (int i = 0; i < recordsC1.size(); i++) {
                    if (recordsC1.getJSONObject(i).getString("name").equals(name1)) {
                        successC1=true;
                        break;
                    }
                }
                Assert.assertEquals(successC1, true, "C端物品列表中有此编辑后的物品名称");

                //校验5：生成一条编辑记录，类型为编辑物品
                JSONObject pageGoodsModifyRecord1=goodTools.pageGoodsModifyRecord(createGoodsId);
                int afterTotal1=Integer.parseInt(pageGoodsModifyRecord1.getJSONObject("result").getString("total"));
                String pageGoodsModifyRecordResult1=pageGoodsModifyRecord1.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("type");
                Assert.assertEquals(pageGoodsModifyRecordResult1,"MODIFY","创建多规格物品后，未生成类型为编辑物品的编辑记录");
                Assert.assertEquals(afterTotal1,beforeTotal1+1,"编辑成功后未生成编辑记录");

                try {
                    Thread.sleep(5000);
                } catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }



                //case3：多规格改多规格

                String name2="自动化编辑后一个规格";

                //校验5：获取编辑记录
                JSONObject beforePageGoodsModifyRecord2=goodTools.pageGoodsModifyRecord(createGoodsId);
                int beforeTotal2=Integer.parseInt(beforePageGoodsModifyRecord2.getJSONObject("result").getString("total"));

                //修改物品状态为关闭
                JSONObject modifyGoodsState2=goodTools.modifyGoodsState(createGoodsId,"NO");

                String color11 = "黑色";
                String color22 = "白色";
                String name66="颜色";

                //获取规格名/规格值修改后的物品规格列表
                JSONObject listModifiedSpecCombinations=goodTools.listModifiedSpecCombinations(createGoodsId,"",name66,"",color11,"",color22);
                String specs1=listModifiedSpecCombinations.getJSONArray("result").getJSONObject(0).getJSONArray("specs").getString(0);
                String specs2=listModifiedSpecCombinations.getJSONArray("result").getJSONObject(1).getJSONArray("specs").getString(0);
                Assert.assertEquals(specs1,color11,"修改后的物品规格列表和修改的规格值不一致");
                Assert.assertEquals(specs2,color22,"修改后的物品规格列表和修改的规格值不一致");



                //物品名称重名校验：为false才是不重名
                boolean checkRepeatNameForStudio2=Boolean.parseBoolean(goodTools.checkRepeatNameForStudio(name2).getString("result"));

                if(checkRepeatNameForStudio2==false) {



                    JSONObject jsonObject3 = new JSONObject();
                    //商品介绍为空
                    // JSONObject description=new JSONObject();
                    // jsonObject.put("description",description.toString());

                    //商品介绍不为空，纯文本
                    JSONObject description2 = new JSONObject();
                    JSONArray items2 = new JSONArray();
                    JSONObject item22 = new JSONObject();
                    item22.put("type", "TEXT");
                    item22.put("content", "自动化编辑后的多规格一个规格，每个规格有两个规格值");
                    item22.put("aspect", "");

                    items2.add(item22);

                    description2.put("items", items2);
                    jsonObject3.put("description", description2.toString());

                    JSONArray images2 = new JSONArray();
                    jsonObject3.put("images", images2);

                    jsonObject3.put("groupId", "1873912725360504834");
                    jsonObject3.put("multiSpec", true);
                    jsonObject3.put("name", name2);
                    jsonObject3.put("xcxSaleState", "YES");


                    JSONObject multiSpecInfo1 = new JSONObject();

                    //设置一个规格有两个规格值
                    JSONArray specList6 = new JSONArray();
                    JSONObject specList66 = new JSONObject();
                    specList66.put("name", name66);

                    JSONArray specList6SpecValues = new JSONArray();
                    JSONObject specList6SpecValues1 = new JSONObject();
                    specList6SpecValues1.put("name", color11);
                    JSONObject specList6SpecValues2 = new JSONObject();
                    specList6SpecValues2.put("name", color22);
                    specList6SpecValues.add(specList6SpecValues1);
                    specList6SpecValues.add(specList6SpecValues2);
                    specList66.put("specValues", specList6SpecValues);

                    specList6.add(specList66);

                    multiSpecInfo1.put("specList", specList6);


                    try {
                        Thread.sleep(3000);
                    } catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }

                    //排列出来的组合1*2
                    JSONArray specCombinationList9 = new JSONArray();

                    JSONObject specCombinationList99 = new JSONObject();

                    JSONArray specCombinationList9Specs = new JSONArray();
                    specCombinationList9Specs.add(color11);
                    specCombinationList99.put("specs", specCombinationList9Specs);
                    specCombinationList99.put("price", "0.02");
                    specCombinationList99.put("inventory", 10);

                    specCombinationList9.add(specCombinationList99);


                    JSONObject specCombinationList1010 = new JSONObject();
                    JSONArray specCombinationList10Specs = new JSONArray();
                    specCombinationList10Specs.add(color22);
                    specCombinationList1010.put("specs", specCombinationList10Specs);
                    specCombinationList1010.put("price", "0.02");
                    specCombinationList1010.put("inventory", 10);

                    specCombinationList9.add(specCombinationList1010);


                    multiSpecInfo1.put("specCombinationList", specCombinationList9);
                    jsonObject3.put("multiSpecInfo", multiSpecInfo1);
                    jsonObject3.put("id", createGoodsId);
                    jsonObject3.put("brandId", xmAppApi.getLoginInfo().getBrandId());
                    jsonObject3.put("studioId", xmAppApi.getLoginInfo().getStudioId());
                    jsonObject3.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
                    xmAppApi.doRequest(RequestType.JSON, params, jsonObject3.toJSONString(), headers).assetsSuccess(true);


                    //校验1：修改后字段：获取B端物品详情
                    JSONObject getDetail_goods2 = goodTools.getDetail_goods(createGoodsId).getJSONObject("result");
                    Assert.assertEquals(getDetail_goods2.getString("name"), "自动化编辑后一个规格", "编辑物品名称但详情非编辑后的物品名称");
                    Assert.assertEquals(getDetail_goods2.getJSONObject("group").getString("id"), "1873912725360504834", "编辑物品分组但详情非编辑后的分组");
                    Assert.assertEquals(getDetail_goods2.getBoolean("multiSpec").booleanValue(), true, "编辑成多规格但详情非编辑后的多规格");
                    Assert.assertEquals(getDetail_goods2.getString("state"), "YES", "编辑成多规格成功后但详情非编辑后的启用状态");
                    Assert.assertEquals(getDetail_goods2.getString("xcxSaleState"), "YES", "编辑成多规格成功后但详情非编辑后的开启小程序售卖");
                    Assert.assertEquals(getDetail_goods2.getString("inventory"), "20", "编辑成多规格成功后但详情总库存非编辑后的20");


                    //校验2：修改后字段：获取C端物品详情
                    JSONObject getDetail_goodsC2 = goodCTools.getDetail_goods_C(createGoodsId, info).getJSONObject("result");
                    Assert.assertEquals(getDetail_goodsC2.getString("name"), "自动化编辑后一个规格", "编辑物品名称但详情非编辑后的物品名称");
                    Assert.assertEquals(getDetail_goodsC2.getJSONObject("group").getString("id"), "1873912725360504834", "编辑物品分组但详情非编辑后的分组");
                    Assert.assertEquals(getDetail_goodsC2.getBoolean("multiSpec").booleanValue(), true, "编辑成多规格但详情非编辑后的多规格");
                    Assert.assertEquals(getDetail_goodsC2.getString("state"), "YES", "编辑成多规格成功后但详情非编辑后的启用状态");
                    Assert.assertEquals(getDetail_goodsC2.getString("xcxSaleState"), "YES", "编辑成多规格成功后但详情非编辑后的开启小程序售卖");
                    Assert.assertEquals(getDetail_goodsC2.getString("inventory"), "20", "编辑成多规格成功后但详情总库存非编辑后的20");

                    //校验3：获取B端物品列表
                    JSONObject afterStudioGoods2 = goodTools.studioGoods("");
                    JSONArray records2 = afterStudioGoods2.getJSONObject("result").getJSONArray("records");
                    boolean success2 = false;
                    for (int i = 0; i < records2.size(); i++) {
                        if (records2.getJSONObject(i).getString("name").equals(name2)) {
                            success2 = true;
                            break;
                        }
                    }
                    Assert.assertEquals(success2, true, "物品列表中有此编辑后的物品名称");


                    //校验4：获取C端物品列表
                    JSONObject afterStudioGoodsC2 = goodCTools.pageXcxHomeGoodsC(info);
                    JSONArray recordsC2 = afterStudioGoodsC2.getJSONObject("result").getJSONArray("records");
                    boolean successC2 = false;
                    for (int i = 0; i < recordsC2.size(); i++) {
                        if (recordsC2.getJSONObject(i).getString("name").equals(name2)) {
                            successC2 = true;
                            break;
                        }
                    }
                    Assert.assertEquals(successC2, true, "C端物品列表中有此编辑后的物品名称");

                    //校验5：生成一条编辑记录，类型为编辑物品
                    JSONObject pageGoodsModifyRecord2 = goodTools.pageGoodsModifyRecord(createGoodsId);
                    int afterTotal2 = Integer.parseInt(pageGoodsModifyRecord2.getJSONObject("result").getString("total"));
                    String pageGoodsModifyRecordResult2 = pageGoodsModifyRecord2.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("type");
                    Assert.assertEquals(pageGoodsModifyRecordResult2, "MODIFY", "创建多规格物品后，未生成类型为编辑物品的编辑记录");
                    Assert.assertEquals(afterTotal2, beforeTotal2 + 1, "编辑成功后未生成编辑记录");



                    try {
                        Thread.sleep(5000);
                    } catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }


                    String name3="自动化多规格编辑为单";

                    //case4：多规格改单规格

                    //校验5：获取编辑记录
                    JSONObject beforePageGoodsModifyRecord3=goodTools.pageGoodsModifyRecord(createGoodsId);
                    int beforeTotal3=Integer.parseInt(beforePageGoodsModifyRecord3.getJSONObject("result").getString("total"));

                    //修改物品状态为关闭
                    JSONObject modifyGoodsState3=goodTools.modifyGoodsState(createGoodsId,"NO");

                    //物品名称重名校验：为false才是不重名
                    boolean checkRepeatNameForStudio3=Boolean.parseBoolean(goodTools.checkRepeatNameForStudio(name3).getString("result"));

                    if(checkRepeatNameForStudio3==false) {

                        JSONObject jsonObject4= new JSONObject();
                        //商品介绍不为空，纯文本
                        JSONObject description3 = new JSONObject();
                        JSONArray items3 = new JSONArray();
                        JSONObject item33 = new JSONObject();
                        item33.put("type", "TEXT");
                        item33.put("content", "自动化多规格编辑成单规格");
                        item33.put("aspect", "");
                        items3.add(item33);
                        description3.put("items", items3);
                        jsonObject4.put("description", description3.toString());

                        jsonObject4.put("groupId", "1873903328974499841");
                        JSONArray images3 = new JSONArray();
                        jsonObject4.put("images", images3);
                        jsonObject4.put("multiSpec", false);

                        jsonObject4.put("name", name3);
                        jsonObject4.put("xcxSaleState", "YES");
                        JSONObject jsonObject5 = new JSONObject();

                        jsonObject5.put("inventory", "100");
                        jsonObject5.put("price", "0.09");

                        jsonObject4.put("singleSpecInfo", jsonObject5);
                        jsonObject4.put("id", createGoodsId);
                        jsonObject4.put("brandId", xmAppApi.getLoginInfo().getBrandId());
                        jsonObject4.put("studioId", xmAppApi.getLoginInfo().getStudioId());
                        jsonObject4.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
                        xmAppApi.doRequest(RequestType.JSON, params, jsonObject4.toJSONString(), headers).assetsSuccess(true);


                        //校验1：修改后字段：获取B端物品详情
                        JSONObject getDetail_goods3 = goodTools.getDetail_goods(createGoodsId).getJSONObject("result");
                        Assert.assertEquals(getDetail_goods3.getString("name"), "自动化多规格编辑为单", "编辑物品名称但详情非编辑后的物品名称");
                        Assert.assertEquals(getDetail_goods3.getJSONObject("group").getString("id"), "1873903328974499841", "编辑物品分组但详情非编辑后的分组");
                        Assert.assertEquals(getDetail_goods3.getBoolean("multiSpec").booleanValue(), false, "编辑成单规格但详情非编辑后的单规格");
                        Assert.assertEquals(getDetail_goods3.getString("state"), "YES", "编辑成单规格成功后但详情非编辑后的启用状态");
                        Assert.assertEquals(getDetail_goods3.getString("xcxSaleState"), "YES", "编辑成单规格成功后但详情非编辑后的开启小程序售卖");
                        Assert.assertEquals(getDetail_goods3.getString("inventory"), "100", "编辑成单规格成功后但详情总库存非编辑后的100");
                        Assert.assertEquals(getDetail_goods3.getJSONObject("singleSpecInfo").getString("inventory"), "100", "编辑成单规格成功后但详情库存非编辑后的100");
                        Assert.assertEquals(getDetail_goods3.getJSONObject("singleSpecInfo").getBigDecimal("price").setScale(2, RoundingMode.HALF_UP).toString(), "0.09", "编辑成单规格成功后但详情价格非编辑后的0.09");


                        //校验2：修改后字段：获取C端物品详情
                        JSONObject getDetail_goodsC3 = goodCTools.getDetail_goods_C(createGoodsId, info).getJSONObject("result");
                        Assert.assertEquals(getDetail_goodsC3.getString("name"), "自动化多规格编辑为单", "编辑物品名称但详情非编辑后的物品名称");
                        Assert.assertEquals(getDetail_goodsC3.getJSONObject("group").getString("id"), "1873903328974499841", "编辑物品分组但详情非编辑后的分组");
                        Assert.assertEquals(getDetail_goodsC3.getBoolean("multiSpec").booleanValue(), false, "编辑成单规格但详情非编辑后的单规格");
                        Assert.assertEquals(getDetail_goodsC3.getString("state"), "YES", "编辑成单规格成功后但详情非编辑后的启用状态");
                        Assert.assertEquals(getDetail_goodsC3.getString("xcxSaleState"), "YES", "编辑成单规格成功后但详情非编辑后的开启小程序售卖");
                        Assert.assertEquals(getDetail_goodsC3.getString("inventory"), "100", "编辑成单规格成功后但详情总库存非编辑后的100");
                        Assert.assertEquals(getDetail_goodsC3.getJSONObject("singleSpecInfo").getString("inventory"), "100", "编辑成单规格成功后但详情库存非编辑后的100");
                        Assert.assertEquals(getDetail_goodsC3.getJSONObject("singleSpecInfo").getBigDecimal("price").setScale(2, RoundingMode.HALF_UP).toString(), "0.09", "编辑成单规格成功后但详情价格非编辑后的0.09");

                        //校验3：获取B端物品列表
                        JSONObject afterStudioGoods3 = goodTools.studioGoods("");
                        JSONArray records3 = afterStudioGoods3.getJSONObject("result").getJSONArray("records");
                        boolean success3 = false;
                        for (int i = 0; i < records3.size(); i++) {
                            if (records3.getJSONObject(i).getString("name").equals(name3)) {
                                success3 = true;
                                break;
                            }
                        }
                        Assert.assertEquals(success3, true, "物品列表中有此编辑后的物品名称");

                        //校验4：获取C端物品列表
                        JSONObject afterStudioGoodsC3 = goodCTools.pageXcxHomeGoodsC(info);
                        JSONArray recordsC3 = afterStudioGoodsC3.getJSONObject("result").getJSONArray("records");
                        boolean successC3 = false;
                        for (int i = 0; i < recordsC3.size(); i++) {
                            if (recordsC3.getJSONObject(i).getString("name").equals(name3)) {
                                successC3 = true;
                                break;
                            }
                        }
                        Assert.assertEquals(successC3, true, "C端物品列表中有此编辑后的物品名称");

                        //校验5：生成一条编辑记录，类型为编辑物品
                        JSONObject pageGoodsModifyRecord3 = goodTools.pageGoodsModifyRecord(createGoodsId);
                        int afterTotal3 = Integer.parseInt(pageGoodsModifyRecord3.getJSONObject("result").getString("total"));
                        String pageGoodsModifyRecordResult3 = pageGoodsModifyRecord3.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("type");
                        Assert.assertEquals(pageGoodsModifyRecordResult3, "MODIFY", "创建多规格物品后，未生成类型为编辑物品的编辑记录");
                        Assert.assertEquals(afterTotal3, beforeTotal3 + 1, "编辑成功后未生成编辑记录");

                    }
                    else {
                        System.out.println("编辑物品时，物品名称重复");
                    }
                    }
                else {
                    System.out.println("编辑物品时，物品名称重复");
                }

                }
            else {
                System.out.println("编辑物品时，物品名称重复");
            }

        }
        else {
            System.out.println("编辑物品时，物品名称重复");
        }



    }
    @Test(description = "删除物品",priority = 1)
    public void delete(){
        goodTools.deleteGoods(createGoodsId);
    }
}
