package com.xiaomai.cases.polar.charts;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;

public class ChartsMinTools extends BaseTestImpl {
    /**
     * @param
     * @description:小程序-会员排行榜规则查看
     * @author: yangjian

     **/
    public JSONObject findRuleMin(DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Lunar_Charts)
                .setApiName("API_findRuleMin")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());


        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:查看小程序排行榜列表
     * @author: yangjian

     **/
    public JSONObject fetchMemberRankList(String memberRankType,DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Lunar_Charts)
                .setApiName("API_fetchMemberRankList")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("size", 20);
        jsonObject.put("current", 0);
        jsonObject.put("memberRankType", memberRankType);//MONTH 、SEASON、YEAR
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());


        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:小程序-当前账号排行榜排行
     * @author: yangjian

     **/
    public JSONObject fetchOneMemberRank(String memberRankType,String memberId,long startDate,long endDate,DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Lunar_Charts)
                .setApiName("API_fetchOneMemberRank")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("memberRankType", memberRankType);//MONTH 、SEASON、YEAR
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("memberId", memberId);//查询的会员
        jsonObject.put("startDate", startDate);
        jsonObject.put("endDate", endDate);


        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:小程序-排行榜分享详情
     * @author: yangjian
     * @param rankOrder 排行名次
     * @param checkInCount 上课节数

     **/
    public JSONObject getShareDetail(String recordId,String activeTab,String rankOrder,String checkInCount,DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Lunar_Training)
                .setApiName("API_getShareDetail")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(dataUserInfos);

        JSONObject extJson = new JSONObject();
        extJson.put("studioId",dataApi.getLoginInfo().getStudioId());
        extJson.put("brandId",dataApi.getLoginInfo().getBrandId());
        extJson.put("activeTab",activeTab);//MONTH 、SEASON、YEAR
        extJson.put("activeLabel","thisMonth");//本月，其他有（上月、本季度、上季度、本年、上年）
        extJson.put("rankOrder",rankOrder);
        extJson.put("checkInCount",checkInCount);


        JSONObject jsonObject = new JSONObject();
        jsonObject.put("bizId", recordId);
        jsonObject.put("shareType","MEMBER_RANK");
        jsonObject.put("extJson", extJson);



        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

}
