package com.xiaomai.cases.polar.points;

import com.xiaomai.cases.polar.training.TrainingTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;

public class TestBatchPoints extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Points)
                .setApiName("API_batchClearPoint")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yangjian")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Resource(name = "pointsTools")
    PointsTools pointsTools;

    @Resource(name = "trainingTools")
    TrainingTools trainingTools;

    @Test(description = "品牌手动-积分")
    public void testBatchClearPoint() throws InterruptedException {
        String phone = "13357537209";
        String memberId = trainingTools.searchTargerMember(phone);

        //获取品牌初始会员的发放积分数、已使用积分数、剩余积分数
        int BetotalAwardBalance = Integer.parseInt(XMJSONPath.readPath(pointsTools.findAccountPagePermission("",memberId), "$.result.records[0].totalAwardBalance"));//发放积分数
        int BealreadyUsedBalance = Integer.parseInt(XMJSONPath.readPath(pointsTools.findAccountPagePermission("",memberId), "$.result.records[0].alreadyUsedBalance"));//已用积分数
        int BeleftBalance = Integer.parseInt(XMJSONPath.readPath(pointsTools.findAccountPagePermission("",memberId), "$.result.records[0].leftBalance"));//剩余积分数
        System.out.println("betotal--------"+BetotalAwardBalance);
        System.out.println("beuse--------"+BealreadyUsedBalance);
        System.out.println("beleft--------"+BeleftBalance);

        int before = Integer.parseInt(XMJSONPath.readPath(pointsTools.findStatementPagePermission(""), "$.result.total"));//积分记录列表总条数

        //品牌操作批量增加
        Thread.sleep(1000);
        pointsTools.batchAwardPoint("1",memberId,"");
        int AftotalAwardBalance1 = Integer.parseInt(XMJSONPath.readPath(pointsTools.findAccountPagePermission("",memberId), "$.result.records[0].totalAwardBalance"));//发放积分数
        int AfleftBalance1 = Integer.parseInt(XMJSONPath.readPath(pointsTools.findAccountPagePermission("",memberId), "$.result.records[0].leftBalance"));//剩余积分数
        System.out.println("aftotal1--------"+AftotalAwardBalance1);
        System.out.println("afleft1--------"+AfleftBalance1);
        Assert.assertEquals(AftotalAwardBalance1,BetotalAwardBalance+1);//断言发放积分数+1
        Assert.assertEquals(AfleftBalance1,BeleftBalance+1);//断言剩余积分数+1

        //核对积分记录
        Thread.sleep(1000);
        int after1 = Integer.parseInt(XMJSONPath.readPath(pointsTools.findStatementPagePermission(""), "$.result.total"));
        System.out.println("after1--------"+after1);
        Assert.assertEquals(after1,before+1);//断言积分记录+1条记录
        String str = Integer.toString(AfleftBalance1);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].transactionType"), "IN_MANUAL_GIVE", "第一条记录非手动增加记录");//断言列表第一条手动增加积分的记录
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].accountLeftBalance"), str, "积分记录明细中，剩余积分和积分帐户对不上");//断言积分记录中的剩余积分


        //品牌操作批量扣减
        Thread.sleep(1000);
        pointsTools.batchDeductPoint("1",memberId,"");//会员详情扣减1积分
        //核对积分帐户的积分的变化
        int AfalreadyUsedBalance2 = Integer.parseInt(XMJSONPath.readPath(pointsTools.findAccountPagePermission("",memberId), "$.result.records[0].alreadyUsedBalance"));//已使用积分积分数
        int AfleftBalance2 = Integer.parseInt(XMJSONPath.readPath(pointsTools.findAccountPagePermission("",memberId), "$.result.records[0].leftBalance"));//剩余积分数
        System.out.println("aftuse2--------"+AfalreadyUsedBalance2);
        System.out.println("afleft2--------"+AfleftBalance2);
        Assert.assertEquals(AfalreadyUsedBalance2,BealreadyUsedBalance+1);//断言已使用积分数+1
        Assert.assertEquals(AfleftBalance2,AfleftBalance1-1);//断言剩余积分数-1

        //核对积分记录
        Thread.sleep(1000);
        int after2 = Integer.parseInt(XMJSONPath.readPath(pointsTools.findStatementPagePermission(""), "$.result.total"));
        System.out.println("after2--------"+after2);
        Assert.assertEquals(after2,after1+1);//断言积分记录+1条记录
        String str1 = Integer.toString(AfleftBalance2);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].transactionType"), "OUT_MANUAL_DEDUCT", "第一条记录非手动扣减记录");//断言列表第一条手动扣减积分的记录
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].accountLeftBalance"), str1, "积分记录明细中，剩余积分和积分帐户对不上");//断言积分记录中的剩余积分


        //品牌操作批量清零
        Thread.sleep(1000);
        pointsTools.batchClearPoint(memberId,"");
        int AfleftBalance3 = Integer.parseInt(XMJSONPath.readPath(pointsTools.findAccountPagePermission("",memberId), "$.result.records[0].leftBalance"));//剩余积分数
        Assert.assertEquals(AfleftBalance3,0);//断言剩余积分数等于0



        //品牌积分导出

        pointsTools.exportAccount("");//积分帐户导出
        pointsTools.pageStudioExportRecord("");//查看导出记录
        Thread.sleep(2000);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].workflowName"), "导出会员积分账户", "未生成导出会员积分账户记录");//断言有导出记录

        pointsTools.exportStatement("");//积分记录导出
        pointsTools.pageStudioExportRecord("");//查看导出记录
        Thread.sleep(2000);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].workflowName"), "导出会员积分记录", "未生成导出会员积分记录");//断言有导出记录



    }
}
