package com.xiaomai.cases.lunar.minmembercard;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;

public class MinCardTools extends XMBaseTest {
    /**
     * @param
     * @description:小程序查看在售会员卡
     * @author: yangjian
     **/
    public JSONObject fetchOnSaleMemberCard(String title, DataUserInfo...dataUserInfos) {

        dataApi.setApiModule(ApiModule.Lunar_Card)
                .setApiName("API_fetchOnSaleMemberCard")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(dataUserInfos);


        JSONObject jsonObject = new JSONObject();
        //jsonObject.put("memberCardIds","");
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("title",title);

        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }
}
