package com.xiaomai.cases.polar.clue;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.studioConfig.HomeTools;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.Random;

/**
 * @Author zxy
 * @Description
 * @Date 2024/3/14 14:38
 */
public class TestCreate extends XMBaseTest {
    MemberTools memberTools = new MemberTools();
    HomeTools homeTools = new HomeTools();

    @BeforeMethod
    public void beforeTest(){

        xmAppApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_create")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("zyx")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "新增潜在会员")
    public void testCreate(){
        DataUserInfo dataUserInfo = new DataUserInfo();
        dataUserInfo.setTerminal(Terminal.B);
        dataUserInfo.setLoginUser(LoginAccount.GYM_PROD2);

        //首页数据概览-新增会员数
        int member = Integer.parseInt(homeTools.preview("本周").getJSONObject("result").getJSONArray("metrics").getJSONObject(0).getString("value"));
        //全部线索快捷筛选
        JSONObject res = memberTools.fetchQuickSearch().getJSONObject("result");
        int addToday = Integer.parseInt(res.getString("addToday"));
        int addThisWeek = Integer.parseInt(res.getString("addThisWeek"));
        int addThisMonth = Integer.parseInt(res.getString("addThisMonth"));

        //我的线索快捷筛选
        JSONObject response = memberTools.fetchMyQuickSearch().getJSONObject("result");
        int addToday_my = Integer.parseInt(response.getString("addToday"));
        int addThisWeek_my = Integer.parseInt(response.getString("addThisWeek"));
        int addThisMonth_my = Integer.parseInt(response.getString("addThisMonth"));

        Random random = new Random();
        String name = "自动化潜在会员"+ RandomStringUtil.randomString(3);
        String phone = RandomStringUtil.randomMobile("666");
        String[] idCardType = {"IDENTITY","SAR_PERMIT","idCardType"};//身份证、港澳通行证、护照
        String[] intention = {"HIGH","MIDDLE","LOW"};//意向度：高、中、低
        String code =  memberTools.findByObjectId().getJSONObject(random.nextInt(13)).getString("code");//线索来源列表

        //新建潜在会员时需先校验当前场馆及同品牌下的其他场馆是否存在相同手机号的线索
        Boolean duplicate = memberTools.checkPhoneDuplicate(phone,"").getJSONObject("result").getBoolean("duplicate");
        if(duplicate == false){
            JSONObject object = new JSONObject();
            object.put("brandId", xmAppApi.getLoginInfo().getBrandId());
            object.put("studioId", xmAppApi.getLoginInfo().getStudioId());
            object.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
            object.put("creatorId", xmAppApi.getLoginInfo().getAdminId());
            object.put("status", "POTENTIAL");
            object.put("name", name);
            object.put("phone", phone);
            object.put("gender", "UNKNOWN");
            object.put("wechat","12345678");
            object.put("birthday","1277654400000");
            object.put("idCardType",idCardType[random.nextInt(3)]);
            object.put("idCardCode",RandomStringUtil.randomNumber(18,"410526"));
            object.put("height","180");
            object.put("weight","66");
            object.put("trainTarget","减脂");
            object.put("profession","无");
            object.put("incomeLevel","66666/月");
            object.put("address","同人广场a座小麦助教");
            object.put("emergencyContactPerson","紧急联系人名字");
            object.put("emergencyContactPhone","15896688889");
            object.put("resourceId",code);
            object.put("intention",intention[random.nextInt(3)]);
            object.put("position","PRIVATE_RESOURCE");
            object.put("remark","这是备注");
            object.put("saleId",xmAppApi.getLoginInfo().getAdminId());

            xmAppApi.doRequest(RequestType.JSON, params, object.toString(), headers).assetsSuccess(true);
            String memberId = xmAppApi.getBodyInJSON().getString("result");
            Assert.assertEquals(memberTools.getDetailById(memberId).getJSONObject("result").getString("phone"),phone);

            try {
                Thread.sleep(3000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            //校验潜在会员列表第一条数据是否是本次新增的数据
            Assert.assertEquals(memberTools.searchMember("全部线索","POTENTIAL").getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("phone"), phone);
            //根据手机号全局搜索检验
            Assert.assertEquals(memberTools.commonSearch(phone).getJSONArray("result").getJSONObject(0).getString("id"), memberId);
            //校验今日新增、本周新增、本月新增的会员数是否加1
            JSONObject res1 = memberTools.fetchQuickSearch().getJSONObject("result");
            int addToday1 = Integer.parseInt(res1.getString("addToday"));
            int addThisWeek1 = Integer.parseInt(res1.getString("addThisWeek"));
            int addThisMonth1 = Integer.parseInt(res1.getString("addThisMonth"));
            Assert.assertEquals(addToday1,addToday+1);//快捷筛选今日新增+1
            Assert.assertEquals(addThisWeek1,addThisWeek+1);//快捷筛选本周新增+1
//            Assert.assertEquals(addThisMonth1,addThisMonth+1);//快捷筛选本月新增+1

            //校验我的线索今日新增、本周新增、本月新增的会员数是否加1
            JSONObject response1 = memberTools.fetchMyQuickSearch().getJSONObject("result");
            int addToday_my1 = Integer.parseInt(response1.getString("addToday"));
            int addThisWeek_my1 = Integer.parseInt(response1.getString("addThisWeek"));
            int addThisMonth_my1 = Integer.parseInt(response1.getString("addThisMonth"));
            Assert.assertEquals(addToday_my1,addToday_my+1);//我的快捷筛选今日新增+1
            Assert.assertEquals(addThisWeek_my1,addThisWeek_my+1);//我的快捷筛选本周新增+1
//            Assert.assertEquals(addThisMonth_my1,addThisMonth_my+1);//我的快捷筛选本月新增+1

            //首页数据概览-新增会员数
            int member1 = Integer.parseInt(homeTools.preview("本周").getJSONObject("result").getJSONArray("metrics").getJSONObject(0).getString("value"));
            Assert.assertEquals(member1,member+1);//新增会员数+1

            //在另一个场馆添加该会员,并在添加后校验是否添加成功
            memberTools.join(memberId,dataUserInfo);

            try {
                Thread.sleep(2000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            Assert.assertEquals(memberTools.getDetailById(memberId,dataUserInfo).getJSONObject("result").getString("phone"),phone);

        }

    }

    @Test(description = "新增潜在会员-手机号为空")
    public void testCreate_1(){
        String name = "自动化潜在会员"+ RandomStringUtil.randomString(3);

        JSONObject object = new JSONObject();
        object.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        object.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        object.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
        object.put("creatorId", xmAppApi.getLoginInfo().getAdminId());
        object.put("status", "POTENTIAL");
        object.put("name", name);
        object.put("phone", "");
        object.put("gender", "UNKNOWN");

        xmAppApi.doRequest(RequestType.JSON, params, object.toString(), headers).assetsSuccess(false);
        String str = XMJSONPath.readPath(xmAppApi.getBodyInJSON(), "$.message");
        Assert.assertEquals(true, str.equals("会员手机号格式有误;会员手机号不能为空") || str.equals("会员手机号不能为空;会员手机号格式有误"));

    }
}
