package com.xiaomai.cases.polar.setting.rules;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.Random;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.setting.rules
 * @Author: xuyamei
 * @CreateTime: 2024-05-13  16:05
 * @Description: 保存规则
 * @Version: 1.0
 */
public class TestSaveGroupBookingRules extends BaseTestImpl {
    @Resource(name = "ruleTools")
    RuleTools ruleTools;
    @BeforeClass
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Setting,"API_saveGroupBookingRules", LoginAccount.GYM_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @DataProvider
    public Object[][] dataProvider(){
        Random random = new Random();
        int bookingSeatCount = random.nextInt(10)+1; // 席位
        return new Object[][]{
                {true,bookingSeatCount,true,true,random.nextInt(30)+10,true,random.nextInt(1000)+10,random.nextInt(5)+1,true,random.nextInt(1000)+10,"minutes",true,random.nextInt(1000)+10,"minutes"},
                {false,bookingSeatCount,false,false,random.nextInt(30)+10,false,random.nextInt(1000)+10,random.nextInt(5)+1,false,random.nextInt(1000)+10,"minutes",false,random.nextInt(1000)+10,"minutes"},
        };
    }
    @Test(dataProvider = "dataProvider")
    public void testSaveGroupBookingRules(boolean allowQueuing,int bookingSeatCount,boolean xcxAutoSignIn,boolean scanSignIn,int signInBeforeMinutes,
                                          boolean bookingStartRuleRequest,int startComingDayMinuteOffset,int startComingDays,boolean bookingEndRuleRequest,
                                          int endBeforeMinutes,String endBeforeUnit,boolean cancelBookingRuleRequest,int cancelBookingBeforeMinutes,String cancelBookingBeforeUnit) {

        JSONObject getRules = ruleTools.getGroupBookingRules(); // 获取场馆团课预约规则
        String id = getRules.getString("id"); // 获取规则id
        ruleTools.saveGroupBookingRules(id,allowQueuing,bookingSeatCount,xcxAutoSignIn,scanSignIn,signInBeforeMinutes,bookingStartRuleRequest,startComingDayMinuteOffset,startComingDays,bookingEndRuleRequest,endBeforeMinutes,endBeforeUnit,cancelBookingRuleRequest,cancelBookingBeforeMinutes,cancelBookingBeforeUnit);

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        getRules = ruleTools.getGroupBookingRules(); // 获取场馆团课预约规则
        for (int i = 0; i < 14; i++){
            Assert.assertEquals(getRules.getBooleanValue("allowQueuing"),allowQueuing);
            Assert.assertEquals(getRules.getIntValue("bookingSeatCount"),bookingSeatCount);
            Assert.assertEquals(getRules.getBooleanValue("xcxAutoSignIn"),xcxAutoSignIn);
            Assert.assertEquals(getRules.getBooleanValue("scanSignIn"),scanSignIn);
            Assert.assertEquals(getRules.getIntValue("signInBeforeMinutes"),signInBeforeMinutes);
            if (bookingStartRuleRequest){  // 预约时间限制
                Assert.assertEquals(getRules.getJSONObject("groupBookingStartRuleVO").getIntValue("bookingStartComingDays"),startComingDays);
                Assert.assertEquals(getRules.getJSONObject("groupBookingStartRuleVO").getIntValue("bookingStartComingDayMinuteOffset"),startComingDayMinuteOffset);

            }
            Assert.assertEquals(getRules.getJSONObject("groupBookingStartRuleVO").getBooleanValue("limit"),bookingStartRuleRequest);


            if (bookingEndRuleRequest){  // 截止预约时间限制
                Assert.assertEquals(getRules.getJSONObject("groupBookingEndRuleVO").getIntValue("bookingEndBeforeMinutes"),endBeforeMinutes);
                Assert.assertEquals(getRules.getJSONObject("groupBookingEndRuleVO").getString("bookingEndBeforeUnit"),endBeforeUnit);

            }
            Assert.assertEquals(getRules.getJSONObject("groupBookingEndRuleVO").getBooleanValue("limit"),bookingEndRuleRequest);


            if (cancelBookingRuleRequest){ // 取消预约限制
                Assert.assertEquals(getRules.getJSONObject("cancelGroupBookingRuleVO").getIntValue("cancelBookingBeforeMinutes"),cancelBookingBeforeMinutes);
                Assert.assertEquals(getRules.getJSONObject("cancelGroupBookingRuleVO").getString("cancelBookingBeforeUnit"),cancelBookingBeforeUnit);

            }
            Assert.assertEquals(getRules.getJSONObject("cancelGroupBookingRuleVO").getBooleanValue("limit"),cancelBookingRuleRequest);

        }
    }




}
