package com.xiaomai.cases.polar.course;

import com.alibaba.fastjson.JSONArray;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.setting.courseCategory.CourseCategoryTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import javax.annotation.Resource;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.course
 * @Author: xuyamei
 * @CreateTime: 2024-05-06  18:19
 * @Description: 校验课程名称重复
 * @Version: 1.0
 */
public class TestCheckCourseNameDup extends BaseTestImpl {
    @Resource(name = "courseCategoryTools")
    CourseCategoryTools courseCategoryTools;
    @Resource(name = "courseTools")
    CourseTools courseTools;
    @BeforeClass
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Course,"API_checkCourseNameDup", LoginAccount.GYM_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @DataProvider()
    public Object[][] data(){
        return new Object[][]{
                {"1对多名称是否重复校验哈哈哈哈哈哈哈",false,"校验名称重复不存在但返回了true"},
                {"课程",true,"校验名称重复存在但返回了false"}
        };
    }

    @Test(dataProvider = "data")
    public void testCheckCourseNameDup(String name,boolean isDup,String msg) {

        // 为了校验存在的课程名称返回的是否正确
        if(isDup){
            // 获取课程分类
            String categoryId = courseCategoryTools.getCourseCategoryPage("瑜伽");
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            JSONArray arr = courseTools.getPersonalOrGroupCourseId("GROUP",name,categoryId,"STUDIO","",2,1);
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            name = arr.getString(1);
        }
        Assert.assertEquals(courseTools.checkCourseNameDup(name),isDup,msg);
    }

}
