package com.xiaomai.cases.polar.finance.order;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;


public class OrderTools extends XMBaseTest {

    /**
     * @param
     * @description:获取会员详情-订单管理列表
     * @param supplierId：卖家ID 场馆ID
     * @param receiverId：会员ID
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject pageMemberVoucher(String supplierId,String receiverId,String brandId,String studioId,String operatorId,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_pageMemberVoucher")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("supplierId",supplierId);
        jsonObject.put("receiverId",receiverId);
        jsonObject.put("brandId",brandId);
        jsonObject.put("studioId",studioId);
        jsonObject.put("operatorId",operatorId);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:获取会员详情-订单管理金额统计
     * @param supplierId：卖家ID 场馆ID
     * @param receiverId：会员ID
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject sumMemberVoucherAmount(String supplierId,String receiverId,String brandId,String studioId,String operatorId,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_sumMemberVoucherAmount")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("supplierId",supplierId);
        jsonObject.put("receiverId",receiverId);
        jsonObject.put("brandId",brandId);
        jsonObject.put("studioId",studioId);
        jsonObject.put("operatorId",operatorId);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:获取会员详情-订单明细列表
     * @param supplierId：卖家ID 场馆ID
     * @param receiverId：会员ID
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject pageMemberVoucherItem(String supplierId,String receiverId,String brandId,String studioId,String operatorId,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_pageMemberVoucherItem")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("supplierId",supplierId);
        jsonObject.put("receiverId",receiverId);
        jsonObject.put("brandId",brandId);
        jsonObject.put("studioId",studioId);
        jsonObject.put("operatorId",operatorId);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description:获取订单管理-订单管理列表
     * @param supplierId：卖家ID 场馆ID
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @param businessNo：订单编号
     * @author: yangfangfang
     **/
    public JSONObject pageVoucher(String supplierId,String brandId,String studioId,String operatorId,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_pageVoucher")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("supplierId",supplierId);
        jsonObject.put("brandId",brandId);
        jsonObject.put("studioId",studioId);
        jsonObject.put("operatorId",operatorId);


        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:搜索订单管理-订单管理列表
     * @param supplierId：卖家ID 场馆ID
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @param businessNo：订单编号
     * @author: yangfangfang
     **/
    public JSONObject pageVoucher1(String supplierId,String brandId,String studioId,String operatorId,String businessNo,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_pageVoucher")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("supplierId",supplierId);
        jsonObject.put("brandId",brandId);
        jsonObject.put("studioId",studioId);
        jsonObject.put("operatorId",operatorId);
        jsonObject.put("businessNo",businessNo);


        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }



    /**
     * @param
     * @description:获取订单管理-订单管理金额统计
     * @param supplierId：卖家ID 场馆ID
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject sumVoucherAmount(String supplierId,String brandId,String studioId,String operatorId,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_sumVoucherAmount")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current", 0);
        jsonObject.put("size", 20);
        jsonObject.put("supplierId", supplierId);
        jsonObject.put("brandId", brandId);
        jsonObject.put("studioId", studioId);
        jsonObject.put("operatorId", operatorId);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:获取订单管理-订单明细列表
     * @param supplierId：卖家ID 场馆ID
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject pageVoucherItem(String supplierId,String brandId,String studioId,String operatorId,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_pageVoucherItem")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("supplierId",supplierId);
        jsonObject.put("brandId",brandId);
        jsonObject.put("studioId",studioId);
        jsonObject.put("operatorId",operatorId);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:获取订单管理-订单明细金额统计
     * @param supplierId：卖家ID 场馆ID
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject sumVoucherItemAmount(String supplierId,String brandId,String studioId,String operatorId,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_sumVoucherItemAmount")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("supplierId",supplierId);
        jsonObject.put("brandId",brandId);
        jsonObject.put("studioId",studioId);
        jsonObject.put("operatorId",operatorId);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description: 获取会员卡列表
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject fetchPageOfMemberCard(String brandId,String studioId,String operatorId,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_fetchPageOfMemberCard")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("title","");
        jsonObject.put("shelfState","YES");
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("brandId",brandId);
        jsonObject.put("studioId",studioId);
        jsonObject.put("operatorId",operatorId);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description: 获取会员卡详情
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject fetchDetailById(String id,String brandId,String studioId,String operatorId,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_fetchDetailById")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("id",id);
        jsonObject.put("brandId",brandId);
        jsonObject.put("studioId",studioId);
        jsonObject.put("operatorId",operatorId);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description: 检查会员对该卡是否超出购买上限
     * @param skuType:商品类型：[ MEMBER_CARD, TRAINING_CAMP, SINGLE_RESERVE, EXPERIENCE_CARD   "会员卡", "训练营", "单次约课", "体验卡"
     * @param skuId：场馆ID
     * @param memberId：会员ID
     * @param quantity：卡张数，默认为1
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject checkAllowPurchase(String skuType,String skuId,String memberId,String quantity,String brandId,String studioId,String operatorId,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_checkAllowPurchase")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("skuType",skuType);
        jsonObject.put("skuId",skuId);
        jsonObject.put("memberId",memberId);
        jsonObject.put("quantity",quantity);
        jsonObject.put("brandId",brandId);
        jsonObject.put("studioId",studioId);
        jsonObject.put("operatorId",operatorId);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }





    /**
     * @param
     * @description: 检查会员对该卡是否超出购买上限
     * @param cardId:卡id
     * @param cardSnapshotId：卡快照id
     * @param quantity：次数
     * @param price：卡的价格
     * @param validPeriod:有效期
     * @param deductionAmount:优惠金额
     * @param activatePattern:激活方式  [ "即时生效", "首次使用生效", "指定日期生效" ][ PURCHASE, FIRST_USED, SPECIFIC_DATE ]
     * @param commodityCardType:卡商品类型 [ MEMBER_CARD, TRAINING_CAMP, SINGLE_RESERVE, EXPERIENCE_CARD   "会员卡", "训练营", "单次约课", "体验卡"
     * @param memberId：会员ID
     * @param receivableAmount：应收金额  就是优惠之后的小计
     * @param amount：支付金额 支付信息输入的金额
     * @param paymentWay：支付方式
     * @author: yangfangfang
     **/

    public JSONObject signOrder(String cardId,String cardSnapshotId,int quantity,float price,int validPeriod,String latestSnapshotId,float deductionAmount,String activatePattern,
                                String commodityCardType,String memberId,float receivableAmount,float amount,String paymentWay,DataUserInfo...dataUserInfos){


        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_signOrder")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("salesmanId",dataApi.getLoginInfo().getAdminId());
        jsonObject.put("operationTime", TimeUtils.getCurrentTime());

        JSONObject card=new JSONObject();
        card.put("cardId",cardId);
        card.put("cardSnapshotId",cardSnapshotId);

        JSONObject cardChange=new JSONObject();
        cardChange.put("quantity",quantity);
        cardChange.put("price",price);
        cardChange.put("validPeriod",validPeriod);
        cardChange.put("latestSnapshotId",latestSnapshotId);


        card.put("cardChange",cardChange);
        card.put("deductionAmount",deductionAmount);//优惠金额（元）
        card.put("activatePattern",activatePattern);
        card.put("commodityCardType",commodityCardType);
        jsonObject.put("card",card);


        jsonObject.put("objectId", RandomStringUtil.randomString(20));
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("memberId",memberId);
        jsonObject.put("receivableAmount",receivableAmount);//应收金额
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        JSONArray paymentWays=new JSONArray();

        JSONObject object=new JSONObject();
        object.put("amount",amount);//支付金额
        object.put("paymentWay",paymentWay);
        JSONArray voucherResourceIds=new JSONArray();//支付凭证
        voucherResourceIds.add("");
        object.put("voucherResourceIds",voucherResourceIds);
        paymentWays.add(object);

        jsonObject.put("paymentWays",paymentWays);
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description: 获取订单详情
     * @param id:主键ID（创建订单获取的result）
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject getDetail(String id,String brandId,String studioId,String operatorId,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_getDetail")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("id",id);
        jsonObject.put("brandId",brandId);
        jsonObject.put("studioId",studioId);
        jsonObject.put("operatorId",operatorId);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description:获取订单支付/退款记录
     * @param id：主键ID 创建订单接口的result
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject listByVoucherId(String id, String brandId, String studioId, String operatorId, DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_listByVoucherId")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("id",id);
        jsonObject.put("brandId",brandId);
        jsonObject.put("studioId",studioId);
        jsonObject.put("operatorId",operatorId);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description:修改对内备注
     * @param voucherId：主键ID 创建订单接口的result  订单id
     * @param supplierInnerMemo：对内备注
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject modifySupplierInnerMemo(String voucherId,String supplierInnerMemo, String brandId, String studioId, String operatorId, DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_modifySupplierInnerMemo")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("voucherId",voucherId);
        jsonObject.put("supplierInnerMemo",supplierInnerMemo);
        jsonObject.put("brandId",brandId);
        jsonObject.put("studioId",studioId);
        jsonObject.put("operatorId",operatorId);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:修改对外备注
     * @param voucherId：主键ID 创建订单接口的result  订单id
     * @param supplierMemo：对外备注
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject modifySupplierMemo(String voucherId,String supplierMemo, String brandId, String studioId, String operatorId, DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_modifySupplierMemo")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("voucherId",voucherId);
        jsonObject.put("supplierMemo",supplierMemo);
        jsonObject.put("brandId",brandId);
        jsonObject.put("studioId",studioId);
        jsonObject.put("operatorId",operatorId);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:校验作废订单
     * @param id：主键ID 创建订单接口的result  订单id
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject checkDiscardVoucher(String id, String brandId, String studioId, String operatorId, DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_checkDiscardVoucher")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("id",id);
        jsonObject.put("brandId",brandId);
        jsonObject.put("studioId",studioId);
        jsonObject.put("operatorId",operatorId);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:作废订单
     * @param id：主键ID 创建订单接口的result  订单id
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject discard(String id,String discardCause,String discardMemo, String brandId, String studioId, String operatorId, DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_discard")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("id",id);
        jsonObject.put("discardCause",discardCause);
        jsonObject.put("discardMemo",discardMemo);
        jsonObject.put("brandId",brandId);
        jsonObject.put("studioId",studioId);
        jsonObject.put("operatorId",operatorId);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }



    /**
     * @param
     * @description:取消订单
     * @param id：主键ID 创建订单接口的result  订单id
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject cancel(String id, String brandId, String studioId, String operatorId, DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_cancel")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("id",id);
        jsonObject.put("brandId",brandId);
        jsonObject.put("studioId",studioId);
        jsonObject.put("operatorId",operatorId);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }


}
